/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import xaero.map.MapProcessor;
import xaero.map.file.export.PNGExportResult;
import xaero.map.gui.ConfigSettingEntry;
import xaero.map.gui.GuiSettings;
import xaero.map.gui.ISettingEntry;
import xaero.map.gui.MapTileSelection;
import xaero.map.gui.MySmallButton;
import xaero.map.settings.ModOptions;

public class ExportScreen
extends GuiSettings {
    private static final Component EXPORTING_MESSAGE = Component.m_237115_((String)"gui.xaero_export_screen_exporting");
    private final MapProcessor mapProcessor;
    private PNGExportResult result;
    private int stage;
    private final MapTileSelection selection;
    public boolean fullExport;

    public ExportScreen(Screen backScreen, Screen escScreen, MapProcessor mapProcessor, MapTileSelection selection) {
        super((Component)Component.m_237115_((String)"gui.xaero_export_screen"), backScreen, escScreen);
        this.mapProcessor = mapProcessor;
        this.selection = selection;
        this.entries = new ISettingEntry[]{new ConfigSettingEntry(ModOptions.FULL_EXPORT), new ConfigSettingEntry(ModOptions.MULTIPLE_IMAGES_EXPORT), new ConfigSettingEntry(ModOptions.NIGHT_EXPORT), new ConfigSettingEntry(ModOptions.EXPORT_HIGHLIGHTS), new ConfigSettingEntry(ModOptions.EXPORT_SCALE_DOWN_SQUARE)};
        this.canSearch = false;
        this.shouldAddBackButton = false;
    }

    @Override
    public void m_7856_() {
        if (this.stage > 0) {
            return;
        }
        super.m_7856_();
        this.m_142416_((GuiEventListener)new MySmallButton(this.f_96543_ / 2 - 155, this.f_96544_ / 6 + 168, (Component)Component.m_237110_((String)"gui.xaero_confirm", (Object[])new Object[0]), b -> {
            this.stage = 1;
            this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
        }));
        this.m_142416_((GuiEventListener)new MySmallButton(this.f_96543_ / 2 + 5, this.f_96544_ / 6 + 168, (Component)Component.m_237110_((String)"gui.xaero_cancel", (Object[])new Object[0]), b -> this.goBack()));
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int par1, int par2, float par3) {
        this.renderEscapeScreen(guiGraphics, par1, par2, par3);
        super.m_88315_(guiGraphics, par1, par2, par3);
        if (this.result != null) {
            guiGraphics.m_280653_(this.f_96541_.f_91062_, this.result.getMessage(), this.f_96543_ / 2, 20, -1);
        }
        if (this.stage > 0) {
            guiGraphics.m_280653_(this.f_96541_.f_91062_, EXPORTING_MESSAGE, this.f_96543_ / 2, this.f_96544_ / 6 + 68, -1);
            if (this.stage == 1) {
                this.stage = 2;
                return;
            }
        }
        if (this.stage != 2) {
            return;
        }
        if (this.mapProcessor.getMapSaveLoad().exportPNG(this, this.fullExport ? null : this.selection)) {
            this.stage = 3;
            this.result = null;
            for (GuiEventListener c : this.m_6702_()) {
                if (!(c instanceof Button)) continue;
                ((Button)c).f_93623_ = false;
            }
            return;
        }
        this.stage = 0;
        this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
    }

    public void onExportDone(PNGExportResult result) {
        this.result = result;
        this.stage = 0;
    }

    public MapTileSelection getSelection() {
        return this.selection;
    }
}

