/*
 * Decompiled with CFR 0.152.
 */
package com.lootbeams.vfx;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Trail {
    private Vec3[] points;
    private Vec3[] rotations;
    private int color;
    private Function<Float, Float> widthFunction;
    private int length = 100;
    private boolean billboard = true;
    private TilingMode tilingMode = TilingMode.STRETCH;
    private int frequency = 1;
    private float minDistance = 0.0f;
    private ResourceLocation texture = null;
    private boolean parentRotation = false;

    public Trail(Vec3[] points, int color, Function<Float, Float> widthFunction) {
        this.points = points;
        this.color = color;
        this.widthFunction = widthFunction;
    }

    public Trail(int color, Function<Float, Float> widthFunction) {
        this(new Vec3[]{Vec3.f_82478_}, color, widthFunction);
    }

    public void setParentRotation(boolean parentRotation) {
        this.parentRotation = parentRotation;
    }

    public void setTilingMode(TilingMode tilingMode) {
        this.tilingMode = tilingMode;
    }

    public void setTexture(ResourceLocation texture) {
        this.texture = texture;
    }

    public void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    public void setMinDistance(float minDistance) {
        this.minDistance = minDistance;
    }

    public void setPoints(Vec3[] points) {
        if (points.length > this.length) {
            Vec3[] newPoints = new Vec3[this.length];
            System.arraycopy(points, points.length - this.length, newPoints, 0, this.length);
            points = newPoints;
        }
        this.points = points;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setColor(float r, float g, float b, float a) {
        this.color = (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f) | (int)(a * 255.0f) << 24;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setBillboard(boolean billboard) {
        this.billboard = billboard;
    }

    public void setWidthFunction(Function<Float, Float> widthFunction) {
        this.widthFunction = widthFunction;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public int getLength() {
        return this.length;
    }

    public void pushPoint(Vec3 point) {
        if (this.points.length == 0) {
            this.points = new Vec3[]{point};
            return;
        }
        if (this.points[this.points.length - 1].m_82554_(point) < (double)this.minDistance) {
            return;
        }
        if (this.points[this.points.length - 1].equals((Object)point)) {
            return;
        }
        if (this.points[0] == Vec3.f_82478_) {
            this.points[0] = point;
            return;
        }
        Vec3[] newPoints = new Vec3[this.points.length + 1];
        System.arraycopy(this.points, 0, newPoints, 0, this.points.length);
        newPoints[this.points.length] = point;
        if (newPoints.length > this.length) {
            Vec3[] newPoints2 = new Vec3[this.length];
            System.arraycopy(newPoints, 1, newPoints2, 0, this.length);
            newPoints = newPoints2;
        }
        this.points = newPoints;
    }

    public void pushRotatedPoint(Vec3 point, Vec3 rotation) {
        if (this.points.length == 0) {
            this.points = new Vec3[]{point};
            this.rotations = new Vec3[]{rotation};
            return;
        }
        if (this.points[0] == Vec3.f_82478_) {
            this.points[0] = point;
            this.rotations = new Vec3[]{rotation};
            return;
        }
        if (this.points[this.points.length - 1].m_82554_(point) < (double)this.minDistance) {
            return;
        }
        if (this.points.length > 0 && this.points[this.points.length - 1].equals((Object)point)) {
            return;
        }
        if (this.rotations == null) {
            this.rotations = new Vec3[]{rotation};
        }
        Vec3[] newPoints = new Vec3[this.points.length + 1];
        Vec3[] newRotations = new Vec3[this.points.length + 1];
        System.arraycopy(this.points, 0, newPoints, 0, this.points.length);
        System.arraycopy(this.rotations, 0, newRotations, 0, this.rotations.length);
        newPoints[this.points.length] = point;
        newRotations[this.rotations.length] = rotation;
        if (newPoints.length > this.length) {
            Vec3[] newPoints2 = new Vec3[this.length];
            Vec3[] newRotations2 = new Vec3[this.length];
            System.arraycopy(newPoints, 1, newPoints2, 0, this.length);
            System.arraycopy(newRotations, 1, newRotations2, 0, this.length);
            newPoints = newPoints2;
            newRotations = newRotations2;
        }
        this.points = newPoints;
        this.rotations = newRotations;
    }

    public void render(PoseStack stack, VertexConsumer consumer, int light) {
        stack.m_85836_();
        RenderSystem.disableCull();
        Vector3f[][] corners = new Vector3f[this.points.length][2];
        for (int i = 0; i < this.points.length; ++i) {
            if (i % this.frequency != 0) continue;
            float width = this.widthFunction.apply(Float.valueOf((float)i / (float)(this.points.length - 1))).floatValue();
            Vector3f topOffset = new Vector3f(0.0f, width / 2.0f, 0.0f);
            Vector3f bottomOffset = new Vector3f(0.0f, -(width / 2.0f), 0.0f);
            if (this.billboard) {
                Vec3 point = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_().m_82546_(this.points[i]).m_82541_();
                Vector3f cameraDirection = new Vector3f((float)point.f_82479_, (float)point.f_82480_, (float)point.f_82481_);
                Vec3 dirToNext = this.points[Math.min(i + this.frequency, this.points.length - 1)].m_82546_(this.points[i]).m_82541_();
                Vector3f dirToNextPoint = new Vector3f((float)dirToNext.f_82479_, (float)dirToNext.f_82480_, (float)dirToNext.f_82481_);
                Vector3f axis = new Vector3f((Vector3fc)cameraDirection);
                axis.mul(-1.0f);
                axis.cross((Vector3fc)dirToNextPoint);
                topOffset = new Vector3f((Vector3fc)axis);
                topOffset.mul(width / 2.0f);
                bottomOffset = new Vector3f((Vector3fc)axis);
                bottomOffset.mul(-width / 2.0f);
            }
            topOffset.add((float)this.points[i].f_82479_, (float)this.points[i].f_82480_, (float)this.points[i].f_82481_);
            bottomOffset.add((float)this.points[i].f_82479_, (float)this.points[i].f_82480_, (float)this.points[i].f_82481_);
            corners[i / this.frequency][0] = topOffset;
            corners[i / this.frequency][1] = bottomOffset;
        }
        this.renderPoints(stack, consumer, light, corners, this.color);
        RenderSystem.enableCull();
        stack.m_85849_();
    }

    private void renderPoints(PoseStack stack, VertexConsumer consumer, int light, Vector3f[][] corners, int color) {
        stack.m_85836_();
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        for (int i = 0; i < corners.length - 1; ++i) {
            Vector3f top = corners[i][0];
            Vector3f bottom = corners[i][1];
            Vector3f nextTop = corners[i + 1][0];
            Vector3f nextBottom = corners[i + 1][1];
            if (nextTop == null || nextBottom == null || top == null || bottom == null) continue;
            float u = 0.0f;
            float u1 = 1.0f;
            if (this.tilingMode == TilingMode.STRETCH) {
                u = (float)i / (float)(corners.length - 1);
                u1 = (float)(i + 1) / (float)(corners.length - 1);
            }
            consumer.m_252986_(stack.m_85850_().m_252922_(), bottom.x(), bottom.y(), bottom.z()).m_85950_(r, g, b, a).m_7421_(u, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            consumer.m_252986_(stack.m_85850_().m_252922_(), top.x(), top.y(), top.z()).m_85950_(r, g, b, a).m_7421_(u, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            consumer.m_252986_(stack.m_85850_().m_252922_(), nextTop.x(), nextTop.y(), nextTop.z()).m_85950_(r, g, b, a).m_7421_(u1, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            consumer.m_252986_(stack.m_85850_().m_252922_(), nextBottom.x(), nextBottom.y(), nextBottom.z()).m_85950_(r, g, b, a).m_7421_(u1, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        }
        stack.m_85849_();
    }

    public static enum TilingMode {
        NONE,
        STRETCH,
        REPEAT;

    }
}

