/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.mutil.gui;

import java.awt.Color;
import net.minecraft.util.Mth;

public class ColorHelper {
    private static int withSaturation(int color, double saturation) {
        float[] hsl = new float[3];
        Color.RGBtoHSB(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, hsl);
        return Color.HSBtoRGB(hsl[0], (float)saturation, hsl[2]);
    }

    public static int multiplyBrightness(int color, double multiplier) {
        float[] hsl = new float[3];
        Color.RGBtoHSB(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, hsl);
        return Color.HSBtoRGB(hsl[0], hsl[1], Mth.m_14036_((float)((float)multiplier * hsl[2]), (float)0.0f, (float)1.0f));
    }

    public static int withBrightness(int color, double brightness) {
        float[] hsl = new float[3];
        Color.RGBtoHSB(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, hsl);
        return Color.HSBtoRGB(hsl[0], hsl[1], (float)brightness);
    }

    public static int withAlpha(int color, double alpha) {
        return (int)Math.round(alpha * 255.0) << 24 | color & 0xFFFFFF;
    }

    public static int blend(int colorA, int colorB, float ratio) {
        int a1 = colorA >> 24 & 0xFF;
        int r1 = (colorA & 0xFF0000) >> 16;
        int g1 = (colorA & 0xFF00) >> 8;
        int b1 = colorA & 0xFF;
        int a2 = colorB >> 24 & 0xFF;
        int r2 = (colorB & 0xFF0000) >> 16;
        int g2 = (colorB & 0xFF00) >> 8;
        int b2 = colorB & 0xFF;
        int a = (int)((float)a1 * (1.0f - ratio) + (float)a2 * ratio);
        int r = (int)((float)r1 * (1.0f - ratio) + (float)r2 * ratio);
        int g = (int)((float)g1 * (1.0f - ratio) + (float)g2 * ratio);
        int b = (int)((float)b1 * (1.0f - ratio) + (float)b2 * ratio);
        return a << 24 | r << 16 | g << 8 | b;
    }
}

