/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.json;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import dev.shadowsoffire.placebo.json.ItemAdapter;
import java.util.List;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;

public class WeightedItemStack
extends WeightedEntry.IntrusiveBase {
    public static final Codec<WeightedItemStack> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ItemAdapter.CODEC.fieldOf("stack").forGetter(w -> w.stack), (App)Weight.f_146274_.fieldOf("weight").forGetter(w -> w.m_142631_()), (App)PlaceboCodecs.nullableField(Codec.FLOAT, "drop_chance", Float.valueOf(-1.0f)).forGetter(w -> Float.valueOf(w.dropChance))).apply((Applicative)inst, WeightedItemStack::new));
    public static final Codec<List<WeightedItemStack>> LIST_CODEC = CODEC.listOf();
    final ItemStack stack;
    final float dropChance;

    public WeightedItemStack(ItemStack stack, Weight weight, float dropChance) {
        super(weight);
        this.stack = stack;
        this.dropChance = dropChance;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public String toString() {
        return "Stack: " + this.stack.toString() + " @ Weight: " + this.m_142631_().m_146281_();
    }

    public void apply(LivingEntity entity, EquipmentSlot slot) {
        entity.m_8061_(slot, this.stack.m_41777_());
        if (this.dropChance >= 0.0f && entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.m_21409_(slot, this.dropChance);
        }
    }
}

