/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.utils;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import mod.chiselsandbits.api.util.MathUtil;
import mod.chiselsandbits.utils.DirectionUtils;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class AABBUtils {
    private AABBUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: AABBUtils. This is a utility class");
    }

    public static boolean areBoxesNeighbors(@NotNull AABB l, @NotNull AABB r, @NotNull Direction direction) {
        double endOfL = AABBUtils.getDirectionalValue(l, direction);
        double startOfR = AABBUtils.getDirectionalValue(r, direction.m_122424_());
        if (!MathUtil.almostEqual(endOfL, startOfR)) {
            return false;
        }
        List<Direction> remainingDirectionsToCheck = DirectionUtils.getNotOnAxisOf(direction);
        Map valuesOfL = remainingDirectionsToCheck.stream().collect(Collectors.toMap(Function.identity(), d -> AABBUtils.getDirectionalValue(l, d)));
        Map valuesOfR = remainingDirectionsToCheck.stream().collect(Collectors.toMap(Function.identity(), d -> AABBUtils.getDirectionalValue(r, d)));
        return remainingDirectionsToCheck.stream().allMatch(d -> MathUtil.almostEqual((Number)valuesOfL.get(d), (Number)valuesOfR.get(d)));
    }

    public static double getDirectionalValue(@NotNull AABB bb, @NotNull Direction direction) {
        return direction.m_122421_() == Direction.AxisDirection.POSITIVE ? bb.m_82374_(direction.m_122434_()) : bb.m_82340_(direction.m_122434_());
    }
}

