/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.immediatelyfast.injection.mixins.hud_batching.consumer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.raphimc.immediatelyfast.feature.batching.BatchingBuffers;
import net.raphimc.immediatelyfast.feature.batching.BatchingRenderLayers;
import net.raphimc.immediatelyfast.feature.batching.BlendFuncDepthFuncState;
import net.raphimc.immediatelyfast.injection.processors.InjectAboveEverything;
import net.raphimc.immediatelyfast.injection.processors.InjectOnAllReturns;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiGraphics.class}, priority=1500)
public abstract class MixinDrawContext {
    @Shadow
    @Final
    private PoseStack f_279612_;
    @Shadow
    @Final
    private Minecraft f_279544_;
    @Shadow
    @Final
    @Mutable
    private MultiBufferSource.BufferSource f_279627_;
    @Unique
    private MultiBufferSource.BufferSource immediatelyFast$originalVertexConsumers;

    @Shadow
    protected abstract void m_280584_(VertexConsumer var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    @Inject(method={"<init>(Lnet/minecraft/client/MinecraftClient;Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider$Immediate;)V"}, at={@At(value="RETURN")})
    private void storeOriginalVertexConsumers(CallbackInfo ci) {
        this.immediatelyFast$originalVertexConsumers = this.f_279627_;
    }

    @Inject(method={"fill(Lnet/minecraft/client/render/RenderLayer;IIIIII)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void fillIntoBuffer(RenderType layer, int x1, int y1, int x2, int y2, int z, int color, CallbackInfo ci) {
        if (BatchingBuffers.FILL_CONSUMER != null) {
            ci.cancel();
            if (x1 < x2) {
                x1 ^= x2;
                x2 = x1 ^ x2;
                x1 ^= x2;
            }
            if (y1 < y2) {
                y1 ^= y2;
                y2 = y1 ^ y2;
                y1 ^= y2;
            }
            Matrix4f matrix = this.f_279612_.m_85850_().m_252922_();
            float[] shaderColor = RenderSystem.getShaderColor();
            int argb = (int)(shaderColor[3] * 255.0f) << 24 | (int)(shaderColor[0] * 255.0f) << 16 | (int)(shaderColor[1] * 255.0f) << 8 | (int)(shaderColor[2] * 255.0f);
            color = FastColor.ARGB32.m_13657_((int)color, (int)argb);
            VertexConsumer vertexConsumer = BatchingBuffers.FILL_CONSUMER.m_6299_(layer);
            vertexConsumer.m_252986_(matrix, (float)x1, (float)y2, (float)z).m_193479_(color).m_5752_();
            vertexConsumer.m_252986_(matrix, (float)x2, (float)y2, (float)z).m_193479_(color).m_5752_();
            vertexConsumer.m_252986_(matrix, (float)x2, (float)y1, (float)z).m_193479_(color).m_5752_();
            vertexConsumer.m_252986_(matrix, (float)x1, (float)y1, (float)z).m_193479_(color).m_5752_();
        }
    }

    @Inject(method={"fillGradient(Lnet/minecraft/client/render/RenderLayer;IIIIIII)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void fillIntoBuffer(RenderType layer, int startX, int startY, int endX, int endY, int colorStart, int colorEnd, int z, CallbackInfo ci) {
        if (BatchingBuffers.FILL_CONSUMER != null) {
            ci.cancel();
            float[] shaderColor = RenderSystem.getShaderColor();
            int argb = (int)(shaderColor[3] * 255.0f) << 24 | (int)(shaderColor[0] * 255.0f) << 16 | (int)(shaderColor[1] * 255.0f) << 8 | (int)(shaderColor[2] * 255.0f);
            colorStart = FastColor.ARGB32.m_13657_((int)colorStart, (int)argb);
            colorEnd = FastColor.ARGB32.m_13657_((int)colorEnd, (int)argb);
            this.m_280584_(BatchingBuffers.FILL_CONSUMER.m_6299_(layer), startX, startY, endX, endY, z, colorStart, colorEnd);
        }
    }

    @Inject(method={"drawTexturedQuad(Lnet/minecraft/util/Identifier;IIIIIFFFF)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void drawTexturedQuadIntoBuffer(ResourceLocation texture, int x1, int x2, int y1, int y2, int z, float u1, float u2, float v1, float v2, CallbackInfo ci) {
        if (BatchingBuffers.TEXTURE_CONSUMER != null) {
            ci.cancel();
            Matrix4f matrix = this.f_279612_.m_85850_().m_252922_();
            float[] shaderColor = RenderSystem.getShaderColor();
            int r = (int)(shaderColor[0] * 255.0f);
            int g = (int)(shaderColor[1] * 255.0f);
            int b = (int)(shaderColor[2] * 255.0f);
            int a = (int)(shaderColor[3] * 255.0f);
            VertexConsumer vertexConsumer = BatchingBuffers.TEXTURE_CONSUMER.m_6299_(BatchingRenderLayers.COLORED_TEXTURE.apply(this.f_279544_.m_91097_().m_118506_(texture).m_117963_(), BlendFuncDepthFuncState.current()));
            vertexConsumer.m_252986_(matrix, (float)x1, (float)y2, (float)z).m_7421_(u1, v2).m_6122_(r, g, b, a).m_5752_();
            vertexConsumer.m_252986_(matrix, (float)x2, (float)y2, (float)z).m_7421_(u2, v2).m_6122_(r, g, b, a).m_5752_();
            vertexConsumer.m_252986_(matrix, (float)x2, (float)y1, (float)z).m_7421_(u2, v1).m_6122_(r, g, b, a).m_5752_();
            vertexConsumer.m_252986_(matrix, (float)x1, (float)y1, (float)z).m_7421_(u1, v1).m_6122_(r, g, b, a).m_5752_();
        }
    }

    @Inject(method={"drawTexturedQuad(Lnet/minecraft/util/Identifier;IIIIIFFFFFFFF)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void drawTexturedQuadIntoBuffer(ResourceLocation texture, int x1, int x2, int y1, int y2, int z, float u1, float u2, float v1, float v2, float red, float green, float blue, float alpha, CallbackInfo ci) {
        if (BatchingBuffers.TEXTURE_CONSUMER != null) {
            ci.cancel();
            Matrix4f matrix = this.f_279612_.m_85850_().m_252922_();
            float[] shaderColor = RenderSystem.getShaderColor();
            int argb = (int)(shaderColor[3] * 255.0f) << 24 | (int)(shaderColor[0] * 255.0f) << 16 | (int)(shaderColor[1] * 255.0f) << 8 | (int)(shaderColor[2] * 255.0f);
            int color = FastColor.ARGB32.m_13657_((int)((int)(alpha * 255.0f) << 24 | (int)(red * 255.0f) << 16 | (int)(green * 255.0f) << 8 | (int)(blue * 255.0f)), (int)argb);
            RenderSystem.enableBlend();
            VertexConsumer vertexConsumer = BatchingBuffers.TEXTURE_CONSUMER.m_6299_(BatchingRenderLayers.COLORED_TEXTURE.apply(this.f_279544_.m_91097_().m_118506_(texture).m_117963_(), BlendFuncDepthFuncState.current()));
            vertexConsumer.m_252986_(matrix, (float)x1, (float)y2, (float)z).m_7421_(u1, v2).m_193479_(color).m_5752_();
            vertexConsumer.m_252986_(matrix, (float)x2, (float)y2, (float)z).m_7421_(u2, v2).m_193479_(color).m_5752_();
            vertexConsumer.m_252986_(matrix, (float)x2, (float)y1, (float)z).m_7421_(u2, v1).m_193479_(color).m_5752_();
            vertexConsumer.m_252986_(matrix, (float)x1, (float)y1, (float)z).m_7421_(u1, v1).m_193479_(color).m_5752_();
            RenderSystem.disableBlend();
        }
    }

    @InjectAboveEverything
    @Inject(method={"drawItem(Lnet/minecraft/entity/LivingEntity;Lnet/minecraft/world/World;Lnet/minecraft/item/ItemStack;IIII)V"}, at={@At(value="HEAD")})
    private void renderItemIntoBufferStart(CallbackInfo ci) {
        if (BatchingBuffers.ITEM_MODEL_CONSUMER != null) {
            this.f_279627_ = (MultiBufferSource.BufferSource)BatchingBuffers.ITEM_MODEL_CONSUMER;
        }
    }

    @InjectOnAllReturns
    @Inject(method={"drawItem(Lnet/minecraft/entity/LivingEntity;Lnet/minecraft/world/World;Lnet/minecraft/item/ItemStack;IIII)V"}, at={@At(value="RETURN")})
    private void renderItemIntoBufferEnd(CallbackInfo ci) {
        if (BatchingBuffers.ITEM_MODEL_CONSUMER != null) {
            this.f_279627_ = this.immediatelyFast$originalVertexConsumers;
        }
    }

    @InjectAboveEverything
    @Inject(method={"drawItemInSlot(Lnet/minecraft/client/font/TextRenderer;Lnet/minecraft/item/ItemStack;IILjava/lang/String;)V"}, at={@At(value="HEAD")})
    private void renderItemOverlayIntoBufferStart(CallbackInfo ci) {
        BatchingBuffers.beginItemOverlayRendering();
        if (BatchingBuffers.ITEM_OVERLAY_CONSUMER != null) {
            this.f_279627_ = (MultiBufferSource.BufferSource)BatchingBuffers.ITEM_OVERLAY_CONSUMER;
        }
    }

    @InjectOnAllReturns
    @Inject(method={"drawItemInSlot(Lnet/minecraft/client/font/TextRenderer;Lnet/minecraft/item/ItemStack;IILjava/lang/String;)V"}, at={@At(value="RETURN")})
    private void renderItemOverlayIntoBufferEnd(CallbackInfo ci) {
        BatchingBuffers.endItemOverlayRendering();
        if (BatchingBuffers.ITEM_OVERLAY_CONSUMER != null) {
            this.f_279627_ = this.immediatelyFast$originalVertexConsumers;
        }
    }

    @Inject(method={"draw()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void dontDrawIfBatching(CallbackInfo ci) {
        if (this.f_279627_ != this.immediatelyFast$originalVertexConsumers) {
            ci.cancel();
        }
    }

    @Inject(method={"setScissor"}, at={@At(value="HEAD")})
    private void forceDrawBatch(CallbackInfo ci) {
        if (BatchingBuffers.isHudBatching() && BatchingBuffers.hasDataToDraw()) {
            BatchingBuffers.forceDrawBuffers();
        }
    }
}

