/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.legendarytooltips.tooltip;

import com.anthonyhilyard.iceberg.renderer.CustomItemRenderer;
import com.anthonyhilyard.iceberg.util.GuiHelper;
import com.anthonyhilyard.iceberg.util.Tooltips;
import com.anthonyhilyard.legendarytooltips.config.LegendaryTooltipsConfig;
import com.anthonyhilyard.legendarytooltips.tooltip.TooltipDecor;
import com.anthonyhilyard.prism.text.DynamicColor;
import com.anthonyhilyard.prism.util.ColorUtil;
import com.anthonyhilyard.prism.util.ConfigHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.joml.Matrix4f;

public class ItemModelComponent
implements TooltipComponent,
ClientTooltipComponent,
Tooltips.InlineComponent {
    private static CustomItemRenderer customItemRenderer = null;
    private static float rotationTimer = 0.0f;
    private final ItemStack itemStack;

    public static void updateTimer(float partialTick) {
        double rotationInterval = (Double)LegendaryTooltipsConfig.INSTANCE.modelRotationSpeed.get();
        if (rotationInterval > 0.0) {
            if ((double)(rotationTimer += partialTick) > rotationInterval) {
                rotationTimer = (float)((double)rotationTimer - rotationInterval);
            }
        } else {
            rotationTimer = 0.0f;
        }
    }

    public ItemModelComponent(ItemStack itemStack) {
        this.itemStack = itemStack;
        if (customItemRenderer == null) {
            Minecraft minecraft = Minecraft.m_91087_();
            customItemRenderer = new CustomItemRenderer(minecraft.m_91097_(), minecraft.m_91304_(), minecraft.getItemColors(), minecraft.m_91291_().getBlockEntityRenderer(), minecraft);
        }
    }

    public int getRenderHeight() {
        return 22;
    }

    public int getRenderWidth() {
        return 22;
    }

    public int m_142103_() {
        return 4;
    }

    public int m_142069_(Font p_169952_) {
        return this.getRenderWidth();
    }

    public void m_183452_(Font font, int x, int y, GuiGraphics graphics) {
        graphics.m_280262_();
        --y;
        --x;
        int z = 0;
        int margin = 2;
        DynamicColor borderStartColor = DynamicColor.fromRgb((int)TooltipDecor.currentTooltipBorderStart);
        DynamicColor backgroundStartColor = DynamicColor.fromRgb((int)TooltipDecor.currentTooltipBackgroundStart);
        DynamicColor backgroundEndColor = ConfigHelper.applyModifiers(List.of("v+35", "s+10"), (DynamicColor)DynamicColor.fromRgb((int)TooltipDecor.currentTooltipBackgroundEnd));
        int borderStart = ColorUtil.combineARGB((int)((int)((float)borderStartColor.alpha() * 0.35f)), (int)borderStartColor.red(), (int)borderStartColor.green(), (int)borderStartColor.blue());
        int backgroundStart = ColorUtil.combineARGB((int)((int)((float)backgroundStartColor.alpha() * 0.15f)), (int)backgroundStartColor.red(), (int)backgroundStartColor.green(), (int)backgroundStartColor.blue());
        int backgroundEnd = ColorUtil.combineARGB((int)((int)((float)backgroundEndColor.alpha() * 0.6f)), (int)backgroundEndColor.red(), (int)backgroundEndColor.green(), (int)backgroundEndColor.blue());
        PoseStack poseStack = graphics.m_280168_();
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        GuiHelper.drawGradientRect((Matrix4f)matrix, (int)z, (int)(x + 2 + 1), (int)(y + 2 + 1), (int)(x + this.getRenderWidth() - 2 - 1), (int)(y + this.getRenderHeight() - 2 - 1), (int)backgroundStart, (int)backgroundEnd);
        GuiHelper.drawGradientRect((Matrix4f)matrix, (int)z, (int)(x + 2 + 1), (int)(y + 2 + 1), (int)(x + this.getRenderWidth() - 2 - 1), (int)(y + this.getRenderHeight() - 2 - 1), (int)backgroundEnd, (int)backgroundStart);
        GuiHelper.drawGradientRectHorizontal((Matrix4f)matrix, (int)z, (int)(x + 2 + 1), (int)(y + 2 + 1), (int)(x + this.getRenderWidth() - 2 - 1), (int)(y + this.getRenderHeight() - 2 - 1), (int)backgroundStart, (int)backgroundEnd);
        GuiHelper.drawGradientRectHorizontal((Matrix4f)matrix, (int)z, (int)(x + 2 + 1), (int)(y + 2 + 1), (int)(x + this.getRenderWidth() - 2 - 1), (int)(y + this.getRenderHeight() - 2 - 1), (int)backgroundEnd, (int)backgroundStart);
        GuiHelper.drawGradientRect((Matrix4f)matrix, (int)z, (int)(x + 2 + 1), (int)(y + 2), (int)(x + this.getRenderWidth() - 2 - 1), (int)(y + 2 + 1), (int)borderStart, (int)borderStart);
        GuiHelper.drawGradientRect((Matrix4f)matrix, (int)z, (int)(x + 2 + 1), (int)(y + this.getRenderHeight() - 2 - 1), (int)(x + this.getRenderWidth() - 2 - 1), (int)(y + this.getRenderHeight() - 2), (int)borderStart, (int)borderStart);
        GuiHelper.drawGradientRect((Matrix4f)matrix, (int)z, (int)(x + 2), (int)(y + 2 + 1), (int)(x + 2 + 1), (int)(y + this.getRenderHeight() - 2 - 1), (int)borderStart, (int)borderStart);
        GuiHelper.drawGradientRect((Matrix4f)matrix, (int)z, (int)(x + this.getRenderWidth() - 2 - 1), (int)(y + 2 + 1), (int)(x + this.getRenderWidth() - 2), (int)(y + this.getRenderHeight() - 2 - 1), (int)borderStart, (int)borderStart);
        PoseStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.m_85836_();
        modelViewStack.m_252931_(matrix);
        modelViewStack.m_252880_((float)(x + 2 - 1), (float)(y + 2 - 1), 0.0f);
        modelViewStack.m_85841_(1.25f, 1.25f, 1.0f);
        RenderSystem.applyModelViewMatrix();
        float rotationAngle = 0.0f;
        if ((Double)LegendaryTooltipsConfig.INSTANCE.modelRotationSpeed.get() > 0.0) {
            rotationAngle = Mth.m_14179_((float)(rotationTimer / ((Double)LegendaryTooltipsConfig.INSTANCE.modelRotationSpeed.get()).floatValue()), (float)0.0f, (float)360.0f);
        }
        customItemRenderer.renderDetailModelIntoGUI(this.itemStack, 0, 0, Axis.f_252436_.m_252977_(rotationAngle), graphics);
        modelViewStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
    }

    public static void registerFactory() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ItemModelComponent::onRegisterTooltipEvent);
    }

    private static void onRegisterTooltipEvent(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(ItemModelComponent.class, x -> x);
    }
}

