/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.retrodamageindicators;

import com.github.alexmodguy.retrodamageindicators.Config;
import com.github.alexmodguy.retrodamageindicators.DamageIndicatorParticle;
import com.github.alexmodguy.retrodamageindicators.MobTypes;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@Mod.EventBusSubscriber(modid="retrodamageindicators", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class RetroDamageIndicators {
    public static final String MODID = "retrodamageindicators";
    private static final ResourceLocation DAMAGE_INDICATOR_TEXTURE = new ResourceLocation("retrodamageindicators", "textures/gui/damage_indicator.png");
    private static final ResourceLocation DAMAGE_INDICATOR_BACKGROUND_TEXTURE = new ResourceLocation("retrodamageindicators", "textures/gui/damage_indicator_background.png");
    private static final ResourceLocation DAMAGE_INDICATOR_HEALTH_TEXTURE = new ResourceLocation("retrodamageindicators", "textures/gui/damage_indicator_health.png");
    private static final Quaternionf ENTITY_ROTATION = new Quaternionf().rotationXYZ((float)Math.toRadians(30.0), (float)Math.toRadians(130.0), (float)Math.PI);
    private static LivingEntity damageIndicatorEntity;
    private static MobTypes currentMobType;
    private static int resetDamageIndicatorEntityIn;
    private static boolean renderModelOnly;

    @SubscribeEvent
    public static void onPreRenderGuiElement(RenderGuiOverlayEvent.Pre event) {
        if (((Boolean)Config.INSTANCE.hudIndicatorEnabled.get()).booleanValue() && event.getOverlay().id().equals((Object)VanillaGuiOverlay.BOSS_EVENT_PROGRESS.id()) && damageIndicatorEntity != null) {
            int firstHalfWidth;
            String healthText;
            String healthDivisor;
            float renderScale;
            float biggestEntityDimension;
            float entityHealth = Math.min(damageIndicatorEntity.m_21223_(), damageIndicatorEntity.m_21233_());
            float entityMaxHealth = damageIndicatorEntity.m_21233_();
            float healthRatio = entityMaxHealth <= 0.0f ? 0.0f : entityHealth / entityMaxHealth;
            float scale = ((Double)Config.INSTANCE.hudIndicatorSize.get()).floatValue();
            int xOffset = (Boolean)Config.INSTANCE.hudIndicatorAlignLeft.get() != false ? (Integer)Config.INSTANCE.hudIndicatorPositionX.get() : event.getWindow().m_85445_() - (int)(208.0f * scale) - (Integer)Config.INSTANCE.hudIndicatorPositionX.get();
            int yOffset = (Boolean)Config.INSTANCE.hudIndicatorAlignTop.get() != false ? (Integer)Config.INSTANCE.hudIndicatorPositionY.get() : event.getWindow().m_85446_() - (int)(78.0f * scale) - (Integer)Config.INSTANCE.hudIndicatorPositionY.get();
            Gui gui = Minecraft.m_91087_().f_91065_;
            if (gui instanceof ForgeGui) {
                ForgeGui forgeGui = (ForgeGui)gui;
                int bossBars = forgeGui.m_93090_().f_93699_.size();
                if (((Boolean)Config.INSTANCE.hudIndicatorAlignTop.get()).booleanValue()) {
                    if (bossBars > 0) {
                        yOffset += Math.min(event.getWindow().m_85446_() / 3, 12 + 19 * bossBars);
                    }
                    if (!((Boolean)Config.INSTANCE.hudIndicatorAlignLeft.get()).booleanValue()) {
                        int potionsActive = 0;
                        for (MobEffectInstance mobEffectInstance : Minecraft.m_91087_().f_91074_.m_21220_()) {
                            if (!mobEffectInstance.m_19575_()) continue;
                            ++potionsActive;
                        }
                        yOffset += Math.min(potionsActive, 2) * 24;
                    }
                }
            }
            float backgroundOpacity = ((Double)Config.INSTANCE.hudIndicatorBackgroundOpacity.get()).floatValue();
            int relativeHealthbarX = 81;
            int relativeHealthbarY = 25;
            int healthbarHeight = 18;
            int healthbarMaxWidth = 124;
            int currentHealthbarWidth = Math.round((float)healthbarMaxWidth * healthRatio);
            PoseStack poseStack = event.getGuiGraphics().m_280168_();
            poseStack.m_85836_();
            poseStack.m_252880_((float)xOffset, (float)yOffset - 0.5f, 0.0f);
            poseStack.m_85841_(scale, scale, scale);
            int scissorBox1MinX = 16;
            int scissorBox1MinY = 4;
            int scissorBox1MaxX = 73;
            int scissorBox1MaxY = 49;
            int scissorBox2MinX = 28;
            int scissorBox2MinY = 49;
            int scissorBox2MaxX = 73;
            int scissorBox2MaxY = 61;
            int entityX = 45;
            int entityY = 56;
            event.getGuiGraphics().m_280588_(xOffset + Math.round(scale * (float)scissorBox1MinX), yOffset + Math.round(scale * (float)scissorBox1MinY), xOffset + Math.round(scale * (float)scissorBox1MaxX), yOffset + Math.round(scale * (float)scissorBox1MaxY));
            if (damageIndicatorEntity != null) {
                biggestEntityDimension = Math.max(damageIndicatorEntity.m_20205_() * 1.2f + 0.3f, damageIndicatorEntity.m_20206_() * 0.9f) * 0.85f;
                renderScale = ((Double)Config.INSTANCE.hudEntitySize.get()).floatValue();
                if ((double)biggestEntityDimension > 0.5) {
                    renderScale /= biggestEntityDimension;
                }
                RetroDamageIndicators.renderEntityInGui(event.getGuiGraphics(), entityX, entityY, renderScale, ENTITY_ROTATION, (Entity)damageIndicatorEntity, event.getPartialTick());
            }
            event.getGuiGraphics().m_280618_();
            event.getGuiGraphics().m_280588_(xOffset + Math.round(scale * (float)scissorBox2MinX), yOffset + Math.round(scale * (float)scissorBox2MinY), xOffset + Math.round(scale * (float)scissorBox2MaxX), yOffset + Math.round(scale * (float)scissorBox2MaxY));
            if (damageIndicatorEntity != null) {
                biggestEntityDimension = Math.max(damageIndicatorEntity.m_20205_() * 1.2f + 0.3f, damageIndicatorEntity.m_20206_() * 0.9f) * 0.85f;
                renderScale = ((Double)Config.INSTANCE.hudEntitySize.get()).floatValue();
                if ((double)biggestEntityDimension > 0.5) {
                    renderScale /= biggestEntityDimension;
                }
                RetroDamageIndicators.renderEntityInGui(event.getGuiGraphics(), entityX, entityY, renderScale, ENTITY_ROTATION, (Entity)damageIndicatorEntity, event.getPartialTick());
            }
            event.getGuiGraphics().m_280618_();
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 0.0f, -200.0f);
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)backgroundOpacity);
            event.getGuiGraphics().m_280398_(DAMAGE_INDICATOR_BACKGROUND_TEXTURE, 0, 0, 50, 0.0f, 0.0f, 208, 78, 256, 256);
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            event.getGuiGraphics().m_280398_(DAMAGE_INDICATOR_TEXTURE, 0, 0, 50, 0.0f, 0.0f, 208, 78, 256, 256);
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int relativeMobTypeX = 5;
            int relativeMobTypeY = 55;
            event.getGuiGraphics().m_280398_(currentMobType.getTexture(), relativeMobTypeX, relativeMobTypeY, 50, 0.0f, 0.0f, 18, 18, 18, 18);
            int healthbarVOffset = (Boolean)Config.INSTANCE.colorblindHealthBar.get() != false ? 36 : 0;
            event.getGuiGraphics().m_280398_(DAMAGE_INDICATOR_HEALTH_TEXTURE, relativeHealthbarX, relativeHealthbarY, 50, 0.0f, (float)(healthbarVOffset + 18), healthbarMaxWidth, healthbarHeight, 256, 256);
            event.getGuiGraphics().m_280398_(DAMAGE_INDICATOR_HEALTH_TEXTURE, relativeHealthbarX, relativeHealthbarY, 50, 0.0f, (float)healthbarVOffset, currentHealthbarWidth, healthbarHeight, 256, 256);
            poseStack.m_85849_();
            float healthOffsetX = 136.0f;
            float healthOffsetY = 30.0f;
            if (((Boolean)Config.INSTANCE.healthSeperator.get()).booleanValue()) {
                healthDivisor = " | ";
            } else {
                healthDivisor = "/";
                healthOffsetX += 4.0f;
            }
            if (((Boolean)Config.INSTANCE.healthDecimals.get()).booleanValue()) {
                healthText = RetroDamageIndicators.roundHealth(entityHealth) + healthDivisor + RetroDamageIndicators.roundHealth(entityMaxHealth);
                firstHalfWidth = Minecraft.m_91087_().f_91062_.m_92895_("" + RetroDamageIndicators.roundHealth(entityHealth));
            } else {
                healthText = (int)entityHealth + healthDivisor + (int)entityMaxHealth;
                firstHalfWidth = Minecraft.m_91087_().f_91062_.m_92895_("" + (int)entityHealth);
            }
            MutableComponent healthComponent = Component.m_237113_((String)healthText);
            int healthWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)healthComponent);
            float healthScale = Math.min(88.0f / (float)healthWidth, 1.35f);
            int healthColor = 0xFFFFFF;
            int healthOutlineColor = 0;
            poseStack.m_85836_();
            poseStack.m_252880_(healthOffsetX, healthOffsetY, 0.0f);
            poseStack.m_85841_(healthScale, healthScale, 1.0f);
            poseStack.m_252880_((float)(-firstHalfWidth), 0.0f, -50.0f);
            if (((Boolean)Config.INSTANCE.hudHealthTextOutline.get()).booleanValue()) {
                Minecraft.m_91087_().f_91062_.m_168645_(healthComponent.m_7532_(), 0.0f, 0.0f, healthColor, healthOutlineColor, poseStack.m_85850_().m_252922_(), (MultiBufferSource)event.getGuiGraphics().m_280091_(), 0xF000F0);
            } else {
                Minecraft.m_91087_().f_91062_.m_272191_(healthComponent.m_7532_(), 0.0f, 0.0f, healthColor, true, poseStack.m_85850_().m_252922_(), (MultiBufferSource)event.getGuiGraphics().m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            }
            poseStack.m_85849_();
            Component nameComponent = damageIndicatorEntity.m_5446_();
            int nameWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)nameComponent);
            float nameScale = Math.min(113.0f / (float)nameWidth, 1.25f);
            float nameOffsetX = 138.5f;
            float nameOffsetY = 6.5f;
            int nameColor = 0xFFFFFF;
            int nameOutlineColor = 0;
            poseStack.m_85836_();
            poseStack.m_252880_(nameOffsetX, nameOffsetY, 0.0f);
            poseStack.m_85841_(nameScale, nameScale, 1.0f);
            poseStack.m_252880_((float)(-nameWidth) / 2.0f, 0.0f, -50.0f);
            if (((Boolean)Config.INSTANCE.hudNameTextOutline.get()).booleanValue()) {
                Minecraft.m_91087_().f_91062_.m_168645_(nameComponent.m_7532_(), 0.0f, 0.0f, nameColor, nameOutlineColor, poseStack.m_85850_().m_252922_(), (MultiBufferSource)event.getGuiGraphics().m_280091_(), 0xF000F0);
            } else {
                Minecraft.m_91087_().f_91062_.m_272191_(nameComponent.m_7532_(), 0.0f, 0.0f, nameColor, true, poseStack.m_85850_().m_252922_(), (MultiBufferSource)event.getGuiGraphics().m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            }
            poseStack.m_85849_();
            poseStack.m_85849_();
        }
    }

    public static void renderEntityInGui(GuiGraphics guiGraphics, int xPos, int yPos, float scale, Quaternionf rotation, Entity entity, float partialTicks) {
        EntityRenderer entityRenderer;
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85837_((double)xPos, (double)yPos, -60.0);
        guiGraphics.m_280168_().m_252931_(new Matrix4f().scaling(scale, scale, -scale));
        guiGraphics.m_280168_().m_252781_(rotation);
        Vector3f light0 = new Vector3f(1.0f, -1.0f, -1.0f).normalize();
        Vector3f light1 = new Vector3f(-1.0f, 1.0f, 1.0f).normalize();
        RenderSystem.setShaderLights((Vector3f)light0, (Vector3f)light1);
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.m_91087_().m_91290_();
        entityrenderdispatcher.m_114468_(false);
        if (renderModelOnly && (entityRenderer = entityrenderdispatcher.m_114382_(entity)) instanceof LivingEntityRenderer) {
            LivingEntityRenderer livingEntityRenderer = (LivingEntityRenderer)entityRenderer;
            guiGraphics.m_280168_().m_85837_(0.0, 1.5, 0.0);
            guiGraphics.m_280168_().m_252781_(Axis.f_252529_.m_252977_(180.0f));
            RenderType renderType = livingEntityRenderer.m_7200_().m_103119_(livingEntityRenderer.m_5478_(entity));
            livingEntityRenderer.m_7200_().m_7695_(guiGraphics.m_280168_(), guiGraphics.m_280091_().m_6299_(renderType), 0xF000F0, LivingEntityRenderer.m_115338_((LivingEntity)((LivingEntity)entity), (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            float f = entity.f_19859_ + (entity.m_146908_() - entity.f_19859_) * partialTicks;
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                float f1 = living.f_20884_ + (living.f_20883_ - living.f_20884_) * partialTicks;
                guiGraphics.m_280168_().m_252781_(Axis.f_252392_.m_252977_(-f1));
            } else {
                guiGraphics.m_280168_().m_252781_(Axis.f_252392_.m_252977_(-f));
            }
            RenderSystem.runAsFancy(() -> entityrenderdispatcher.m_114384_(entity, 0.0, 0.0, 0.0, 0.0f, partialTicks, guiGraphics.m_280168_(), (MultiBufferSource)guiGraphics.m_280091_(), 0xF000F0));
        }
        guiGraphics.m_280262_();
        entityrenderdispatcher.m_114468_(true);
        guiGraphics.m_280168_().m_85849_();
        Lighting.m_84931_();
    }

    public static float roundHealth(float entityHealth) {
        return (float)((double)Math.round(entityHealth * 5.0f) / 5.0);
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent clientTickEvent) {
        if (clientTickEvent.phase == TickEvent.Phase.START && Minecraft.m_91087_().f_91075_ != null) {
            AABB aabb;
            double maxPickDistance;
            double pickDistance = maxPickDistance = ((Double)Config.INSTANCE.maxDistance.get()).doubleValue();
            Vec3 vec3 = Minecraft.m_91087_().f_91075_.m_20299_(Minecraft.m_91087_().getPartialTick());
            HitResult hitResult = Minecraft.m_91087_().f_91075_.m_19907_(pickDistance, Minecraft.m_91087_().getPartialTick(), false);
            LivingEntity found = null;
            if (hitResult != null && hitResult.m_6662_() != HitResult.Type.MISS) {
                pickDistance = hitResult.m_82450_().m_82557_(vec3);
            }
            Vec3 vec31 = Minecraft.m_91087_().f_91075_.m_20252_(1.0f);
            Vec3 vec32 = vec3.m_82520_(vec31.f_82479_ * maxPickDistance, vec31.f_82480_ * maxPickDistance, vec31.f_82481_ * maxPickDistance);
            EntityHitResult entityhitresult = ProjectileUtil.m_37287_((Entity)Minecraft.m_91087_().f_91075_, (Vec3)vec3, (Vec3)vec32, (AABB)(aabb = Minecraft.m_91087_().f_91075_.m_20191_().m_82369_(vec31.m_82490_(maxPickDistance)).m_82377_(3.0, 3.0, 3.0)), lookingAt -> !lookingAt.m_5833_() && lookingAt.m_6087_(), (double)pickDistance);
            if (entityhitresult != null) {
                Vec3 vec33 = entityhitresult.m_82450_();
                Entity entity = entityhitresult.m_82443_();
                double d2 = vec3.m_82557_(vec33);
                if (d2 < pickDistance) {
                    PartEntity partEntity;
                    Entity entity2;
                    LivingEntity living;
                    if (entity instanceof LivingEntity && (living = (LivingEntity)entity).m_6084_() && !(living instanceof ArmorStand)) {
                        found = (LivingEntity)entity;
                    } else if (entity instanceof PartEntity && (entity2 = (partEntity = (PartEntity)entity).getParent()) instanceof LivingEntity) {
                        LivingEntity living2;
                        found = living2 = (LivingEntity)entity2;
                    }
                }
            }
            if (found != null) {
                damageIndicatorEntity = found;
                currentMobType = MobTypes.getTypeFor(found);
                resetDamageIndicatorEntityIn = (Integer)Config.INSTANCE.hudLingerTime.get();
                renderModelOnly = ((List)Config.INSTANCE.oldRenderEntities.get()).contains(BuiltInRegistries.f_256780_.m_7981_((Object)found.m_6095_()).toString());
            } else if (resetDamageIndicatorEntityIn-- < 0) {
                damageIndicatorEntity = null;
                resetDamageIndicatorEntityIn = 0;
            }
        }
    }

    public static void spawnHurtParticles(Entity entity, float damage) {
        double x = entity.m_20208_(1.0);
        double y = entity.m_20188_();
        double z = entity.m_20262_(1.0);
        Minecraft.m_91087_().f_91061_.m_107344_((Particle)new DamageIndicatorParticle(Minecraft.m_91087_().f_91073_, x, y, z, Math.abs(damage), damage > 0.0f));
    }

    static {
        currentMobType = MobTypes.UNKNOWN;
        resetDamageIndicatorEntityIn = 0;
    }
}

