/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.loader.stage2;

import cpw.mods.jarhandling.JarMetadata;
import cpw.mods.jarhandling.SecureJar;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import gg.essential.loader.stage2.modlauncher.CompatibilityLayer;
import gg.essential.loader.stage2.util.DelegatingJarMetadata;
import gg.essential.loader.stage2.util.KFFMerger;
import gg.essential.loader.stage2.util.Lazy;
import gg.essential.loader.stage2.util.SortedJarOrPathList;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SelfRenamingJarMetadata
extends DelegatingJarMetadata {
    private static final Logger LOGGER = LogManager.getLogger(SelfRenamingJarMetadata.class);
    private static final ThreadLocal<Boolean> RE_ENTRANCE_LOCK = ThreadLocal.withInitial(() -> false);
    private final CompatibilityLayer compatibilityLayer;
    private final Lazy<SecureJar> secureJar;

    public SelfRenamingJarMetadata(CompatibilityLayer compatibilityLayer, Lazy<SecureJar> secureJar, JarMetadata delegate) {
        super(delegate);
        this.compatibilityLayer = compatibilityLayer;
        this.secureJar = secureJar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String name() {
        if (RE_ENTRANCE_LOCK.get().booleanValue()) {
            throw new SelfRenamingReEntranceException();
        }
        RE_ENTRANCE_LOCK.set(true);
        String defaultName = this.delegate.name();
        Set<String> ourPackages = this.compatibilityLayer.getPackages(this.secureJar.get());
        try {
            for (SecureJar otherJar : this.getLayerJars()) {
                String otherModuleName;
                try {
                    otherModuleName = otherJar.name();
                }
                catch (SelfRenamingReEntranceException ignored) {
                    continue;
                }
                Set<String> otherPackages = this.compatibilityLayer.getPackages(otherJar);
                if (otherPackages.stream().anyMatch(ourPackages::contains)) {
                    LOGGER.debug("Found existing module with name {}, renaming {} to match.", (Object)otherModuleName, (Object)defaultName);
                    String string = otherModuleName;
                    return string;
                }
                if (!defaultName.equals("thedarkcolour.kotlinforforge") || !otherPackages.isEmpty() || !KFFMerger.isJarJarKff(otherJar)) continue;
                LOGGER.debug("Found existing JarJar KFF with name {}, renaming {} to match.", (Object)otherModuleName, (Object)defaultName);
                String string = otherModuleName;
                return string;
            }
        }
        catch (Throwable e) {
            LOGGER.error("Exception occurred while trying to self-rename module " + defaultName + ": ", e);
        }
        finally {
            RE_ENTRANCE_LOCK.set(false);
        }
        LOGGER.debug("Did not find any existing modules to rename {}.", (Object)defaultName);
        return defaultName;
    }

    private List<Object> getLayerElements() throws Throwable {
        IModuleLayerManager layerManager = (IModuleLayerManager)Launcher.INSTANCE.findLayerManager().orElseThrow();
        Field layersField = layerManager.getClass().getDeclaredField("layers");
        layersField.setAccessible(true);
        EnumMap map = (EnumMap)layersField.get(layerManager);
        IModuleLayerManager.Layer[] layers = IModuleLayerManager.Layer.values();
        for (int i = layers.length - 1; i >= 0; --i) {
            List elements = (List)map.get(layers[i]);
            if (elements == null) continue;
            return elements;
        }
        throw new RuntimeException("Failed to find current layer?!");
    }

    private List<SecureJar> getLayerJars() throws Throwable {
        ArrayList<SecureJar> jars = new ArrayList<SecureJar>();
        for (Object pathOrJar : this.getLayerElements()) {
            SecureJar jar = SortedJarOrPathList.getJar(pathOrJar);
            if (jar == null) continue;
            jars.add(jar);
        }
        return jars;
    }

    private static class SelfRenamingReEntranceException
    extends RuntimeException {
        private SelfRenamingReEntranceException() {
        }
    }
}

