/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.loader.stage2.util;

import java.lang.reflect.Field;
import java.util.function.Function;
import sun.misc.Unsafe;

public class UnsafeHacks {
    private static final Unsafe unsafe;

    public static <T extends U, U> T allocateCopy(U source, Class<T> copyClass) {
        Object copy;
        Class<T> sourceClass = source.getClass();
        if (!sourceClass.isAssignableFrom(copyClass)) {
            throw new IllegalArgumentException(copyClass + " does not extend " + copyClass);
        }
        try {
            copy = unsafe.allocateInstance(copyClass);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        UnsafeHacks.copyRecursive(sourceClass, source, copy);
        return copyClass.cast(copy);
    }

    private static void copyRecursive(Class<?> cls, Object src, Object dst) {
        if (cls == null || cls == Object.class) {
            return;
        }
        for (Field field : cls.getDeclaredFields()) {
            Accessor accessor = UnsafeHacks.makeAccessor(field);
            accessor.set(dst, accessor.get(src));
        }
    }

    public static <T, U> Function<T, U> makeGetter(Class<? extends T> cls, String field) {
        return UnsafeHacks.makeAccessor(cls, field)::get;
    }

    public static <T, U> Function<T, U> makeGetter(Field field) {
        return UnsafeHacks.makeAccessor(field)::get;
    }

    public static <O, T> Accessor<O, T> makeAccessor(Class<? extends O> cls, String field) {
        try {
            return UnsafeHacks.makeAccessor(cls.getDeclaredField(field));
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static <O, T> Accessor<O, T> makeAccessor(Field field) {
        if (field.getType().isPrimitive()) {
            throw new UnsupportedOperationException("Only Object types are supported.");
        }
        if ((field.getModifiers() & 8) != 0) {
            final Object base = unsafe.staticFieldBase(field);
            final long offset = unsafe.staticFieldOffset(field);
            return new Accessor<O, T>(){

                @Override
                public T get(O owner) {
                    return unsafe.getObject(base, offset);
                }

                @Override
                public void set(O owner, T value) {
                    unsafe.putObject(base, offset, value);
                }
            };
        }
        final long offset = unsafe.objectFieldOffset(field);
        return new Accessor<O, T>(){

            @Override
            public T get(O owner) {
                return unsafe.getObject(owner, offset);
            }

            @Override
            public void set(O owner, T value) {
                unsafe.putObject(owner, offset, value);
            }
        };
    }

    static {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            unsafe = (Unsafe)field.get(null);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static interface Accessor<O, T> {
        public T get(O var1);

        public void set(O var1, T var2);

        default public void update(O owner, Function<T, T> func) {
            this.set(owner, func.apply(this.get(owner)));
        }
    }
}

