/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.api.SoundEvents;
import com.alrex.parcool.client.animation.impl.BackwardWallJumpAnimator;
import com.alrex.parcool.client.animation.impl.WallJumpAnimator;
import com.alrex.parcool.client.input.KeyRecorder;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.StaminaConsumeTiming;
import com.alrex.parcool.common.action.impl.ClingToCliff;
import com.alrex.parcool.common.action.impl.Crawl;
import com.alrex.parcool.common.action.impl.RideZipline;
import com.alrex.parcool.common.action.impl.VerticalWallRun;
import com.alrex.parcool.common.capability.Animation;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.config.ParCoolConfig;
import com.alrex.parcool.utilities.WorldUtil;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WallJump
extends Action {
    private boolean jump = false;
    private static final float MAX_COOL_DOWN_TICK = 8.0f;

    public boolean justJumped() {
        return this.jump;
    }

    private boolean isInCooldown(Parkourability parkourability) {
        return (parkourability.getClientInfo().get(ParCoolConfig.Client.Booleans.EnableWallJumpCooldown) != false || parkourability.getServerLimitation().get(ParCoolConfig.Server.Booleans.AllowDisableWallJumpCooldown) == false) && (float)this.getNotDoingTick() <= 8.0f;
    }

    @Override
    public void onTick(Player player, Parkourability parkourability, IStamina stamina) {
        this.jump = false;
    }

    @Override
    public StaminaConsumeTiming getStaminaConsumeTiming() {
        return StaminaConsumeTiming.OnStart;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    private Vec3 getJumpDirection(Player player, Vec3 wall) {
        Vec3 value;
        Vec3 lookVec;
        Vec3 vec;
        if (wall == null) {
            return null;
        }
        double dotProduct = (wall = wall.m_82541_()).m_82526_(vec = new Vec3((lookVec = player.m_20154_()).m_7096_(), 0.0, lookVec.m_7094_()).m_82541_());
        if (dotProduct > -Math.cos(Math.toRadians(ParCoolConfig.Client.Integers.AcceptableAngleOfWallJump.get().intValue()))) {
            return null;
        }
        if (dotProduct > 0.0) {
            double dot = vec.m_82548_().m_82526_(wall);
            value = vec.m_82549_(wall.m_82490_(2.0 * dot / wall.m_82553_()));
        } else {
            value = vec;
        }
        return value.m_82541_().m_82549_(wall.m_82490_(-0.7)).m_82541_();
    }

    @Override
    public boolean canStart(Player player, Parkourability parkourability, IStamina stamina, ByteBuffer startInfo) {
        boolean value;
        Vec3 wallDirection = WorldUtil.getWall((LivingEntity)player, (double)player.m_20205_() * 0.65);
        Vec3 jumpDirection = this.getJumpDirection(player, wallDirection);
        if (jumpDirection == null) {
            return false;
        }
        ClingToCliff cling = parkourability.get(ClingToCliff.class);
        ControlType control = (ControlType)((Object)ParCoolConfig.Client.WallJumpControl.get());
        boolean bl = value = !stamina.isExhausted() && !player.m_20096_() && !player.m_20072_() && !player.m_21255_() && !player.m_150110_().f_35935_ && parkourability.getAdditionalProperties().getNotCreativeFlyingTick() > 10 && (!cling.isDoing() && cling.getNotDoingTick() > 3 || cling.isDoing() && cling.getFacingDirection() != ClingToCliff.FacingDirection.ToWall) && (control == ControlType.PressKey && KeyRecorder.keyWallJump.isPressed() || control == ControlType.ReleaseKey && KeyRecorder.keyWallJump.isReleased()) && !parkourability.get(Crawl.class).isDoing() && !parkourability.get(VerticalWallRun.class).isDoing() && !parkourability.get(RideZipline.class).isDoing() && parkourability.getAdditionalProperties().getNotLandingTick() > 4 && !this.isInCooldown(parkourability);
        if (!value) {
            return false;
        }
        Vec3 dividedVec = new Vec3(wallDirection.m_7096_() * jumpDirection.m_7096_() + wallDirection.m_7094_() * jumpDirection.m_7094_(), 0.0, -wallDirection.m_7096_() * jumpDirection.m_7094_() + wallDirection.m_7094_() * jumpDirection.m_7096_()).m_82541_();
        Vec3 lookVec = player.m_20154_().m_82542_(1.0, 0.0, 1.0).m_82541_();
        Vec3 lookDividedVec = new Vec3(lookVec.m_7096_() * wallDirection.m_7096_() + lookVec.m_7094_() * wallDirection.m_7094_(), 0.0, -lookVec.m_7096_() * wallDirection.m_7094_() + lookVec.m_7094_() * wallDirection.m_7096_()).m_82541_();
        WallJumpAnimationType type = lookDividedVec.m_7096_() > 0.707 ? WallJumpAnimationType.Back : (dividedVec.m_7094_() > 0.0 ? WallJumpAnimationType.SwingRightArm : WallJumpAnimationType.SwingLeftArm);
        double lookAngleY = player.m_20154_().m_82541_().m_7098_();
        jumpDirection = lookAngleY > 0.5 ? jumpDirection.m_82520_(0.0, lookAngleY * 2.0, 0.0).m_82541_() : jumpDirection.m_82520_(0.0, 1.0, 0.0).m_82541_();
        startInfo.putDouble(jumpDirection.m_7096_()).putDouble(jumpDirection.m_7098_()).putDouble(jumpDirection.m_7094_()).putDouble(wallDirection.m_7096_()).putDouble(wallDirection.m_7094_()).put(type.getCode());
        return true;
    }

    @Override
    public boolean canContinue(Player player, Parkourability parkourability, IStamina stamina) {
        return false;
    }

    @Override
    public void onStart(Player player, Parkourability parkourability, ByteBuffer startData) {
        this.jump = true;
        player.f_19789_ = 0.0f;
    }

    @Override
    public void onStartInLocalClient(Player player, Parkourability parkourability, IStamina stamina, ByteBuffer startData) {
        double ySpeed;
        float slipperiness;
        if (ParCoolConfig.Client.Booleans.EnableActionSounds.get().booleanValue()) {
            player.m_5496_((SoundEvent)SoundEvents.WALL_JUMP.get(), 1.0f, 1.0f);
        }
        Vec3 jumpDirection = new Vec3(startData.getDouble(), startData.getDouble(), startData.getDouble());
        Vec3 jumpMotion = jumpDirection.m_82490_(0.59);
        Vec3 wallDirection = new Vec3(startData.getDouble(), 0.0, startData.getDouble());
        Vec3 motion = player.m_20184_();
        BlockPos leanedBlock = new BlockPos((int)(player.m_20185_() + wallDirection.m_7096_()), (int)(player.m_20191_().f_82289_ + (double)player.m_20206_() * 0.25), (int)(player.m_20189_() + wallDirection.m_7094_()));
        float f = slipperiness = player.m_20193_().m_46749_(leanedBlock) ? player.m_20193_().m_8055_(leanedBlock).getFriction((LevelReader)player.m_20193_(), leanedBlock, (Entity)player) : 0.6f;
        if ((double)slipperiness > 0.9) {
            ySpeed = motion.m_7098_();
        } else {
            ySpeed = motion.m_7098_() > jumpMotion.m_7098_() ? motion.f_82480_ + jumpMotion.m_7098_() : jumpMotion.m_7098_();
            this.spawnJumpParticles(player, wallDirection, jumpDirection);
        }
        player.m_20334_(motion.m_7096_() + jumpMotion.m_7096_(), ySpeed, motion.m_7094_() + jumpMotion.m_7094_());
        WallJumpAnimationType type = WallJumpAnimationType.fromCode(startData.get());
        Animation animation = Animation.get(player);
        if (animation != null) {
            switch (type) {
                case Back: {
                    animation.setAnimator(new BackwardWallJumpAnimator());
                    break;
                }
                case SwingLeftArm: {
                    animation.setAnimator(new WallJumpAnimator(false));
                    break;
                }
                case SwingRightArm: {
                    animation.setAnimator(new WallJumpAnimator(true));
                }
            }
        }
    }

    @Override
    public void onStartInOtherClient(Player player, Parkourability parkourability, ByteBuffer startData) {
        float slipperiness;
        if (ParCoolConfig.Client.Booleans.EnableActionSounds.get().booleanValue()) {
            player.m_5496_((SoundEvent)SoundEvents.WALL_JUMP.get(), 1.0f, 1.0f);
        }
        Vec3 jumpDirection = new Vec3(startData.getDouble(), startData.getDouble(), startData.getDouble());
        Vec3 wallDirection = new Vec3(startData.getDouble(), 0.0, startData.getDouble());
        BlockPos leanedBlock = new BlockPos((int)Math.floor(player.m_20185_() + wallDirection.m_7096_()), (int)Math.floor(player.m_20191_().f_82289_ + (double)player.m_20206_() * 0.25), (int)Math.floor(player.m_20189_() + wallDirection.m_7094_()));
        float f = slipperiness = player.m_9236_().m_46749_(leanedBlock) ? player.m_9236_().m_8055_(leanedBlock).getFriction((LevelReader)player.m_9236_(), leanedBlock, (Entity)player) : 1.0f;
        if ((double)slipperiness <= 0.9) {
            this.spawnJumpParticles(player, wallDirection, jumpDirection);
        }
        WallJumpAnimationType type = WallJumpAnimationType.fromCode(startData.get());
        Animation animation = Animation.get(player);
        if (animation != null) {
            switch (type) {
                case Back: {
                    animation.setAnimator(new BackwardWallJumpAnimator());
                    break;
                }
                case SwingLeftArm: {
                    animation.setAnimator(new WallJumpAnimator(false));
                    break;
                }
                case SwingRightArm: {
                    animation.setAnimator(new WallJumpAnimator(true));
                }
            }
        }
    }

    @Override
    public void onWorkingTickInClient(Player player, Parkourability parkourability, IStamina stamina) {
        super.onWorkingTickInClient(player, parkourability, stamina);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnJumpParticles(Player player, Vec3 wallDirection, Vec3 jumpDirection) {
        Vec3 pos;
        BlockPos leanedBlock;
        if (!ParCoolConfig.Client.Booleans.EnableActionParticles.get().booleanValue()) {
            return;
        }
        Level level = player.m_9236_();
        if (!level.m_46749_(leanedBlock = new BlockPos((int)Math.floor((pos = player.m_20182_()).m_7096_() + wallDirection.m_7096_()), (int)Math.floor(pos.m_7098_() + (double)player.m_20206_() * 0.25), (int)Math.floor(pos.m_7094_() + wallDirection.m_7094_())))) {
            return;
        }
        float width = player.m_20205_();
        BlockState blockstate = level.m_8055_(leanedBlock);
        Vec3 horizontalJumpDirection = jumpDirection.m_82542_(1.0, 0.0, 1.0).m_82541_();
        wallDirection = wallDirection.m_82541_();
        Vec3 orthogonalToWallVec = wallDirection.m_82524_(1.5707964f).m_82541_();
        Vec3 differenceVec = new Vec3(-wallDirection.m_7096_() * horizontalJumpDirection.m_7096_() - wallDirection.m_7094_() * horizontalJumpDirection.m_7094_(), 0.0, wallDirection.m_7094_() * horizontalJumpDirection.m_7096_() - wallDirection.m_7096_() * horizontalJumpDirection.m_7094_()).m_82542_(1.0, 0.0, -1.0).m_82541_();
        Vec3 particleBaseDirection = new Vec3(-wallDirection.m_7096_() * differenceVec.m_7096_() + wallDirection.m_7094_() * differenceVec.m_7094_(), 0.0, -wallDirection.m_7096_() * differenceVec.m_7094_() - wallDirection.m_7094_() * differenceVec.m_7096_());
        if (blockstate.m_60799_() != RenderShape.INVISIBLE) {
            for (int i = 0; i < 10; ++i) {
                Vec3 particlePos = new Vec3(pos.m_7096_() + (wallDirection.m_7096_() * 0.4 + orthogonalToWallVec.m_7096_() * (player.m_217043_().m_188500_() - 0.5)) * (double)width, pos.m_7098_() + 0.1 + 0.3 * player.m_217043_().m_188500_(), pos.m_7094_() + (wallDirection.m_7094_() * 0.4 + orthogonalToWallVec.m_7094_() * (player.m_217043_().m_188500_() - 0.5)) * (double)width);
                Vec3 particleSpeed = particleBaseDirection.m_82524_((float)(0.6283185307179586 * (player.m_217043_().m_188500_() - 0.5))).m_82490_(3.0 + 9.0 * player.m_217043_().m_188500_()).m_82520_(0.0, -jumpDirection.m_7098_() * 3.0 * player.m_217043_().m_188500_(), 0.0);
                level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate).setPos(leanedBlock), particlePos.m_7096_(), particlePos.m_7098_(), particlePos.m_7094_(), particleSpeed.m_7096_(), particleSpeed.m_7098_(), particleSpeed.m_7094_());
            }
        }
    }

    public static enum ControlType {
        PressKey,
        ReleaseKey;

    }

    private static enum WallJumpAnimationType {
        Back,
        SwingRightArm,
        SwingLeftArm;


        public byte getCode() {
            return (byte)this.ordinal();
        }

        public static WallJumpAnimationType fromCode(byte code) {
            return WallJumpAnimationType.values()[code];
        }
    }
}

