/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.item.recipe.special;

import com.alrex.parcool.common.item.Items;
import com.alrex.parcool.common.item.recipe.Recipes;
import com.alrex.parcool.common.item.zipline.ZiplineRopeItem;
import java.util.LinkedList;
import javax.annotation.Nonnull;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class ZiplineRopeDyeRecipe
extends CustomRecipe {
    public ZiplineRopeDyeRecipe(ResourceLocation p_252125_, CraftingBookCategory p_249010_) {
        super(p_252125_, p_249010_);
    }

    public boolean matches(@Nonnull CraftingContainer craftingContainer, @Nonnull Level level) {
        boolean ziplineRopeFound = false;
        boolean dyeItemFound = false;
        for (int i = 0; i < craftingContainer.m_6643_(); ++i) {
            ItemStack stack = craftingContainer.m_8020_(i);
            if (stack.m_41720_().equals(Items.ZIPLINE_ROPE.get())) {
                if (ziplineRopeFound) {
                    return false;
                }
                ziplineRopeFound = true;
                continue;
            }
            if (stack.m_41720_() instanceof DyeItem) {
                dyeItemFound = true;
                continue;
            }
            if (stack.m_41619_()) continue;
            return false;
        }
        return ziplineRopeFound && dyeItemFound;
    }

    @Nonnull
    public ItemStack assemble(CraftingContainer craftingContainer, RegistryAccess registryAccess) {
        ItemStack ziplineRope = null;
        LinkedList<DyeItem> dyeItems = new LinkedList<DyeItem>();
        for (int i = 0; i < craftingContainer.m_6643_(); ++i) {
            ItemStack stack = craftingContainer.m_8020_(i);
            Item item = stack.m_41720_();
            if (item instanceof ZiplineRopeItem) {
                ziplineRope = stack;
                continue;
            }
            if (item instanceof DyeItem) {
                dyeItems.add((DyeItem)item);
                continue;
            }
            if (stack.m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        if (ziplineRope == null || dyeItems.isEmpty()) {
            return ItemStack.f_41583_;
        }
        ziplineRope = ziplineRope.m_41777_();
        int r = 0;
        int g = 0;
        int b = 0;
        int dyeSize = dyeItems.size();
        for (DyeItem dyeItem : dyeItems) {
            DyeColor color = dyeItem.m_41089_();
            r += (int)(color.m_41068_()[0] * 255.0f);
            g += (int)(color.m_41068_()[1] * 255.0f);
            b += (int)(color.m_41068_()[2] * 255.0f);
        }
        if (ZiplineRopeItem.hasCustomColor(ziplineRope)) {
            ++dyeSize;
            int color = ZiplineRopeItem.getColor(ziplineRope);
            r += (color & 0xFF0000) >> 16;
            g += (color & 0xFF00) >> 8;
            b += color & 0xFF;
        }
        r = Mth.m_14045_((int)(r / dyeSize), (int)0, (int)255);
        g = Mth.m_14045_((int)(g / dyeSize), (int)0, (int)255);
        b = Mth.m_14045_((int)(b / dyeSize), (int)0, (int)255);
        ZiplineRopeItem.setColor(ziplineRope, (r << 16) + (g << 8) + b);
        return ziplineRope;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)Recipes.ZIPLINE_ROPE_DYE.get();
    }
}

