/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.utilities;

import com.alrex.parcool.common.action.impl.HangDown;
import com.alrex.parcool.common.tags.BlockTags;
import com.alrex.parcool.utilities.VectorUtil;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EndRodBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class WorldUtil {
    public static Vec3 getRunnableWall(LivingEntity entity, double range) {
        double width = entity.m_20205_() * 0.4f;
        double wallX = 0.0;
        double wallZ = 0.0;
        Vec3 pos = entity.m_20182_();
        AABB baseBox1 = new AABB(pos.m_7096_() - width, pos.m_7098_(), pos.m_7094_() - width, pos.m_7096_() + width, pos.m_7098_() + (double)entity.m_20206_() / 1.63, pos.m_7094_() + width);
        AABB baseBox2 = new AABB(pos.m_7096_() - width, pos.m_7098_() + (double)entity.m_20206_() / 1.63, pos.m_7094_() - width, pos.m_7096_() + width, pos.m_7098_() + (double)entity.m_20206_(), pos.m_7094_() + width);
        if (!entity.m_9236_().m_45772_(baseBox1.m_82363_(range, 0.0, 0.0)) && !entity.m_9236_().m_45772_(baseBox2.m_82363_(range, 0.0, 0.0))) {
            wallX += 1.0;
        }
        if (!entity.m_9236_().m_45772_(baseBox1.m_82363_(-range, 0.0, 0.0)) && !entity.m_9236_().m_45772_(baseBox2.m_82363_(-range, 0.0, 0.0))) {
            wallX -= 1.0;
        }
        if (!entity.m_9236_().m_45772_(baseBox1.m_82363_(0.0, 0.0, range)) && !entity.m_9236_().m_45772_(baseBox2.m_82363_(0.0, 0.0, range))) {
            wallZ += 1.0;
        }
        if (!entity.m_9236_().m_45772_(baseBox1.m_82363_(0.0, 0.0, -range)) && !entity.m_9236_().m_45772_(baseBox1.m_82363_(0.0, 0.0, -range))) {
            wallZ -= 1.0;
        }
        if (wallX == 0.0 && wallZ == 0.0) {
            return null;
        }
        return new Vec3(wallX, 0.0, wallZ);
    }

    @Nullable
    public static Vec3 getWall(LivingEntity entity) {
        return WorldUtil.getWall(entity, (double)entity.m_20205_() * 0.5);
    }

    @Nullable
    public static Vec3 getWall(LivingEntity entity, double range) {
        double width = (double)entity.m_20205_() * 0.49;
        double wallX = 0.0;
        double wallZ = 0.0;
        Vec3 pos = entity.m_20182_();
        AABB baseBox = new AABB(pos.m_7096_() - width, pos.m_7098_(), pos.m_7094_() - width, pos.m_7096_() + width, pos.m_7098_() + (double)entity.m_20206_(), pos.m_7094_() + width);
        if (!entity.m_20193_().m_45756_((Entity)entity, baseBox.m_82363_(range, 0.0, 0.0))) {
            wallX += 1.0;
        }
        if (!entity.m_20193_().m_45756_((Entity)entity, baseBox.m_82363_(-range, 0.0, 0.0))) {
            wallX -= 1.0;
        }
        if (!entity.m_20193_().m_45756_((Entity)entity, baseBox.m_82363_(0.0, 0.0, range))) {
            wallZ += 1.0;
        }
        if (!entity.m_20193_().m_45756_((Entity)entity, baseBox.m_82363_(0.0, 0.0, -range))) {
            wallZ -= 1.0;
        }
        if (wallX == 0.0 && wallZ == 0.0) {
            return null;
        }
        return new Vec3(wallX, 0.0, wallZ);
    }

    @Nullable
    public static Vec3 getVaultableStep(LivingEntity entity) {
        double d = (double)entity.m_20205_() * 0.5;
        Level world = entity.m_20193_();
        double distance = entity.m_20205_() / 2.0f;
        double baseLine = Math.min((double)entity.m_20206_() * 0.86, WorldUtil.getWallHeight(entity));
        double stepX = 0.0;
        double stepZ = 0.0;
        Vec3 pos = entity.m_20182_();
        AABB baseBoxBottom = new AABB(pos.m_7096_() - d, pos.m_7098_(), pos.m_7094_() - d, pos.m_7096_() + d, pos.m_7098_() + baseLine, pos.m_7094_() + d);
        AABB baseBoxTop = new AABB(pos.m_7096_() - d, pos.m_7098_() + baseLine, pos.m_7094_() - d, pos.m_7096_() + d, pos.m_7098_() + baseLine + (double)entity.m_20206_(), pos.m_7094_() + d);
        if (!world.m_45756_((Entity)entity, baseBoxBottom.m_82363_(distance, 0.0, 0.0)) && world.m_45756_((Entity)entity, baseBoxTop.m_82363_(distance + 1.8, 0.0, 0.0))) {
            stepX += 1.0;
        }
        if (!world.m_45756_((Entity)entity, baseBoxBottom.m_82363_(-distance, 0.0, 0.0)) && world.m_45756_((Entity)entity, baseBoxTop.m_82363_(-(distance + 1.8), 0.0, 0.0))) {
            stepX -= 1.0;
        }
        if (!world.m_45756_((Entity)entity, baseBoxBottom.m_82363_(0.0, 0.0, distance)) && world.m_45756_((Entity)entity, baseBoxTop.m_82363_(0.0, 0.0, distance + 1.8))) {
            stepZ += 1.0;
        }
        if (!world.m_45756_((Entity)entity, baseBoxBottom.m_82363_(0.0, 0.0, -distance)) && world.m_45756_((Entity)entity, baseBoxTop.m_82363_(0.0, 0.0, -(distance + 1.8)))) {
            stepZ -= 1.0;
        }
        if (stepX == 0.0 && stepZ == 0.0) {
            return null;
        }
        if (stepX == 0.0 || stepZ == 0.0) {
            Vec3 result = new Vec3(stepX, 0.0, stepZ);
            Vec3 blockPosition = entity.m_20182_().m_82549_(result).m_82520_(0.0, 0.5, 0.0);
            BlockPos target = new BlockPos(new Vec3i((int)Math.floor(blockPosition.m_7096_()), (int)Math.floor(blockPosition.m_7098_()), (int)Math.floor(blockPosition.m_7094_())));
            if (!world.m_46749_(target)) {
                return null;
            }
            BlockState state = world.m_8055_(target);
            if (state.m_60734_() instanceof StairBlock) {
                Half half = (Half)state.m_61143_((Property)StairBlock.f_56842_);
                if (half != Half.BOTTOM) {
                    return result;
                }
                Direction direction = (Direction)state.m_61143_((Property)StairBlock.f_56841_);
                if (stepZ > 0.0 && direction == Direction.SOUTH) {
                    return null;
                }
                if (stepZ < 0.0 && direction == Direction.NORTH) {
                    return null;
                }
                if (stepX > 0.0 && direction == Direction.EAST) {
                    return null;
                }
                if (stepX < 0.0 && direction == Direction.WEST) {
                    return null;
                }
            }
        }
        return new Vec3(stepX, 0.0, stepZ);
    }

    public static double getWallHeight(LivingEntity entity, Vec3 direction, double maxHeight, double accuracy) {
        double d = (double)entity.m_20205_() * 0.49;
        direction = direction.m_82541_();
        Level world = entity.m_9236_();
        Vec3 pos = entity.m_20182_();
        boolean canReturn = false;
        for (double height = 0.0; height < maxHeight; height += accuracy) {
            AABB box = new AABB(pos.m_7096_() + d + (double)(direction.m_7096_() > 0.0 ? 1 : 0), pos.m_7098_() + height, pos.m_7094_() + d + (double)(direction.m_7094_() > 0.0 ? 1 : 0), pos.m_7096_() - d + (double)(direction.m_7096_() < 0.0 ? -1 : 0), pos.m_7098_() + height + accuracy, pos.m_7094_() - d + (double)(direction.m_7094_() < 0.0 ? -1 : 0));
            if (!world.m_45756_((Entity)entity, box)) {
                canReturn = true;
                continue;
            }
            if (!canReturn) continue;
            return height;
        }
        return maxHeight;
    }

    public static double getWallHeight(LivingEntity entity) {
        Vec3 wall = WorldUtil.getWall(entity);
        if (wall == null) {
            return 0.0;
        }
        Level world = entity.m_9236_();
        double accuracy = entity.m_20206_() / 18.0f;
        double d = (double)entity.m_20205_() * 0.5;
        int loopNum = (int)Math.round((double)entity.m_20206_() / accuracy);
        Vec3 pos = entity.m_20182_();
        boolean canReturn = false;
        for (int i = 0; i < loopNum; ++i) {
            AABB box = new AABB(pos.m_7096_() + d + (double)(wall.m_7096_() > 0.0 ? 1 : 0), pos.m_7098_() + accuracy * (double)i, pos.m_7094_() + d + (double)(wall.m_7094_() > 0.0 ? 1 : 0), pos.m_7096_() - d + (double)(wall.m_7096_() < 0.0 ? -1 : 0), pos.m_7098_() + accuracy * (double)(i + 1), pos.m_7094_() - d + (double)(wall.m_7094_() < 0.0 ? -1 : 0));
            if (!world.m_45756_((Entity)entity, box)) {
                canReturn = true;
                continue;
            }
            if (!canReturn) continue;
            return accuracy * (double)i;
        }
        return entity.m_20206_();
    }

    @Nullable
    public static HangDown.BarAxis getHangableBars(LivingEntity entity) {
        double bbWidth = entity.m_20205_() / 4.0f;
        double bbHeight = 0.35;
        AABB bb = new AABB(entity.m_20185_() - bbWidth, entity.m_20186_() + (double)entity.m_20206_(), entity.m_20189_() - bbWidth, entity.m_20185_() + bbWidth, entity.m_20186_() + (double)entity.m_20206_() + 0.35, entity.m_20189_() + bbWidth);
        if (entity.m_20193_().m_45756_((Entity)entity, bb)) {
            return null;
        }
        BlockPos pos = new BlockPos((int)Math.floor(entity.m_20185_()), (int)Math.floor(entity.m_20186_() + (double)entity.m_20206_() + 0.4), (int)Math.floor(entity.m_20189_()));
        if (!entity.m_20193_().m_46749_(pos)) {
            return null;
        }
        BlockState state = entity.m_20193_().m_8055_(pos);
        Block block = state.m_60734_();
        HangDown.BarAxis axis = null;
        if (block instanceof RotatedPillarBlock) {
            if (state.m_60838_((BlockGetter)entity.m_20193_(), pos)) {
                return null;
            }
            Direction.Axis pillarAxis = (Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_);
            switch (pillarAxis) {
                case X: {
                    axis = HangDown.BarAxis.X;
                    break;
                }
                case Z: {
                    axis = HangDown.BarAxis.Z;
                }
            }
        } else if (block instanceof EndRodBlock) {
            if (state.m_60838_((BlockGetter)entity.m_9236_(), pos)) {
                return null;
            }
            Direction direction = (Direction)state.m_61143_((Property)DirectionalBlock.f_52588_);
            switch (direction) {
                case EAST: 
                case WEST: {
                    axis = HangDown.BarAxis.X;
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    axis = HangDown.BarAxis.Z;
                }
            }
        } else if (block instanceof CrossCollisionBlock) {
            int zCount = 0;
            int xCount = 0;
            if (((Boolean)state.m_61143_((Property)CrossCollisionBlock.f_52309_)).booleanValue()) {
                ++zCount;
            }
            if (((Boolean)state.m_61143_((Property)CrossCollisionBlock.f_52311_)).booleanValue()) {
                ++zCount;
            }
            if (((Boolean)state.m_61143_((Property)CrossCollisionBlock.f_52310_)).booleanValue()) {
                ++xCount;
            }
            if (((Boolean)state.m_61143_((Property)CrossCollisionBlock.f_52312_)).booleanValue()) {
                ++xCount;
            }
            if (zCount > 0 && xCount == 0) {
                axis = HangDown.BarAxis.Z;
            }
            if (xCount > 0 && zCount == 0) {
                axis = HangDown.BarAxis.X;
            }
        } else if (block instanceof WallBlock) {
            int zCount = 0;
            int xCount = 0;
            if (state.m_61143_((Property)WallBlock.f_57951_) != WallSide.NONE) {
                ++zCount;
            }
            if (state.m_61143_((Property)WallBlock.f_57952_) != WallSide.NONE) {
                ++zCount;
            }
            if (state.m_61143_((Property)WallBlock.f_57950_) != WallSide.NONE) {
                ++xCount;
            }
            if (state.m_61143_((Property)WallBlock.f_57953_) != WallSide.NONE) {
                ++xCount;
            }
            if (zCount > 0 && xCount == 0) {
                axis = HangDown.BarAxis.Z;
            }
            if (xCount > 0 && zCount == 0) {
                axis = HangDown.BarAxis.X;
            }
        }
        return axis;
    }

    public static boolean existsSpaceBelow(LivingEntity entity) {
        Vec3 center;
        Level world = entity.m_9236_();
        if (!world.m_46749_(new BlockPos((int)Math.floor((center = entity.m_20182_()).m_7096_()), (int)Math.floor(center.m_7098_()), (int)Math.floor(center.m_7094_())))) {
            return false;
        }
        double height = (double)entity.m_20206_() * 1.5;
        double width = entity.m_20205_() * 2.0f;
        AABB boundingBox = new AABB(center.m_7096_() - width, center.m_7098_() - 9.0, center.m_7094_() - width, center.m_7096_() + width, center.m_7098_() + height, center.m_7094_() + width);
        return world.m_45772_(boundingBox);
    }

    public static boolean existsDivableSpace(LivingEntity entity) {
        int i;
        Level world = entity.m_20193_();
        double width = (double)entity.m_20205_() * 1.5;
        double height = (double)entity.m_20206_() * 1.5;
        double wideWidth = entity.m_20205_() * 2.0f;
        Vec3 center = entity.m_20182_();
        if (!world.m_46749_(new BlockPos((int)Math.floor(center.m_7096_()), (int)Math.floor(center.m_7098_()), (int)Math.floor(center.m_7094_())))) {
            return false;
        }
        Vec3 diveDirection = VectorUtil.fromYawDegree(entity.m_6080_());
        for (int i2 = 0; i2 < 4; ++i2) {
            Vec3 centerPoint = center.m_82549_(diveDirection.m_82490_(width * (double)i2));
            AABB box = new AABB(centerPoint.m_7096_() - width, centerPoint.m_7098_() + 0.05, centerPoint.m_7094_() - width, centerPoint.m_7096_() + width, centerPoint.m_7098_() + height, centerPoint.m_7094_() + width);
            if (world.m_45756_((Entity)entity, box)) continue;
            return false;
        }
        AABB verticalWideBox = new AABB((center = center.m_82549_(diveDirection.m_82490_(4.0))).m_7096_() - wideWidth, center.m_7098_() - 7.0, center.m_7094_() - wideWidth, center.m_7096_() + wideWidth, center.m_7098_() + height, center.m_7094_() + wideWidth);
        if (world.m_45772_(verticalWideBox)) {
            return true;
        }
        BlockPos centerBlockPos = new BlockPos((int)Math.floor(center.m_7096_()), (int)Math.floor(center.m_7098_() - 0.5), (int)Math.floor(center.m_7094_()));
        if (!world.m_46749_(centerBlockPos)) {
            return false;
        }
        verticalWideBox = new AABB(center.m_7096_() - wideWidth, center.m_7098_() - 2.9, center.m_7094_() - wideWidth, center.m_7096_() + wideWidth, center.m_7098_() + height, center.m_7094_() + wideWidth);
        int waterLevel = -1;
        for (i = 0; i < 6; ++i) {
            Block block = world.m_8055_(centerBlockPos.m_6625_(i)).m_60734_();
            if (block == Blocks.f_50016_) continue;
            if (block == Blocks.f_49990_) {
                waterLevel = i;
                break;
            }
            return false;
        }
        if (waterLevel == -1) {
            return false;
        }
        boolean filledWithWater = true;
        while (i < waterLevel + 3) {
            BlockState state = world.m_8055_(centerBlockPos.m_6625_(i));
            if (state.m_60734_() != Blocks.f_49990_) {
                filledWithWater = false;
                break;
            }
            ++i;
        }
        return filledWithWater && world.m_45772_(verticalWideBox);
    }

    @Nullable
    public static Vec3 getGrabbableWall(LivingEntity entity) {
        double d = (double)entity.m_20205_() * 0.5;
        Level world = entity.m_9236_();
        double distance = entity.m_20205_() / 2.0f;
        double baseLine1 = entity.m_20192_() + (entity.m_20206_() - entity.m_20192_()) / 2.0f;
        double baseLine2 = entity.m_20206_() + (entity.m_20206_() - entity.m_20192_()) / 2.0f;
        Vec3 wall1 = WorldUtil.getGrabbableWall(entity, distance, baseLine1);
        if (wall1 != null) {
            return wall1;
        }
        return WorldUtil.getGrabbableWall(entity, distance, baseLine2);
    }

    private static Vec3 getGrabbableWall(LivingEntity entity, double distance, double baseLine) {
        float slipperiness;
        double d = (double)entity.m_20205_() * 0.49;
        Level world = entity.m_20193_();
        Vec3 pos = entity.m_20182_();
        AABB baseBoxSide = new AABB(pos.m_7096_() - d, pos.m_7098_() + baseLine - (double)(entity.m_20206_() / 6.0f), pos.m_7094_() - d, pos.m_7096_() + d, pos.m_7098_() + baseLine, pos.m_7094_() + d);
        AABB baseBoxTop = new AABB(pos.m_7096_() - d, pos.m_7098_() + baseLine, pos.m_7094_() - d, pos.m_7096_() + d, pos.m_7098_() + (double)entity.m_20206_(), pos.m_7094_() + d);
        int xDirection = 0;
        int zDirection = 0;
        if (!world.m_45756_((Entity)entity, baseBoxSide.m_82363_(distance, 0.0, 0.0)) && world.m_45756_((Entity)entity, baseBoxTop.m_82363_(distance, 0.0, 0.0))) {
            ++xDirection;
        }
        if (!world.m_45756_((Entity)entity, baseBoxSide.m_82363_(-distance, 0.0, 0.0)) && world.m_45756_((Entity)entity, baseBoxTop.m_82363_(-distance, 0.0, 0.0))) {
            --xDirection;
        }
        if (!world.m_45756_((Entity)entity, baseBoxSide.m_82363_(0.0, 0.0, distance)) && world.m_45756_((Entity)entity, baseBoxTop.m_82363_(0.0, 0.0, distance))) {
            ++zDirection;
        }
        if (!world.m_45756_((Entity)entity, baseBoxSide.m_82363_(0.0, 0.0, -distance)) && world.m_45756_((Entity)entity, baseBoxTop.m_82363_(0.0, 0.0, -distance))) {
            --zDirection;
        }
        if (xDirection == 0 && zDirection == 0) {
            return null;
        }
        if (xDirection != 0 && zDirection != 0) {
            BlockPos blockPos1 = new BlockPos((int)(entity.m_20185_() + (double)xDirection), (int)(entity.m_20191_().f_82289_ + baseLine - 0.3), (int)entity.m_20189_());
            BlockPos blockPos2 = new BlockPos((int)entity.m_20185_(), (int)(entity.m_20191_().f_82289_ + baseLine - 0.3), (int)(entity.m_20189_() + (double)zDirection));
            if (!entity.m_20193_().m_46749_(blockPos1)) {
                return null;
            }
            if (!entity.m_20193_().m_46749_(blockPos2)) {
                return null;
            }
            slipperiness = Math.min(entity.m_20193_().m_8055_(blockPos1).getFriction((LevelReader)entity.m_20193_(), blockPos1, (Entity)entity), entity.m_20193_().m_8055_(blockPos2).getFriction((LevelReader)entity.m_20193_(), blockPos2, (Entity)entity));
        } else {
            BlockPos blockPos = new BlockPos((int)(entity.m_20185_() + (double)xDirection), (int)(entity.m_20191_().f_82289_ + baseLine - 0.3), (int)(entity.m_20189_() + (double)zDirection));
            if (!entity.m_20193_().m_46749_(blockPos)) {
                return null;
            }
            slipperiness = entity.m_20193_().m_8055_(blockPos).getFriction((LevelReader)entity.m_20193_(), blockPos, (Entity)entity);
        }
        return (double)slipperiness <= 0.9 ? new Vec3((double)xDirection, 0.0, (double)zDirection) : null;
    }

    public static boolean isHideAbleBlock(BlockState blockState) {
        return blockState.m_204343_().anyMatch(it -> it.equals(BlockTags.HIDE_ABLE));
    }

    private static boolean getHideAbleSpace$isHideAble(Level world, Block block, BlockPos pos) {
        return world.m_46749_(pos) && world.m_8055_(pos).m_60713_(block) && world.m_8055_(pos.m_7494_()).m_60795_();
    }

    @Nullable
    public static Tuple<BlockPos, BlockPos> getHideAbleSpace(Entity entity, BlockPos base) {
        Level world = entity.m_9236_();
        if (!world.m_46749_(base)) {
            return null;
        }
        BlockState state = world.m_8055_(base);
        Block block = state.m_60734_();
        if (!WorldUtil.isHideAbleBlock(state)) {
            return null;
        }
        if (!world.m_8055_(base.m_7494_()).m_60795_()) {
            if (WorldUtil.getHideAbleSpace$isHideAble(world, block, base.m_7494_())) {
                return new Tuple((Object)base, (Object)base.m_7494_());
            }
            return null;
        }
        double entityWidth = entity.m_20205_();
        double entityHeight = entity.m_20206_();
        if (entityHeight >= 2.0 || entityWidth >= 1.0) {
            return null;
        }
        if (entityHeight < 1.0) {
            return new Tuple((Object)base, (Object)base);
        }
        Vec3 lookAngle = entity.m_20154_();
        if (Math.abs(lookAngle.m_7094_()) > Math.abs(lookAngle.m_7096_())) {
            if (lookAngle.m_7094_() > 0.0) {
                if (WorldUtil.getHideAbleSpace$isHideAble(world, block, base.m_122019_())) {
                    return new Tuple((Object)base, (Object)base.m_122019_());
                }
                if (lookAngle.m_7096_() > 0.0) {
                    if (WorldUtil.getHideAbleSpace$isHideAble(world, block, base.m_122029_())) {
                        return new Tuple((Object)base, (Object)base.m_122029_());
                    }
                    if (WorldUtil.getHideAbleSpace$isHideAble(world, block, base.m_122024_())) {
                        return new Tuple((Object)base, (Object)base.m_122024_());
                    }
                } else {
                    if (WorldUtil.getHideAbleSpace$isHideAble(world, block, base.m_122024_())) {
                        return new Tuple((Object)base, (Object)base.m_122024_());
                    }
                    if (WorldUtil.getHideAbleSpace$isHideAble(world, block, base.m_122029_())) {
                        return new Tuple((Object)base, (Object)base.m_122029_());
                    }
                }
                if (WorldUtil.getHideAbleSpace$isHideAble(world, block, base.m_122012_())) {
                    return new Tuple((Object)base, (Object)base.m_122012_());
                }
            } else {
                if (WorldUtil.getHideAbleSpace$isHideAble(world, block, base.m_122012_())) {
                    return new Tuple((Object)base, (Object)base.m_122012_());
                }
                if (lookAngle.m_7096_() > 0.0) {
                    if (WorldUtil.getHideAbleSpace$isHideAble(world, block, base.m_122029_())) {
                        return new Tuple((Object)base, (Object)base.m_122029_());
                    }
                    if (WorldUtil.getHideAbleSpace$isHideAble(world, block, base.m_122024_())) {
                        return new Tuple((Object)base, (Object)base.m_122024_());
                    }
                } else {
                    if (WorldUtil.getHideAbleSpace$isHideAble(world, block, base.m_122024_())) {
                        return new Tuple((Object)base, (Object)base.m_122024_());
                    }
                    if (WorldUtil.getHideAbleSpace$isHideAble(world, block, base.m_122029_())) {
                        return new Tuple((Object)base, (Object)base.m_122029_());
                    }
                }
                if (WorldUtil.getHideAbleSpace$isHideAble(world, block, base.m_122019_())) {
                    return new Tuple((Object)base, (Object)base.m_122019_());
                }
            }
        } else if (lookAngle.m_7096_() > 0.0) {
            if (WorldUtil.getHideAbleSpace$isHideAble(world, block, base.m_122029_())) {
                return new Tuple((Object)base, (Object)base.m_122029_());
            }
            if (lookAngle.m_7094_() > 0.0) {
                if (WorldUtil.getHideAbleSpace$isHideAble(world, block, base.m_122019_())) {
                    return new Tuple((Object)base, (Object)base.m_122019_());
                }
                if (WorldUtil.getHideAbleSpace$isHideAble(world, block, base.m_122012_())) {
                    return new Tuple((Object)base, (Object)base.m_122012_());
                }
            } else {
                if (WorldUtil.getHideAbleSpace$isHideAble(world, block, base.m_122012_())) {
                    return new Tuple((Object)base, (Object)base.m_122012_());
                }
                if (WorldUtil.getHideAbleSpace$isHideAble(world, block, base.m_122019_())) {
                    return new Tuple((Object)base, (Object)base.m_122019_());
                }
            }
            if (WorldUtil.getHideAbleSpace$isHideAble(world, block, base.m_122024_())) {
                return new Tuple((Object)base, (Object)base.m_122024_());
            }
        } else {
            if (WorldUtil.getHideAbleSpace$isHideAble(world, block, base.m_122024_())) {
                return new Tuple((Object)base, (Object)base.m_122024_());
            }
            if (lookAngle.m_7094_() > 0.0) {
                if (WorldUtil.getHideAbleSpace$isHideAble(world, block, base.m_122019_())) {
                    return new Tuple((Object)base, (Object)base.m_122019_());
                }
                if (WorldUtil.getHideAbleSpace$isHideAble(world, block, base.m_122012_())) {
                    return new Tuple((Object)base, (Object)base.m_122012_());
                }
            } else {
                if (WorldUtil.getHideAbleSpace$isHideAble(world, block, base.m_122012_())) {
                    return new Tuple((Object)base, (Object)base.m_122012_());
                }
                if (WorldUtil.getHideAbleSpace$isHideAble(world, block, base.m_122019_())) {
                    return new Tuple((Object)base, (Object)base.m_122019_());
                }
            }
            if (WorldUtil.getHideAbleSpace$isHideAble(world, block, base.m_122029_())) {
                return new Tuple((Object)base, (Object)base.m_122029_());
            }
        }
        if (world.m_8055_(base.m_7495_()).m_60713_(block) && Math.abs(entity.m_20186_() - (double)base.m_7495_().m_123342_()) < 0.2) {
            return new Tuple((Object)base.m_7495_(), (Object)base);
        }
        return null;
    }
}

