/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.inventorysorter;

import cpw.mods.inventorysorter.Config;
import cpw.mods.inventorysorter.ContainerContext;
import cpw.mods.inventorysorter.Network;
import cpw.mods.inventorysorter.ScrollWheelHandler;
import cpw.mods.inventorysorter.SortingHandler;
import java.util.function.Consumer;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.common.ForgeConfigSpec;

public enum Action {
    SORT(SortingHandler.INSTANCE, "key.inventorysorter.sort", 2, Config.ClientConfig.CONFIG.sortingModule),
    ONEITEMIN(ScrollWheelHandler.ONEITEMIN, "key.inventorysorter.itemin", 99, Config.ClientConfig.CONFIG.wheelmoveModule),
    ONEITEMOUT(ScrollWheelHandler.ONEITEMOUT, "key.inventorysorter.itemout", 101, Config.ClientConfig.CONFIG.wheelmoveModule);

    private final Consumer<ContainerContext> worker;
    private final String keyBindingName;
    private final int defaultKeyCode;
    private final ForgeConfigSpec.ConfigValue<Boolean> configValue;

    private Action(Consumer<ContainerContext> worker, String keyBindingName, int defaultKeyCode, ForgeConfigSpec.ConfigValue<Boolean> configValue) {
        this.worker = worker;
        this.keyBindingName = keyBindingName;
        this.defaultKeyCode = defaultKeyCode;
        this.configValue = configValue;
    }

    public String getKeyBindingName() {
        return this.keyBindingName;
    }

    public Network.ActionMessage message(Slot slot) {
        return new Network.ActionMessage(this, slot.f_40219_);
    }

    public void execute(ContainerContext context) {
        this.worker.accept(context);
    }

    public boolean isActive() {
        return (Boolean)this.configValue.get();
    }

    public int getDefaultKeyCode() {
        return this.defaultKeyCode;
    }
}

