/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.entity;

import de.maxhenkel.gravestone.GraveUtils;
import de.maxhenkel.gravestone.Main;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class GhostPlayerEntity
extends Monster {
    private static final EntityDataAccessor<Optional<UUID>> PLAYER_UUID = SynchedEntityData.m_135353_(GhostPlayerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Byte> PLAYER_MODEL = SynchedEntityData.m_135353_(GhostPlayerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);

    public GhostPlayerEntity(EntityType type, Level world) {
        super(type, world);
    }

    public GhostPlayerEntity(Level world, UUID playerUUID, Component name, NonNullList<ItemStack> equipment, byte model) {
        this((EntityType)Main.GHOST.get(), world);
        this.setPlayerUUID(playerUUID);
        this.m_6593_(name);
        this.setModel(model);
        Arrays.fill(this.f_21348_, 0.0f);
        Arrays.fill(this.f_21347_, 0.0f);
        for (int i = 0; i < EquipmentSlot.values().length; ++i) {
            this.m_8061_(EquipmentSlot.values()[i], (ItemStack)equipment.get(i));
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(PLAYER_UUID, Optional.empty());
        this.m_20088_().m_135372_(PLAYER_MODEL, (Object)0);
    }

    public static AttributeSupplier getGhostAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22279_, (double)0.23f).m_22268_(Attributes.f_22277_, 35.0).m_22265_();
    }

    public boolean m_6052_() {
        return false;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
        if (((Boolean)Main.SERVER_CONFIG.friendlyGhost.get()).booleanValue()) {
            this.f_21346_.m_25352_(10, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, false, true, entityLiving -> entityLiving != null && !entityLiving.m_20145_() && (entityLiving instanceof Monster || entityLiving instanceof Slime) && !(entityLiving instanceof Creeper) && !(entityLiving instanceof GhostPlayerEntity)));
        } else {
            this.f_21346_.m_25352_(10, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        }
    }

    public boolean m_21222_() {
        return true;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public void setPlayerUUID(UUID uuid) {
        this.m_20088_().m_135381_(PLAYER_UUID, Optional.of(uuid));
        if (uuid.toString().equals("af3bd5f4-8634-4700-8281-e4cc851be180")) {
            this.setOverpowered();
        }
    }

    private void setOverpowered() {
        this.m_21051_(Attributes.f_22277_).m_22100_(35.0);
        this.m_21051_(Attributes.f_22279_).m_22100_(0.4);
        this.m_21051_(Attributes.f_22281_).m_22100_(20.0);
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        if (name != null && name.getString().equals("henkelmax")) {
            this.setOverpowered();
        }
    }

    public UUID getPlayerUUID() {
        return ((Optional)this.m_20088_().m_135370_(PLAYER_UUID)).orElse(GraveUtils.EMPTY_UUID);
    }

    public void setModel(byte model) {
        this.f_19804_.m_135381_(PLAYER_MODEL, (Object)model);
    }

    public byte getModel() {
        return (Byte)this.f_19804_.m_135370_(PLAYER_MODEL);
    }

    public boolean isWearing(PlayerModelPart part) {
        return (this.getModel() & part.m_36445_()) == part.m_36445_();
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        ((Optional)this.m_20088_().m_135370_(PLAYER_UUID)).ifPresent(uuid -> compound.m_128362_("PlayerUUID", uuid));
        compound.m_128344_("Model", this.getModel());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("player_uuid")) {
            String uuidStr = compound.m_128461_("player_uuid");
            try {
                UUID uuid = UUID.fromString(uuidStr);
                this.setPlayerUUID(uuid);
            }
            catch (Exception exception) {}
        } else if (compound.m_128441_("PlayerUUID")) {
            this.setPlayerUUID(compound.m_128342_("PlayerUUID"));
        }
        this.setModel(compound.m_128445_("Model"));
    }

    public boolean m_7327_(Entity entity) {
        if (entity.m_7755_().getString().equals("henkelmax") || entity.m_20148_().toString().equals("af3bd5f4-8634-4700-8281-e4cc851be180")) {
            return true;
        }
        return super.m_7327_(entity);
    }
}

