/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.feeding;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.filter.IFilter;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.StorageAccessWrapper;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.FilterSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.IEnable;
import com.tiviacz.travelersbackpack.inventory.upgrades.ITickableUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.feeding.FeedingFilterSettings;
import com.tiviacz.travelersbackpack.inventory.upgrades.feeding.FeedingWidget;
import com.tiviacz.travelersbackpack.util.InventoryHelper;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class FeedingUpgrade
extends UpgradeBase<FeedingUpgrade>
implements IFilter,
IEnable,
ITickableUpgrade {
    private static final int STILL_HUNGRY_COOLDOWN = 10;
    public ItemStackHandler filter;
    private final FeedingFilterSettings filterSettings;

    public FeedingUpgrade(UpgradeManager manager, int dataHolderSlot, NonNullList<ItemStack> filter) {
        super(manager, dataHolderSlot, new Point(66, 103));
        this.filter = this.createFilter(filter);
        int activeSlotCount = (Integer)TravelersBackpackConfig.SERVER.backpackUpgrades.feedingUpgradeSettings.filterSlotCount.get();
        this.filterSettings = new FeedingFilterSettings(manager.getWrapper().getStorage(), filter.stream().limit(activeSlotCount).filter(stack -> !stack.m_41619_()).toList(), this.getFilter());
    }

    @Override
    public List<Integer> getFilter() {
        List<Integer> filter = NbtHelper.getOrDefault(this.getDataHolderStack(), "FilterSettings", List.of(Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(0)));
        if (filter.size() != 3) {
            filter = List.of(Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(0));
        }
        return filter;
    }

    public FeedingFilterSettings getFilterSettings() {
        return this.filterSettings;
    }

    public boolean canEat(Player player, ItemStack stack) {
        return this.getFilterSettings().matchesFilter(player, stack) && !player.m_36335_().m_41519_(stack.m_41720_());
    }

    @Override
    public void updateSettings() {
        this.filterSettings.updateSettings(this.getFilter());
    }

    @Override
    public int getFilterSlotCount() {
        return (Integer)TravelersBackpackConfig.SERVER.backpackUpgrades.feedingUpgradeSettings.filterSlotCount.get();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public WidgetBase<BackpackScreen> createWidget(BackpackScreen screen, int x, int y) {
        return new FeedingWidget(screen, this, new Point(screen.getGuiLeft() + x, screen.getGuiTop() + y));
    }

    @Override
    public List<Slot> getUpgradeSlots(final BackpackBaseMenu menu, BackpackWrapper wrapper, int x, int y) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        int activeSlotCount = (Integer)TravelersBackpackConfig.SERVER.backpackUpgrades.feedingUpgradeSettings.filterSlotCount.get();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                slots.add((Slot)new FilterSlotItemHandler(this, (IItemHandler)this.filter, j + i * 3, x + 7 + j * 18, y + 44 + i * 18, activeSlotCount){

                    @Override
                    public boolean m_5857_(ItemStack pStack) {
                        return menu.getWrapper().isOwner(menu.player) && super.m_5857_(pStack);
                    }
                });
            }
        }
        return slots;
    }

    private ItemStackHandler createFilter(NonNullList<ItemStack> stacks) {
        return new ItemStackHandler(stacks){

            protected void onContentsChanged(int slot) {
                FeedingUpgrade.this.updateDataHolderUnchecked("Inventory", FeedingUpgrade.this.filter);
                FeedingUpgrade.this.getFilterSettings().updateFilter((List)NbtHelper.get(FeedingUpgrade.this.getDataHolderStack(), "Inventory"));
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return stack.m_41614_();
            }

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }

    @Override
    public int getTickRate() {
        return (Integer)TravelersBackpackConfig.SERVER.backpackUpgrades.feedingUpgradeSettings.tickRate.get();
    }

    @Override
    public void tick(@Nullable Player player, Level level, BlockPos pos, int currentTick) {
        if (this.getCooldown() == 0) {
            return;
        }
        if (currentTick % this.getCooldown() != 0) {
            return;
        }
        if (level.f_46443_) {
            return;
        }
        this.getUpgradeManager().getWrapper().loadAdditionally(0);
        if (this.feedPlayerAndGetHungry(player, level)) {
            this.setCooldown(10);
            return;
        }
        if (!this.hasCooldown() || this.getCooldown() != this.getTickRate()) {
            this.setCooldown(this.getTickRate());
        }
    }

    private boolean feedPlayerAndGetHungry(Player player, Level level) {
        int hungerLevel = 20 - player.m_36324_().m_38702_();
        if (hungerLevel == 0 || level.f_46443_) {
            return false;
        }
        return this.tryFeedingFoodFromStorage(level, hungerLevel, player) && player.m_36324_().m_38702_() < 20;
    }

    private boolean tryFeedingFoodFromStorage(Level level, int hungerLevel, Player player) {
        ItemStackHandler storage = this.getUpgradeManager().getWrapper().getStorage();
        return InventoryHelper.iterateHandler(storage, (slot, stack) -> this.tryFeedingStack(level, hungerLevel, player, (Integer)slot, (ItemStack)stack, storage));
    }

    private boolean tryFeedingStack(Level level, int hungerLevel, Player player, Integer slot, ItemStack stack, ItemStackHandler backpackStorage) {
        if (FeedingUpgrade.isEdible(stack, (LivingEntity)player) && this.canEat(player, stack)) {
            ItemStack mainHandItem = player.m_21205_();
            player.m_150109_().f_35974_.set(player.m_150109_().f_35977_, (Object)stack);
            ItemStack singleItemCopy = stack.m_41777_();
            singleItemCopy.m_41764_(1);
            if (singleItemCopy.m_41682_(level, player, InteractionHand.MAIN_HAND).m_19089_() == InteractionResult.CONSUME) {
                ItemStack insertResult;
                player.m_150109_().f_35974_.set(player.m_150109_().f_35977_, (Object)mainHandItem);
                stack.m_41774_(1);
                backpackStorage.setStackInSlot(slot.intValue(), stack);
                ItemStack resultItem = ForgeEventFactory.onItemUseFinish((LivingEntity)player, (ItemStack)singleItemCopy, (int)0, (ItemStack)singleItemCopy.m_41720_().m_5922_(singleItemCopy, level, (LivingEntity)player));
                if (!resultItem.m_41619_() && !(insertResult = InventoryHelper.addItemStackToHandler(new StorageAccessWrapper(this.getUpgradeManager().getWrapper(), backpackStorage), resultItem, false)).m_41619_()) {
                    player.m_36176_(insertResult, true);
                }
                return true;
            }
            player.m_150109_().f_35974_.set(player.m_150109_().f_35977_, (Object)mainHandItem);
        }
        return false;
    }

    private static boolean isEdible(ItemStack stack, LivingEntity player) {
        if (!stack.m_41614_()) {
            return false;
        }
        FoodProperties foodProperties = stack.m_41720_().getFoodProperties(stack, player);
        return foodProperties != null && foodProperties.m_38744_() >= 1;
    }
}

