/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.renderers;

import dlovin.inventoryhud.config.InvConfig;
import dlovin.inventoryhud.gui.renderers.HudRenderer;
import dlovin.inventoryhud.utils.EachItem;
import dlovin.inventoryhud.utils.WidgetAligns;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;

public class ArmorRenderer
extends HudRenderer {
    protected static Predicate<ItemStack> AMMO_TYPES = i -> i.m_41720_() instanceof ArrowItem;
    public boolean showMain;
    public boolean showOff;
    public boolean showArmor;
    public boolean showEmpty;
    public boolean showInv;
    public boolean showArrows;
    public boolean armBars;
    public boolean showCount;
    public boolean withDebug;
    public boolean showArrowsWithoutWeapon;
    public int armX;
    public int armY;
    public int armAbove;
    public float armScale;
    public WidgetAligns ArmAligns;
    public InvConfig.ArmorView armView;
    public EachItem[] items = new EachItem[8];
    Minecraft mc;
    Font fontRenderer;
    ItemRenderer itemRenderer;
    ResourceLocation[] armorRL = new ResourceLocation[]{new ResourceLocation("inventoryhud", "textures/item/empty_armor_slot_helmet.png"), new ResourceLocation("inventoryhud", "textures/item/empty_armor_slot_chestplate.png"), new ResourceLocation("inventoryhud", "textures/item/empty_armor_slot_leggings.png"), new ResourceLocation("inventoryhud", "textures/item/empty_armor_slot_boots.png"), new ResourceLocation("inventoryhud", "textures/item/empty_armor_slot_shield.png"), new ResourceLocation("inventoryhud", "textures/item/empty_main_hand_slot.png"), new ResourceLocation("inventoryhud", "textures/item/inventory.png"), new ResourceLocation("inventoryhud", "textures/item/arrows.png")};

    public ArmorRenderer(Minecraft mc) {
        this.mc = mc;
        this.fontRenderer = mc.f_91062_;
        this.itemRenderer = mc.m_91291_();
    }

    protected String getText(ItemStack item, int damage) {
        return switch (this.armView) {
            default -> throw new IncompatibleClassChangeError();
            case InvConfig.ArmorView.PERCENTAGE -> this.getDamageText(String.valueOf(damage), damage) + ChatFormatting.WHITE + "%";
            case InvConfig.ArmorView.DAMAGE -> this.getDamageText(String.valueOf(item.m_41773_()), damage);
            case InvConfig.ArmorView.DAMAGE_LEFT -> this.getDamageText(String.valueOf(item.m_41776_() - item.m_41773_()), damage);
            case InvConfig.ArmorView.OFF -> null;
        };
    }

    private String getDamageText(String p, int d) {
        Object result = p;
        if (d == 100) {
            result = ChatFormatting.GREEN + (String)result;
        } else if (d < 1) {
            result = ChatFormatting.DARK_RED + (String)result;
        } else if (d <= 10) {
            result = ChatFormatting.RED + (String)result;
        } else if (d <= 25) {
            result = ChatFormatting.GOLD + (String)result;
        } else if (d <= 50) {
            result = ChatFormatting.YELLOW + (String)result;
        }
        return result;
    }

    protected boolean showArrows() {
        return this.showArrows && (this.withProjectileWeapon(this.mc.f_91074_.m_21205_(), this.mc.f_91074_.m_21206_()) || this.showArrowsWithoutWeapon);
    }

    private boolean withProjectileWeapon(ItemStack mainHand, ItemStack offHand) {
        return mainHand.m_41720_() instanceof ProjectileWeaponItem || offHand.m_41720_() instanceof ProjectileWeaponItem;
    }

    Predicate<ItemStack> getAllProj(ItemStack mainHand, ItemStack offHand) {
        Item item = mainHand.m_41720_();
        if (item instanceof ProjectileWeaponItem) {
            ProjectileWeaponItem item2 = (ProjectileWeaponItem)item;
            return item2.m_6442_().and(i -> offHand == i).or(item2.m_6437_());
        }
        item = offHand.m_41720_();
        if (item instanceof ProjectileWeaponItem) {
            ProjectileWeaponItem item3 = (ProjectileWeaponItem)item;
            return item3.m_6442_().and(i -> mainHand == i).or(item3.m_6437_());
        }
        return AMMO_TYPES;
    }

    protected int[] getFreeAndAmmo() {
        int[] result = new int[]{0, 0};
        Predicate<ItemStack> ammoTypes = this.getAllProj(this.mc.f_91074_.m_21205_(), this.mc.f_91074_.m_21206_());
        for (ItemStack slot : this.mc.f_91074_.m_150109_().f_35974_) {
            if (slot.m_41619_()) {
                result[0] = result[0] + 1;
            }
            if (!this.isAmmo(slot, ammoTypes)) continue;
            result[1] = result[1] + slot.m_41613_();
        }
        for (ItemStack slot : this.mc.f_91074_.m_150109_().f_35976_) {
            if (!this.isAmmo(slot, ammoTypes)) continue;
            result[1] = result[1] + slot.m_41613_();
        }
        return result;
    }

    boolean isAmmo(ItemStack stack, Predicate<ItemStack> ammoTypes) {
        return !stack.m_41619_() && ammoTypes.test(stack);
    }

    int getItemCount(ItemStack item) {
        int result = 0;
        for (ItemStack slot : this.mc.f_91074_.m_150109_().f_35974_) {
            if (!ItemStack.m_41656_((ItemStack)slot, (ItemStack)item)) continue;
            result += slot.m_41613_();
        }
        for (ItemStack slot : this.mc.f_91074_.m_150109_().f_35976_) {
            if (!ItemStack.m_41656_((ItemStack)slot, (ItemStack)item)) continue;
            result += slot.m_41613_();
        }
        return result;
    }

    boolean getRight(int x, WidgetAligns.HAlign hal) {
        return switch (hal) {
            default -> throw new IncompatibleClassChangeError();
            case WidgetAligns.HAlign.LEFT -> false;
            case WidgetAligns.HAlign.MIDDLE -> {
                if (x > 0) {
                    yield true;
                }
                yield false;
            }
            case WidgetAligns.HAlign.RIGHT -> true;
        };
    }

    void renderElementInBlock(GuiGraphics gui, int offSetX, int offSetY, boolean right, @Nullable ResourceLocation res, @Nullable ItemStack item, @Nullable String text, boolean overlay, int seed) {
        if (res != null) {
            gui.m_280163_(res, offSetX, offSetY, 16.0f, 16.0f, 16, 16, 16, 16);
        } else {
            gui.m_280168_().m_85836_();
            gui.m_280168_().m_85837_((double)offSetX, (double)offSetY, -256.0);
            gui.m_280638_((LivingEntity)this.mc.f_91074_, item, 0, 0, seed);
            if (overlay) {
                gui.m_280370_(this.fontRenderer, item, 0, 0);
            }
            gui.m_280168_().m_85849_();
        }
        if (text == null) {
            return;
        }
        gui.m_280488_(this.fontRenderer, text, right ? offSetX + 17 : offSetX - 1 - this.fontRenderer.m_92895_(text), offSetY + 4, 0xFFFFFF);
    }

    void renderElement(GuiGraphics gui, boolean right, @Nullable ResourceLocation res, @Nullable ItemStack item, @Nullable String text, boolean overlay, int seed) {
        if (res != null) {
            gui.m_280163_(res, 0, 0, 16.0f, 16.0f, 16, 16, 16, 16);
        } else {
            gui.m_280168_().m_85836_();
            gui.m_280638_((LivingEntity)this.mc.f_91074_, item, 0, 0, seed);
            if (overlay) {
                gui.m_280370_(this.fontRenderer, item, 0, 0);
            }
            gui.m_280168_().m_85849_();
        }
        if (text == null) {
            return;
        }
        gui.m_280488_(this.fontRenderer, text, right ? 17 : -1 - this.fontRenderer.m_92895_(text), 4, 0xFFFFFF);
    }

    public void render(GuiGraphics gui, int width, int height) {
    }

    protected void preRender(GuiGraphics gui, int x, int y) {
        gui.m_280168_().m_85836_();
        gui.m_280168_().m_85837_((double)x, (double)y, -256.0);
    }

    protected void postRender(GuiGraphics gui) {
        gui.m_280168_().m_85849_();
    }
}

