/*
 * Decompiled with CFR 0.152.
 */
package tfar.overpoweredarmorbar;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Configs {
    public static final ClientConfig CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (ClientConfig)specPair.getLeft();
    }

    public static class ClientConfig {
        public static ForgeConfigSpec.BooleanValue alwaysShowArmorBar;
        public static ForgeConfigSpec.BooleanValue showEmptyArmorIcons;
        public static ForgeConfigSpec.ConfigValue<List<? extends String>> colorValues;

        ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.push("general");
            colorValues = builder.comment("Colors must be specified in #RRGGBB format").translation("text.overloadedarmorbar.config.colorvalue").defineList("color values", (List)Lists.newArrayList((Object[])new String[]{"#FFFFFF", "#FF5500", "#FFC747", "#27FFE3", "#00FF00", "#7F00FF"}), String.class::isInstance);
            alwaysShowArmorBar = builder.comment("Always show armor bar even if empty?").translation("text.overloadedarmorbar.config.alwaysshowarmorbar").define("Always show bar", false);
            showEmptyArmorIcons = builder.comment("Show empty armor icons?").translation("text.overloadedarmorbar.config.showemptyarmoricons").define("Show empty icons", false);
            builder.pop();
        }
    }
}

