/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged.container;

import java.util.Arrays;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.RegistryObject;
import se.mickelus.mutil.util.ItemHandlerWrapper;
import se.mickelus.mutil.util.TileEntityOptional;
import se.mickelus.tetra.blocks.forged.container.ForgedContainerBlock;
import se.mickelus.tetra.blocks.forged.container.ForgedContainerMenu;
import se.mickelus.tetra.blocks.salvage.BlockInteraction;

@ParametersAreNonnullByDefault
public class ForgedContainerBlockEntity
extends BlockEntity
implements MenuProvider {
    private static final String inventoryKey = "inv";
    private static final ResourceLocation lockLootTable = new ResourceLocation("tetra", "forged/lock_break");
    private static final ResourceLocation containerLootTable = new ResourceLocation("tetra", "forged/container_content");
    public static RegistryObject<BlockEntityType<ForgedContainerBlockEntity>> type;
    public static int lockIntegrityMax;
    public static int lockCount;
    public static int lidIntegrityMax;
    public static int compartmentCount;
    public static int compartmentSize;
    private final int[] lockIntegrity;
    private final LazyOptional<ItemStackHandler> handler = LazyOptional.of(() -> new ItemStackHandler(compartmentSize * compartmentCount){

        protected void onContentsChanged(int slot) {
            ForgedContainerBlockEntity.this.m_6596_();
        }
    });
    public long openTime = -1L;
    private int lidIntegrity = 0;

    public ForgedContainerBlockEntity(BlockPos p_155268_, BlockState p_155269_) {
        super((BlockEntityType)type.get(), p_155268_, p_155269_);
        this.lockIntegrity = new int[lockCount];
    }

    public static BlockState getUpdatedBlockState(BlockState blockState, int[] lockIntegrity, int lidIntegrity) {
        if (((Boolean)blockState.m_61143_((Property)ForgedContainerBlock.flippedProp)).booleanValue()) {
            return (BlockState)((BlockState)((BlockState)((BlockState)blockState.m_61124_((Property)ForgedContainerBlock.locked1Prop, (Comparable)Boolean.valueOf(lockIntegrity[2] > 0))).m_61124_((Property)ForgedContainerBlock.locked2Prop, (Comparable)Boolean.valueOf(lockIntegrity[3] > 0))).m_61124_((Property)ForgedContainerBlock.anyLockedProp, (Comparable)Boolean.valueOf(Arrays.stream(lockIntegrity).anyMatch(integrity -> integrity > 0)))).m_61124_((Property)ForgedContainerBlock.openProp, (Comparable)Boolean.valueOf(lidIntegrity <= 0));
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)blockState.m_61124_((Property)ForgedContainerBlock.locked1Prop, (Comparable)Boolean.valueOf(lockIntegrity[0] > 0))).m_61124_((Property)ForgedContainerBlock.locked2Prop, (Comparable)Boolean.valueOf(lockIntegrity[1] > 0))).m_61124_((Property)ForgedContainerBlock.anyLockedProp, (Comparable)Boolean.valueOf(Arrays.stream(lockIntegrity).anyMatch(integrity -> integrity > 0)))).m_61124_((Property)ForgedContainerBlock.openProp, (Comparable)Boolean.valueOf(lidIntegrity <= 0));
    }

    public static void writeLockData(CompoundTag compound, int[] lockIntegrity) {
        for (int i = 0; i < lockIntegrity.length; ++i) {
            compound.m_128405_("lock_integrity" + i, lockIntegrity[i]);
        }
    }

    public static void writeLidData(CompoundTag compound, int lidIntegrity) {
        compound.m_128405_("lid_integrity", lidIntegrity);
    }

    public ForgedContainerBlockEntity getOrDelegate() {
        if (this.f_58857_ != null && this.m_58900_().m_60734_() instanceof ForgedContainerBlock && this.isFlipped()) {
            return TileEntityOptional.from((BlockGetter)this.f_58857_, (BlockPos)this.f_58858_.m_121945_(this.getFacing().m_122428_()), ForgedContainerBlockEntity.class).orElse(null);
        }
        return this;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        ForgedContainerBlockEntity delegate;
        if (cap == ForgeCapabilities.ITEM_HANDLER && (delegate = this.getOrDelegate()) != null) {
            return delegate.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void open(@Nullable Player player) {
        if (this.lidIntegrity > 0) {
            --this.lidIntegrity;
            this.m_6596_();
            if (!this.f_58857_.f_46443_) {
                ServerLevel worldServer = (ServerLevel)this.f_58857_;
                if (this.lidIntegrity == 0) {
                    this.populateInventory(worldServer, (ServerPlayer)player);
                    this.causeOpeningEffects(worldServer);
                } else {
                    worldServer.m_5594_(null, this.f_58858_, SoundEvents.f_12011_, SoundSource.PLAYERS, 0.5f, 1.3f);
                }
                Optional.ofNullable(player).filter(p -> !p.m_21023_(MobEffects.f_19600_)).ifPresent(p -> p.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 200, 5)));
            } else if (this.lidIntegrity == 0) {
                this.openTime = System.currentTimeMillis();
            }
            this.updateBlockState();
        }
    }

    private void populateInventory(ServerLevel serverWorld, @Nullable ServerPlayer player) {
        this.handler.ifPresent(handler -> {
            LootTable lootTable = serverWorld.m_7654_().m_278653_().m_278676_(containerLootTable);
            LootParams.Builder builder = new LootParams.Builder(serverWorld).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)this.f_58858_));
            if (player != null) {
                CriteriaTriggers.f_10563_.m_54597_(player, containerLootTable);
                builder = builder.m_287286_(LootContextParams.f_81455_, (Object)player).m_287239_(player.m_36336_());
            }
            lootTable.m_287188_((Container)new ItemHandlerWrapper((IItemHandler)handler), builder.m_287235_(LootContextParamSets.f_81411_), this.m_58900_().m_60726_(this.m_58899_()));
        });
    }

    private void causeOpeningEffects(ServerLevel worldServer) {
        Direction facing = (Direction)worldServer.m_8055_(this.f_58858_).m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        Vec3 smokeDirection = Vec3.m_82528_((Vec3i)facing.m_122427_().m_122436_());
        Random random = new Random();
        int smokeCount = 5 + random.nextInt(4);
        BlockPos smokeOrigin = this.f_58858_;
        if (Direction.SOUTH.equals((Object)facing)) {
            smokeOrigin = smokeOrigin.m_7918_(1, 0, 0);
        } else if (Direction.WEST.equals((Object)facing)) {
            smokeOrigin = smokeOrigin.m_7918_(1, 0, 1);
        } else if (Direction.NORTH.equals((Object)facing)) {
            smokeOrigin = smokeOrigin.m_7918_(0, 0, 1);
        }
        for (int i = 0; i < smokeCount; ++i) {
            worldServer.m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)smokeOrigin.m_123341_() + smokeDirection.f_82479_ * (double)i * 2.0 / (double)(smokeCount - 1), (double)smokeOrigin.m_123342_() + 0.8, (double)smokeOrigin.m_123343_() + smokeDirection.f_82481_ * (double)i * 2.0 / (double)(smokeCount - 1), 1, 0.0, 0.0, 0.0, 0.0);
        }
        worldServer.m_5594_(null, this.f_58858_, SoundEvents.f_12012_, SoundSource.PLAYERS, 1.0f, 0.5f);
        worldServer.m_5594_(null, this.f_58858_, SoundEvents.f_12031_, SoundSource.PLAYERS, 0.2f, 0.8f);
    }

    private void updateBlockState() {
        this.f_58857_.m_7731_(this.f_58858_, ForgedContainerBlockEntity.getUpdatedBlockState(this.m_58900_(), this.lockIntegrity, this.lidIntegrity), 3);
        BlockPos offsetPos = this.f_58858_.m_121945_(this.getFacing().m_122427_());
        this.f_58857_.m_7731_(offsetPos, ForgedContainerBlockEntity.getUpdatedBlockState(this.f_58857_.m_8055_(offsetPos), this.lockIntegrity, this.lidIntegrity), 3);
    }

    public Direction getFacing() {
        return (Direction)this.m_58900_().m_61143_((Property)ForgedContainerBlock.facingProp);
    }

    public boolean isFlipped() {
        return (Boolean)this.m_58900_().m_61143_((Property)ForgedContainerBlock.flippedProp);
    }

    public boolean isOpen() {
        return this.lidIntegrity <= 0;
    }

    public boolean isLocked(int index) {
        return this.lockIntegrity[index] > 0;
    }

    public Boolean[] isLocked() {
        return (Boolean[])Arrays.stream(this.lockIntegrity).mapToObj(integrity -> integrity > 0).toArray(Boolean[]::new);
    }

    public void breakLock(@Nullable Player player, int index, @Nullable InteractionHand hand) {
        if (this.lockIntegrity[index] > 0) {
            int n = index;
            this.lockIntegrity[n] = this.lockIntegrity[n] - 1;
            if (this.lockIntegrity[index] == 0) {
                this.f_58857_.m_5594_(player, this.f_58858_, SoundEvents.f_12347_, SoundSource.PLAYERS, 1.0f, 0.5f);
            } else {
                this.f_58857_.m_5594_(player, this.f_58858_, SoundEvents.f_12600_, SoundSource.PLAYERS, 1.0f, 0.5f);
            }
            if (!this.f_58857_.f_46443_ && this.lockIntegrity[index] == 0) {
                if (player != null) {
                    BlockInteraction.dropLoot(lockLootTable, player, hand, (ServerLevel)this.f_58857_, this.m_58900_());
                } else {
                    BlockInteraction.dropLoot(lockLootTable, (ServerLevel)this.f_58857_, this.m_58899_(), this.m_58900_());
                }
            }
        }
        this.updateBlockState();
        this.m_6596_();
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"forged_container");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player playerEntity) {
        return new ForgedContainerMenu(windowId, this, (Container)playerInventory, playerEntity);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.handler.ifPresent(handler -> handler.deserializeNBT(compound.m_128469_(inventoryKey)));
        for (int i = 0; i < this.lockIntegrity.length; ++i) {
            this.lockIntegrity[i] = compound.m_128451_("lock_integrity" + i);
        }
        this.lidIntegrity = compound.m_128451_("lid_integrity");
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        this.handler.ifPresent(handler -> compound.m_128365_(inventoryKey, (Tag)handler.serializeNBT()));
        ForgedContainerBlockEntity.writeLockData(compound, this.lockIntegrity);
        ForgedContainerBlockEntity.writeLidData(compound, this.lidIntegrity);
    }

    static {
        lockIntegrityMax = 4;
        lockCount = 4;
        lidIntegrityMax = 5;
        compartmentCount = 3;
        compartmentSize = 54;
    }
}

