/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.rack;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import se.mickelus.tetra.blocks.rack.RackBlock;
import se.mickelus.tetra.blocks.rack.RackTile;
import se.mickelus.tetra.items.modular.impl.ModularBladedItem;
import se.mickelus.tetra.items.modular.impl.crossbow.ModularCrossbowItem;
import se.mickelus.tetra.items.modular.impl.shield.ModularShieldItem;

@ParametersAreNonnullByDefault
@OnlyIn(value=Dist.CLIENT)
public class RackTESR
implements BlockEntityRenderer<RackTile> {
    private final ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();

    public RackTESR(BlockEntityRendererProvider.Context context) {
    }

    public void render(RackTile tile, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        tile.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
            Direction direction = (Direction)tile.m_58900_().m_61143_((Property)RackBlock.facingProp);
            Direction itemDirection = direction.m_122428_();
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.5 - (double)direction.m_122429_() * 0.36, 0.7, 0.5 - (double)direction.m_122431_() * 0.36);
            matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack itemStack = handler.getStackInSlot(i);
                if (itemStack.m_41619_()) continue;
                matrixStack.m_85836_();
                matrixStack.m_85837_((double)itemDirection.m_122429_() * ((double)i - 0.5), 0.0, (double)itemDirection.m_122431_() * ((double)i - 0.5));
                matrixStack.m_252781_(direction.m_253075_());
                this.renderItemStack(tile, itemStack, matrixStack, buffer, combinedLight, combinedOverlay);
                matrixStack.m_85849_();
            }
            matrixStack.m_85849_();
        });
    }

    private void renderItemStack(RackTile tile, ItemStack itemStack, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (itemStack != null && !itemStack.m_41619_()) {
            int renderId = (int)tile.m_58899_().m_121878_();
            BakedModel model = this.itemRenderer.m_174264_(itemStack, tile.m_58904_(), null, combinedLight);
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
            matrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            if (itemStack.m_41720_() instanceof ModularShieldItem) {
                matrixStack.m_85837_(-0.25, 0.0, 0.16);
                matrixStack.m_85841_(2.0f, 2.0f, 2.0f);
            } else if (itemStack.m_41720_() instanceof ModularBladedItem || itemStack.m_41720_() instanceof SwordItem) {
                matrixStack.m_85837_(0.0, -0.2, 0.0);
                matrixStack.m_252781_(Axis.f_252403_.m_252977_(135.0f));
            } else if (itemStack.m_41720_() instanceof ModularCrossbowItem || itemStack.m_41720_() instanceof CrossbowItem) {
                matrixStack.m_85837_(0.0, -0.2, 0.0);
                matrixStack.m_252781_(Axis.f_252403_.m_252977_(225.0f));
            } else if (model.m_7539_()) {
                matrixStack.m_252781_(Axis.f_252403_.m_252977_(-45.0f));
            } else {
                matrixStack.m_252781_(Axis.f_252403_.m_252977_(-45.0f));
            }
            Minecraft.m_91087_().m_91291_().m_269128_(itemStack, ItemDisplayContext.FIXED, combinedLight, combinedOverlay, matrixStack, buffer, tile.m_58904_(), renderId);
        }
    }
}

