/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.workbench.action;

import java.util.Collection;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolAction;
import se.mickelus.tetra.blocks.workbench.WorkbenchTile;
import se.mickelus.tetra.blocks.workbench.action.ConfigAction;
import se.mickelus.tetra.properties.PropertyHelper;

@ParametersAreNonnullByDefault
public class ConfigActionImpl
extends ConfigAction {
    private static final LootContextParamSet lootParameters = new LootContextParamSet.Builder().m_81406_(LootContextParams.f_81460_).m_81408_(LootContextParams.f_81463_).m_81408_(LootContextParams.f_81455_).m_81405_();

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public boolean canPerformOn(Player player, WorkbenchTile tile, ItemStack itemStack) {
        return this.requirement != null && this.requirement.m_45049_(itemStack);
    }

    @Override
    public Collection<ToolAction> getRequiredToolActions(ItemStack itemStack) {
        return this.requiredTools.getValues();
    }

    @Override
    public int getRequiredToolLevel(ItemStack itemStack, ToolAction toolAction) {
        return this.requiredTools.getLevel(toolAction);
    }

    @Override
    public Map<ToolAction, Integer> getRequiredTools(ItemStack itemStack) {
        return this.requiredTools.getLevelMap();
    }

    @Override
    public void perform(Player player, ItemStack targetStack, WorkbenchTile workbench) {
        if (player != null && !player.m_9236_().f_46443_) {
            ServerLevel world = (ServerLevel)player.m_9236_();
            LootTable table = world.m_7654_().m_278653_().m_278676_(this.lootTable);
            ItemStack toolStack = this.requiredTools.getLevelMap().entrySet().stream().min(Map.Entry.comparingByValue()).map(entry -> {
                ItemStack providingStack = PropertyHelper.getPlayerProvidingItemStack((ToolAction)entry.getKey(), (Integer)entry.getValue(), (Entity)player);
                if (providingStack.m_41619_()) {
                    providingStack = PropertyHelper.getToolbeltProvidingItemStack((ToolAction)entry.getKey(), (Integer)entry.getValue(), player);
                }
                return providingStack;
            }).orElse(ItemStack.f_41583_);
            LootParams context = new LootParams.Builder(world).m_287239_(player.m_36336_()).m_287286_(LootContextParams.f_81463_, (Object)toolStack).m_287286_(LootContextParams.f_81455_, (Object)player).m_287286_(LootContextParams.f_81460_, (Object)player.m_20182_()).m_287235_(lootParameters);
            table.m_287195_(context).forEach(itemStack -> {
                if (!player.m_150109_().m_36054_(itemStack)) {
                    player.m_36176_(itemStack, false);
                }
            });
            BlockPos pos = workbench.m_58899_();
            world.m_5594_(null, pos, SoundEvents.f_12442_, player.m_5720_(), 1.0f, 1.5f + (float)Math.random() * 0.5f);
            world.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, targetStack), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.1, (double)pos.m_123343_() + 0.5, 4, 0.0, 0.0, 0.0, (double)0.1f);
            CriteriaTriggers.f_10592_.m_23682_((ServerPlayer)player, targetStack);
            targetStack.m_41764_(targetStack.m_41613_() - 1);
            workbench.m_6596_();
        } else if (!workbench.m_58904_().f_46443_) {
            ServerLevel world = (ServerLevel)workbench.m_58904_();
            LootTable table = world.m_7654_().m_278653_().m_278676_(this.lootTable);
            LootParams context = new LootParams.Builder(world).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82514_((Vec3i)workbench.m_58899_(), (double)1.1f)).m_287235_(lootParameters);
            table.m_287195_(context).forEach(itemStack -> Block.m_49840_((Level)world, (BlockPos)workbench.m_58899_().m_7494_(), (ItemStack)itemStack));
            BlockPos pos = workbench.m_58899_();
            world.m_5594_(null, pos, SoundEvents.f_12442_, SoundSource.BLOCKS, 1.0f, 1.5f + (float)Math.random() * 0.5f);
            world.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, targetStack), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.1, (double)pos.m_123343_() + 0.5, 4, 0.0, 0.0, 0.0, (double)0.1f);
            targetStack.m_41764_(targetStack.m_41613_() - 1);
            workbench.m_6596_();
        }
    }

    @Override
    public boolean allowInWorldInteraction() {
        return this.inWorld;
    }
}

