/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.data.provider;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.registries.ForgeRegistries;
import se.mickelus.tetra.items.forged.MetalScrapItem;

public class MultiblockSchematicLootProvider
extends BlockLootSubProvider {
    protected MultiblockSchematicLootProvider(Set<Item> pExplosionResistant, FeatureFlagSet pEnabledFeatures) {
        super(pExplosionResistant, pEnabledFeatures);
    }

    public static List<LootTableProvider.SubProviderEntry> getLootTables() {
        return ImmutableList.of((Object)new LootTableProvider.SubProviderEntry(() -> MultiblockSchematicLootProvider.getMultiBlockSchematics("stonecutter", 3, 2, true), LootContextParamSets.f_81421_), (Object)new LootTableProvider.SubProviderEntry(() -> MultiblockSchematicLootProvider.getMultiBlockSchematics("earthpiercer", 2, 2, true), LootContextParamSets.f_81421_), (Object)new LootTableProvider.SubProviderEntry(() -> MultiblockSchematicLootProvider.getMultiBlockSchematics("extractor", 3, 3, true), LootContextParamSets.f_81421_));
    }

    private static LootTableSubProvider getMultiBlockSchematics(String identifier, int width, int height, boolean ruinable) {
        return consumer -> {
            for (int h = 0; h < width; ++h) {
                for (int v = 0; v < height; ++v) {
                    String id = String.format("%s_%d_%d", identifier, h, v);
                    consumer.accept(new ResourceLocation("tetra", "actions/forged_schematic/" + id), MultiblockSchematicLootProvider.getMultiBlockSchematicPryTable(id));
                    consumer.accept(new ResourceLocation("tetra", "blocks/" + id), MultiblockSchematicLootProvider.getMultiBlockSchematicDropTable(id));
                    if (!ruinable) continue;
                    id = String.format("%s_ruined_%d_%d", identifier, h, v);
                    consumer.accept(new ResourceLocation("tetra", "actions/forged_schematic/" + id), MultiblockSchematicLootProvider.getMultiBlockSchematicPryTable(id));
                    consumer.accept(new ResourceLocation("tetra", "blocks/" + id), MultiblockSchematicLootProvider.getMultiBlockSchematicDropTable(id));
                }
            }
        };
    }

    private static LootTable.Builder getMultiBlockSchematicPryTable(String identifier) {
        ResourceLocation rl = new ResourceLocation("tetra", identifier);
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ForgeRegistries.BLOCKS.getValue(rl)))));
    }

    private static LootTable.Builder getMultiBlockSchematicDropTable(String identifier) {
        ResourceLocation rl = new ResourceLocation("tetra", identifier);
        return MultiblockSchematicLootProvider.m_247502_((Block)((Block)ForgeRegistries.BLOCKS.getValue(rl)), (LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)MetalScrapItem.instance.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79939_((Enchantment)Enchantments.f_44987_)));
    }

    protected void m_245660_() {
    }
}

