/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect;

import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import se.mickelus.mutil.util.ParticleHelper;
import se.mickelus.tetra.effect.AbilityUseResult;
import se.mickelus.tetra.effect.ComboPoints;
import se.mickelus.tetra.effect.EchoHelper;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.effect.potion.PriedPotionEffect;
import se.mickelus.tetra.effect.potion.StunPotionEffect;
import se.mickelus.tetra.effect.revenge.RevengeTracker;
import se.mickelus.tetra.items.modular.ItemModularHandheld;

@ParametersAreNonnullByDefault
public class PryEffect {
    public static final double flatCooldown = 2.0;
    public static final double cooldownSpeedMultiplier = 3.0;
    public static final double damageMultiplier = 0.5;

    private static int getCooldown(ItemModularHandheld item, ItemStack itemStack) {
        float speedBonus = (float)(100 - item.getEffectLevel(itemStack, ItemEffect.abilitySpeed)) / 100.0f;
        return (int)((2.0 + item.getCooldownBase(itemStack) * 3.0) * (double)speedBonus * 20.0);
    }

    public static void perform(Player attacker, InteractionHand hand, ItemModularHandheld item, ItemStack itemStack, int effectLevel, LivingEntity target) {
        int revengeLevel;
        if (!attacker.m_9236_().f_46443_) {
            boolean isSatiated;
            int comboPoints = ComboPoints.get((Entity)attacker);
            boolean bl = isSatiated = !attacker.m_36324_().m_38721_();
            if (hand == InteractionHand.OFF_HAND && item.getEffectLevel(itemStack, ItemEffect.abilityDefensive) > 0) {
                PryEffect.performDefensive(attacker, item, itemStack, target);
            } else {
                PryEffect.performRegular(attacker, item, itemStack, 0.5, effectLevel, target, isSatiated, comboPoints);
            }
            target.m_20193_().m_5594_(attacker, target.m_20183_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 0.8f, 0.8f);
            boolean overextended = item.getEffectLevel(itemStack, ItemEffect.abilityOverextend) > 0;
            attacker.m_36399_(overextended ? 6.0f : 0.5f);
            attacker.m_36335_().m_41524_((Item)item, PryEffect.getCooldown(item, itemStack));
            int echoLevel = item.getEffectLevel(itemStack, ItemEffect.abilityEcho);
            if (echoLevel > 0) {
                PryEffect.performEcho(attacker, item, itemStack, 0.5, effectLevel, target, isSatiated, comboPoints);
            }
        }
        if (ComboPoints.canSpend(item, itemStack)) {
            ComboPoints.reset((Entity)attacker);
        }
        if ((revengeLevel = item.getEffectLevel(itemStack, ItemEffect.abilityRevenge)) > 0) {
            RevengeTracker.removeEnemy((Entity)attacker, (Entity)target);
        }
        attacker.m_21011_(hand, false);
        item.tickProgression((LivingEntity)attacker, itemStack, 2);
        item.applyDamage(2, itemStack, (LivingEntity)attacker);
    }

    public static AbilityUseResult performRegular(Player attacker, ItemModularHandheld item, ItemStack itemStack, double damageMultiplier, int amplifier, LivingEntity target, boolean isSatiated, int comboPoints) {
        AbilityUseResult result;
        int amp;
        int exhilarationLevel;
        int revengeLevel = item.getEffectLevel(itemStack, ItemEffect.abilityRevenge);
        int comboLevel = item.getEffectLevel(itemStack, ItemEffect.abilityCombo);
        if (comboLevel > 0) {
            damageMultiplier += (double)(comboLevel * comboPoints) / 100.0;
        }
        if (revengeLevel > 0 && RevengeTracker.canRevenge((Entity)attacker, (Entity)target)) {
            damageMultiplier += (double)revengeLevel / 100.0;
        }
        if ((exhilarationLevel = item.getEffectLevel(itemStack, ItemEffect.abilityExhilaration)) > 0 && (amp = Optional.ofNullable(target.m_21124_((MobEffect)PriedPotionEffect.instance)).map(MobEffectInstance::m_19564_).orElse(-1) + 1) > 0) {
            damageMultiplier += (double)(exhilarationLevel * amp) / 100.0;
        }
        if ((result = item.hitEntity(itemStack, attacker, target, damageMultiplier, 0.2f, 0.2f)) != AbilityUseResult.fail) {
            int momentumLevel;
            double overextendLevel;
            int currentAmplifier = Optional.ofNullable(target.m_21124_((MobEffect)PriedPotionEffect.instance)).map(MobEffectInstance::m_19564_).orElse(-1);
            double comboEfficiency = item.getEffectEfficiency(itemStack, ItemEffect.abilityCombo);
            if (comboEfficiency > 0.0 && (double)attacker.m_20193_().m_213780_().m_188501_() < comboEfficiency * (double)comboPoints / 100.0) {
                ++amplifier;
                if (!target.m_20193_().f_46443_) {
                    RandomSource rand = target.m_20193_().m_213780_();
                    ((ServerLevel)target.m_20193_()).m_8767_((ParticleOptions)ParticleTypes.f_123797_, target.m_20185_(), target.m_20186_() + (double)(target.m_20206_() / 2.0f), target.m_20189_(), 10, rand.m_188583_() * 0.3, rand.m_188583_() * (double)target.m_20206_() * 0.8, rand.m_188583_() * 0.3, (double)0.1f);
                }
            }
            if (revengeLevel > 0 && RevengeTracker.canRevenge((Entity)attacker, (Entity)target)) {
                ++amplifier;
            }
            if ((overextendLevel = (double)item.getEffectLevel(itemStack, ItemEffect.abilityOverextend)) > 0.0 && isSatiated) {
                ++amplifier;
            }
            target.m_7292_(new MobEffectInstance((MobEffect)PriedPotionEffect.instance, (int)(item.getEffectEfficiency(itemStack, ItemEffect.pry) * 20.0f), currentAmplifier + amplifier, false, false));
            if (!target.m_20193_().f_46443_) {
                ParticleHelper.spawnArmorParticles((LivingEntity)target);
            }
            if ((momentumLevel = item.getEffectLevel(itemStack, ItemEffect.abilityMomentum)) > 0 && currentAmplifier > -1) {
                int duration = momentumLevel * (currentAmplifier + 1);
                target.m_7292_(new MobEffectInstance((MobEffect)StunPotionEffect.instance, duration, 0, false, false));
            }
        }
        return result;
    }

    public static AbilityUseResult performDefensive(Player attacker, ItemModularHandheld item, ItemStack itemStack, LivingEntity target) {
        AbilityUseResult result = item.hitEntity(itemStack, attacker, target, 0.5, 0.2f, 0.2f);
        if (result != AbilityUseResult.fail) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19613_, (int)(item.getEffectEfficiency(itemStack, ItemEffect.abilityDefensive) * 20.0f), item.getEffectLevel(itemStack, ItemEffect.abilityDefensive) - 1, false, true));
            if (!target.m_20193_().f_46443_) {
                if (target.m_21033_(EquipmentSlot.MAINHAND)) {
                    ParticleHelper.spawnArmorParticles((LivingEntity)target, (EquipmentSlot)EquipmentSlot.MAINHAND);
                } else if (target.m_21033_(EquipmentSlot.OFFHAND)) {
                    ParticleHelper.spawnArmorParticles((LivingEntity)target, (EquipmentSlot)EquipmentSlot.OFFHAND);
                }
            }
        }
        return result;
    }

    public static void performEcho(Player attacker, ItemModularHandheld item, ItemStack itemStack, double damageMultiplier, int amplifier, LivingEntity target, boolean isSatiated, int comboPoints) {
        EchoHelper.echo(attacker, 60, () -> {
            PryEffect.performRegular(attacker, item, itemStack, damageMultiplier, amplifier, target, isSatiated, comboPoints);
            int revengeLevel = item.getEffectLevel(itemStack, ItemEffect.abilityRevenge);
            if (revengeLevel > 0) {
                RevengeTracker.removeEnemy((Entity)attacker, (Entity)target);
            }
        });
    }
}

