/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect.data;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.effect.data.ItemEffectContext;
import se.mickelus.tetra.effect.data.ItemEffectTrigger;
import se.mickelus.tetra.effect.data.condition.ItemEffectCondition;
import se.mickelus.tetra.effect.data.outcome.ItemEffectOutcome;
import se.mickelus.tetra.effect.data.provider.entity.EntityProvider;
import se.mickelus.tetra.effect.data.provider.number.NumberProvider;
import se.mickelus.tetra.effect.data.provider.vector.VectorProvider;

public class ItemEffectData {
    public ItemEffect effect;
    Data data;
    public ItemEffectTrigger trigger;
    public ItemEffectCondition condition;
    public ItemEffectOutcome outcome;

    public static Map<String, Float> calculateNumbers(ItemEffectData effectData, ItemEffectContext context) {
        if (effectData.data != null && effectData.data.numbers != null) {
            return ItemEffectData.calculateNumbers(effectData.data.numbers, context);
        }
        return Collections.emptyMap();
    }

    public static Map<String, Float> calculateNumbers(Map<String, NumberProvider> data, ItemEffectContext context) {
        HashMap<String, Float> result = new HashMap<String, Float>();
        ItemEffectContext updatedContext = context;
        for (Map.Entry<String, NumberProvider> entry : data.entrySet()) {
            result.put(entry.getKey(), Float.valueOf(entry.getValue().getValue(updatedContext)));
            updatedContext = updatedContext.withNumbers(result);
        }
        return result;
    }

    public static Map<String, Vec3> calculateVectors(ItemEffectData effectData, ItemEffectContext context) {
        if (effectData.data != null && effectData.data.vectors != null) {
            return ItemEffectData.calculateVectors(effectData.data.vectors, context);
        }
        return Collections.emptyMap();
    }

    public static Map<String, Vec3> calculateVectors(Map<String, VectorProvider> data, ItemEffectContext context) {
        HashMap<String, Vec3> result = new HashMap<String, Vec3>();
        ItemEffectContext updatedContext = context;
        for (Map.Entry<String, VectorProvider> entry : data.entrySet()) {
            result.put(entry.getKey(), entry.getValue().getVector(updatedContext));
            updatedContext = updatedContext.withVectors(result);
        }
        return result;
    }

    public static Map<String, Entity> calculateEntities(ItemEffectData effectData, ItemEffectContext context) {
        if (effectData.data != null && effectData.data.entities != null) {
            return ItemEffectData.calculateEntities(effectData.data.entities, context);
        }
        return Collections.emptyMap();
    }

    public static Map<String, Entity> calculateEntities(Map<String, EntityProvider> data, ItemEffectContext context) {
        HashMap<String, Entity> result = new HashMap<String, Entity>();
        ItemEffectContext updatedContext = context;
        for (Map.Entry<String, EntityProvider> entry : data.entrySet()) {
            result.put(entry.getKey(), entry.getValue().getEntity(updatedContext));
            updatedContext = updatedContext.withEntities(result);
        }
        return result;
    }

    public record Data(Map<String, NumberProvider> numbers, Map<String, VectorProvider> vectors, Map<String, EntityProvider> entities) {
    }
}

