/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui.stats.data;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.GsonHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.mickelus.tetra.gui.stats.data.StatRegistry;
import se.mickelus.tetra.gui.stats.sorting.IStatSorter;

public class StatSorterStore
implements ResourceManagerReloadListener {
    private static final Logger logger = LogManager.getLogger();
    public static StatSorterStore instance;
    private IStatSorter[] sorters = new IStatSorter[0];

    public StatSorterStore() {
        ((ReloadableResourceManager)Minecraft.m_91087_().m_91098_()).m_7217_((PreparableReloadListener)this);
        instance = this;
    }

    public void m_6213_(ResourceManager resourceManager) {
        this.sorters = StatSorterStore.prepare();
    }

    private static IStatSorter[] prepare() {
        ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
        return (IStatSorter[])resourceManager.m_214159_("stat_sorters", rl -> rl.m_135815_().endsWith(".json")).entrySet().stream().filter(entry -> "tetra".equals(((ResourceLocation)entry.getKey()).m_135827_())).map(entry -> StatSorterStore.parseSorter((ResourceLocation)entry.getKey(), (Resource)entry.getValue())).filter(Objects::nonNull).toArray(IStatSorter[]::new);
    }

    @Nullable
    private static IStatSorter parseSorter(ResourceLocation resourceLocation, Resource resource) {
        IStatSorter iStatSorter;
        block8: {
            BufferedReader reader = resource.m_215508_();
            try {
                iStatSorter = (IStatSorter)GsonHelper.m_13776_((Gson)StatRegistry.gson, (Reader)reader, IStatSorter.class);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonParseException | IOException e) {
                    logger.error("Failed to parse stat sorter data from '{}': {}", (Object)resourceLocation, (Object)e);
                    return null;
                }
            }
            reader.close();
        }
        return iStatSorter;
    }

    public IStatSorter[] getSorters() {
        return this.sorters;
    }
}

