/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui.stats.getter;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import se.mickelus.tetra.gui.stats.getter.IStatFormat;
import se.mickelus.tetra.gui.stats.getter.IStatGetter;
import se.mickelus.tetra.gui.stats.getter.ITooltipGetter;

@ParametersAreNonnullByDefault
public class TooltipGetterMultiValue
implements ITooltipGetter {
    protected IStatGetter[] statGetter;
    protected IStatFormat[] formatters;
    protected String localizationKey;

    public TooltipGetterMultiValue(String localizationKey, IStatGetter[] statGetters, IStatFormat[] formatters) {
        this.localizationKey = localizationKey;
        this.statGetter = statGetters;
        this.formatters = formatters;
        if (statGetters.length != formatters.length) {
            throw new RuntimeException(String.format("Mismatching length of stat getters and formatters for '%s', gett: %d, form: %d", localizationKey, statGetters.length, formatters.length));
        }
    }

    @Override
    public String getTooltipBase(Player player, ItemStack itemStack) {
        Object[] values = new String[this.statGetter.length];
        for (int i = 0; i < this.statGetter.length; ++i) {
            values[i] = this.formatters[i].get(this.statGetter[i].getValue(player, itemStack));
        }
        return I18n.m_118938_((String)this.localizationKey, (Object[])values);
    }

    @Override
    public boolean hasExtendedTooltip(Player player, ItemStack itemStack) {
        return I18n.m_118936_((String)(this.localizationKey + "_extended"));
    }

    @Override
    public String getTooltipExtension(Player player, ItemStack itemStack) {
        return I18n.m_118938_((String)(this.localizationKey + "_extended"), (Object[])new Object[0]);
    }
}

