/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular;

import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import se.mickelus.mutil.network.BlockPosPacket;
import se.mickelus.tetra.items.modular.ItemModularHandheld;

@ParametersAreNonnullByDefault
public class ChargedAbilityPacket
extends BlockPosPacket {
    private int targetId = -1;
    private InteractionHand hand;
    private int ticksUsed;
    private Vec3 hitVec;

    public ChargedAbilityPacket() {
    }

    public ChargedAbilityPacket(LivingEntity target, BlockPos pos, Vec3 hitVec, InteractionHand hand, int ticksUsed) {
        super(pos == null ? BlockPos.f_121853_ : pos);
        this.targetId = Optional.ofNullable(target).map(Entity::m_19879_).orElse(-1);
        this.hand = hand;
        this.ticksUsed = ticksUsed;
        this.hitVec = hitVec == null ? Vec3.f_82478_ : hitVec;
    }

    public void toBytes(FriendlyByteBuf buffer) {
        super.toBytes(buffer);
        buffer.writeInt(this.targetId);
        buffer.writeInt(this.hand.ordinal());
        buffer.writeInt(this.ticksUsed);
        buffer.writeDouble(this.hitVec.f_82479_);
        buffer.writeDouble(this.hitVec.f_82480_);
        buffer.writeDouble(this.hitVec.f_82481_);
    }

    public void fromBytes(FriendlyByteBuf buffer) {
        super.fromBytes(buffer);
        this.targetId = buffer.readInt();
        this.hand = InteractionHand.values()[buffer.readInt()];
        this.ticksUsed = buffer.readInt();
        double x = buffer.readDouble();
        double y = buffer.readDouble();
        double z = buffer.readDouble();
        this.hitVec = new Vec3(x, y, z);
    }

    public void handle(Player player) {
        LivingEntity target = Optional.of(this.targetId).filter(id -> id != -1).map(id -> player.m_9236_().m_6815_(id.intValue())).filter(entity -> entity instanceof LivingEntity).map(entity -> (LivingEntity)entity).orElse(null);
        ItemModularHandheld.handleChargedAbility(player, this.hand, target, BlockPos.f_121853_.equals((Object)this.pos) ? null : this.pos, Vec3.f_82478_.equals((Object)this.hitVec) ? null : this.hitVec, this.ticksUsed);
    }
}

