/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.holo.gui;

import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.mickelus.mutil.gui.GuiElement;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.gui.GuiSpinner;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.items.modular.impl.holo.HoloPage;
import se.mickelus.tetra.items.modular.impl.holo.gui.HoloHeaderGui;
import se.mickelus.tetra.items.modular.impl.holo.gui.HoloRootBaseGui;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloCraftRootGui;
import se.mickelus.tetra.items.modular.impl.holo.gui.scan.HoloScanRootGui;
import se.mickelus.tetra.items.modular.impl.holo.gui.system.HoloSystemRootGui;
import se.mickelus.tetra.module.schematic.UpgradeSchematic;

@ParametersAreNonnullByDefault
@OnlyIn(value=Dist.CLIENT)
public class HoloGui
extends Screen {
    private static final Logger logger = LogManager.getLogger();
    private static HoloGui instance = null;
    private static boolean hasListener = false;
    private final HoloHeaderGui header;
    private final HoloRootBaseGui[] pages;
    private final GuiElement defaultGui;
    private final GuiElement spinner;
    private HoloRootBaseGui currentPage;
    private Runnable closeCallback;

    public HoloGui() {
        super((Component)Component.m_237113_((String)"tetra:holosphere"));
        this.f_96543_ = 320;
        this.f_96544_ = 240;
        this.defaultGui = new GuiElement(0, 0, this.f_96543_, this.f_96544_);
        this.header = new HoloHeaderGui(0, 0, this.f_96543_, this::changePage);
        this.defaultGui.addChild((GuiElement)this.header);
        this.pages = new HoloRootBaseGui[HoloPage.values().length];
        this.pages[0] = new HoloCraftRootGui(0, 18);
        this.defaultGui.addChild((GuiElement)this.pages[0]);
        this.pages[1] = new HoloScanRootGui(0, 18);
        this.pages[1].setVisible(false);
        this.defaultGui.addChild((GuiElement)this.pages[1]);
        this.pages[2] = new HoloSystemRootGui(0, 18);
        this.pages[2].setVisible(false);
        this.defaultGui.addChild((GuiElement)this.pages[2]);
        this.currentPage = this.pages[0];
        this.spinner = new GuiSpinner(-8, 6);
        this.spinner.setVisible(false);
        this.defaultGui.addChild(this.spinner);
        if (((Boolean)ConfigHandler.development.get()).booleanValue() && !hasListener) {
            DataManager.instance.destabilizationData.onReload(() -> Minecraft.m_91087_().m_18709_(HoloGui::onReload));
            hasListener = true;
        }
    }

    public static HoloGui getInstance() {
        if (instance == null) {
            instance = new HoloGui();
        }
        return instance;
    }

    private static void onReload() {
        if (instance != null && HoloGui.instance.getMinecraft().f_91080_ == instance) {
            logger.info("Refreshing holosphere gui data");
            HoloGui.instance.spinner.setVisible(false);
            if (HoloGui.instance.currentPage != null) {
                HoloGui.instance.currentPage.onReload();
            }
        }
    }

    public void openSchematic(IModularItem item, ItemStack itemStack, String slot, UpgradeSchematic schematic, Runnable closeCallback) {
        this.changePage(HoloPage.craft);
        ((HoloCraftRootGui)this.pages[0]).updateState(item, itemStack, slot, schematic);
        this.closeCallback = closeCallback;
    }

    public void m_7861_() {
        super.m_7861_();
        if (this.closeCallback != null) {
            Runnable callback = this.closeCallback;
            this.closeCallback = null;
            callback.run();
        }
    }

    public void onShow() {
        this.header.onShow();
        this.currentPage.animateOpen();
    }

    private void changePage(HoloPage page) {
        this.header.changePage(page);
        for (int i = 0; i < this.pages.length; ++i) {
            this.pages[i].setVisible(page.ordinal() == i);
        }
        this.currentPage = this.pages[page.ordinal()];
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.defaultGui.updateFocusState((this.f_96543_ - this.defaultGui.getWidth()) / 2, (this.f_96544_ - this.defaultGui.getHeight()) / 2, mouseX, mouseY);
        this.defaultGui.draw(graphics, (this.f_96543_ - this.defaultGui.getWidth()) / 2, (this.f_96544_ - this.defaultGui.getHeight()) / 2, this.f_96543_, this.f_96544_, mouseX, mouseY, 1.0f);
        this.renderHoveredToolTip(graphics, mouseX, mouseY);
    }

    protected void renderHoveredToolTip(GuiGraphics graphics, int mouseX, int mouseY) {
        List tooltipLines = this.defaultGui.getTooltipLines();
        if (tooltipLines != null) {
            graphics.m_280677_(this.f_96547_, tooltipLines, Optional.empty(), mouseX, mouseY);
        }
    }

    public boolean m_6375_(double x, double y, int button) {
        if (this.defaultGui.onMouseClick((int)x, (int)y, button)) {
            return true;
        }
        return super.m_6375_(x, y, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double distance) {
        if (this.currentPage.onMouseScroll(mouseX, mouseY, distance)) {
            return true;
        }
        return super.m_6050_(mouseX, mouseY, distance);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.currentPage.onKeyPress(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (this.currentPage.onKeyRelease(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char typedChar, int keyCode) {
        if (this.currentPage.onCharType(typedChar, keyCode)) {
            return true;
        }
        if (((Boolean)ConfigHandler.development.get()).booleanValue()) {
            switch (typedChar) {
                case 'r': {
                    instance = null;
                    Minecraft.m_91087_().m_91152_(null);
                    HoloGui gui = HoloGui.getInstance();
                    Minecraft.m_91087_().m_91152_((Screen)gui);
                    gui.onShow();
                    break;
                }
                case 't': {
                    this.getMinecraft().f_91074_.f_108617_.m_246979_("reload");
                    this.spinner.setVisible(true);
                }
            }
        }
        return false;
    }
}

