/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.levelgen;

import com.mojang.serialization.Codec;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.registries.RegistryObject;
import se.mickelus.tetra.blocks.forged.transfer.EnumTransferConfig;
import se.mickelus.tetra.blocks.forged.transfer.TransferUnitBlock;
import se.mickelus.tetra.blocks.forged.transfer.TransferUnitBlockEntity;
import se.mickelus.tetra.items.cell.ThermalCellItem;

@ParametersAreNonnullByDefault
public class TransferUnitProcessor
extends StructureProcessor {
    public static final TransferUnitProcessor INSTANCE = new TransferUnitProcessor();
    public static final Codec<TransferUnitProcessor> codec = Codec.unit(() -> INSTANCE);
    public static RegistryObject<StructureProcessorType<?>> type;

    @Nullable
    public StructureTemplate.StructureBlockInfo process(LevelReader world, BlockPos pos, BlockPos pos2, StructureTemplate.StructureBlockInfo $, StructureTemplate.StructureBlockInfo blockInfo, StructurePlaceSettings placementSettings, @Nullable StructureTemplate template) {
        if (blockInfo.f_74676_().m_60734_() instanceof TransferUnitBlock) {
            RandomSource random = placementSettings.m_230326_(blockInfo.f_74675_());
            CompoundTag newCompound = blockInfo.f_74677_().m_6426_();
            int cellState = 0;
            if ((double)random.m_188501_() < 0.1) {
                int charge = random.m_188503_(128);
                ItemStack itemStack = new ItemStack((ItemLike)ThermalCellItem.instance.get());
                ThermalCellItem.recharge(itemStack, charge);
                cellState = charge > 0 ? 2 : 1;
                TransferUnitBlockEntity.writeCell(newCompound, itemStack);
            } else if ((double)random.m_188501_() < 0.2) {
                TransferUnitBlockEntity.writeCell(newCompound, new ItemStack((ItemLike)ThermalCellItem.instance.get()));
                cellState = 1;
            }
            EnumTransferConfig[] configs = EnumTransferConfig.values();
            BlockState newState = (BlockState)((BlockState)((BlockState)blockInfo.f_74676_().m_61124_((Property)TransferUnitBlock.cellProp, (Comparable)Integer.valueOf(cellState))).m_61124_(TransferUnitBlock.configProp, (Comparable)((Object)configs[random.m_188503_(configs.length)]))).m_61124_((Property)TransferUnitBlock.plateProp, (Comparable)Boolean.valueOf(random.m_188499_()));
            return new StructureTemplate.StructureBlockInfo(blockInfo.f_74675_(), newState, newCompound);
        }
        return blockInfo;
    }

    protected StructureProcessorType<?> m_6953_() {
        return (StructureProcessorType)type.get();
    }
}

