/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.module.ItemModule;
import se.mickelus.tetra.module.ModuleRegistry;
import se.mickelus.tetra.module.ReplacementDefinition;

@ParametersAreNonnullByDefault
public class ItemUpgradeRegistry {
    private static final Logger logger = LogManager.getLogger();
    public static ItemUpgradeRegistry instance;
    private final List<BiFunction<ItemStack, ItemStack, ItemStack>> replacementHooks;
    private List<ReplacementDefinition> replacementDefinitions;

    public ItemUpgradeRegistry() {
        instance = this;
        this.replacementHooks = new ArrayList<BiFunction<ItemStack, ItemStack, ItemStack>>();
        this.replacementDefinitions = Collections.emptyList();
        DataManager.instance.replacementData.onReload(() -> {
            this.replacementDefinitions = DataManager.instance.replacementData.getData().values().stream().flatMap(Arrays::stream).filter(replacementDefinition -> replacementDefinition.predicate != null).collect(Collectors.toList());
        });
    }

    public void registerReplacementHook(BiFunction<ItemStack, ItemStack, ItemStack> hook) {
        this.replacementHooks.add(hook);
    }

    public ItemStack getReplacement(ItemStack itemStack) {
        for (ReplacementDefinition replacementDefinition : this.replacementDefinitions) {
            if (!replacementDefinition.predicate.m_45049_(itemStack)) continue;
            ItemStack replacementStack = replacementDefinition.itemStack.m_41777_();
            replacementStack.m_41721_(itemStack.m_41773_());
            for (BiFunction<ItemStack, ItemStack, ItemStack> hook : this.replacementHooks) {
                replacementStack = hook.apply(itemStack, replacementStack);
            }
            return replacementStack;
        }
        return ItemStack.f_41583_;
    }

    public ItemModule getModule(String key) {
        return ModuleRegistry.instance.getModule(new ResourceLocation("tetra", key));
    }

    public Collection<ItemModule> getAllModules() {
        return ModuleRegistry.instance.getAllModules();
    }
}

