/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.creator;

import java.util.function.BiFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.creator.BlockGuiCreator;
import team.creative.creativecore.common.gui.creator.ItemGuiCreator;
import team.creative.creativecore.common.gui.integration.GuiScreenIntegration;
import team.creative.creativecore.common.gui.packet.OpenGuiPacket;
import team.creative.creativecore.common.util.registry.NamedHandlerRegistry;

public abstract class GuiCreator {
    public static final NamedHandlerRegistry<GuiCreator> REGISTRY = new NamedHandlerRegistry<Object>(null);
    public static final GuiCreatorItem ITEM_OPENER = GuiCreator.register("item", new GuiCreatorItem());
    public static final GuiCreatorBlock BLOCK_OPENER = GuiCreator.register("block", new GuiCreatorBlock());
    String name;
    public final BiFunction<CompoundTag, Player, GuiLayer> function;

    public static <T extends GuiCreator> T register(String name, T creator) {
        creator.name = name;
        REGISTRY.register(name, creator);
        return creator;
    }

    public GuiCreator(BiFunction<CompoundTag, Player, GuiLayer> function) {
        this.function = function;
    }

    public String getName() {
        return this.name;
    }

    protected void openGui(CompoundTag nbt, Player player) {
        if (player.m_9236_().f_46443_) {
            CreativeCore.NETWORK.sendToServer(new OpenGuiPacket(this.name, nbt));
        } else {
            OpenGuiPacket.openGuiOnServer(this, nbt, (ServerPlayer)player);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void openClientSide(GuiLayer layer) {
        Minecraft.m_91087_().m_91346_((Screen)new GuiScreenIntegration(layer));
    }

    public static class GuiCreatorItem
    extends GuiCreator {
        public GuiCreatorItem() {
            super((nbt, player) -> {
                InteractionHand hand = nbt.m_128471_("main_hand") ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
                ItemStack stack = player.m_21120_(hand);
                Item patt3168$temp = stack.m_41720_();
                if (patt3168$temp instanceof ItemGuiCreator) {
                    ItemGuiCreator item = (ItemGuiCreator)patt3168$temp;
                    return item.create((CompoundTag)nbt, (Player)player);
                }
                return null;
            });
        }

        public void open(Player player, InteractionHand hand) {
            this.open(new CompoundTag(), player, hand);
        }

        public void open(CompoundTag nbt, Player player, InteractionHand hand) {
            nbt.m_128379_("main_hand", hand == InteractionHand.MAIN_HAND);
            this.openGui(nbt, player);
        }
    }

    public static class GuiCreatorBlock
    extends GuiCreator {
        public GuiCreatorBlock() {
            super((nbt, player) -> {
                BlockPos pos = new BlockPos(nbt.m_128451_("x"), nbt.m_128451_("y"), nbt.m_128451_("z"));
                Level level = player.m_9236_();
                BlockState state = level.m_8055_(pos);
                Block patt4068$temp = state.m_60734_();
                if (patt4068$temp instanceof BlockGuiCreator) {
                    BlockGuiCreator block = (BlockGuiCreator)patt4068$temp;
                    return block.create((CompoundTag)nbt, level, pos, state, (Player)player);
                }
                return null;
            });
        }

        public void open(Player player, BlockPos pos) {
            this.open(new CompoundTag(), player, pos);
        }

        public void open(CompoundTag nbt, Player player, BlockPos pos) {
            nbt.m_128405_("x", pos.m_123341_());
            nbt.m_128405_("y", pos.m_123342_());
            nbt.m_128405_("z", pos.m_123343_());
            this.openGui(nbt, player);
        }
    }

    public static class GuiCreatorBasic
    extends GuiCreator {
        public GuiCreatorBasic(BiFunction<CompoundTag, Player, GuiLayer> function) {
            super(function);
        }

        public void open(Player player) {
            this.openGui(new CompoundTag(), player);
        }

        public void open(CompoundTag nbt, Player player) {
            this.openGui(nbt, player);
        }
    }
}

