/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.api.utils;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ+\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J1\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u0012J\u0019\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0014\u0010\u0015R\"\u0010\u0017\u001a\u00020\u00168\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001e\u001a\u00020\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u001a\u0010\"\u001a\u00020\u00168FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b!\u0010\u0003\u001a\u0004\b \u0010\u001aR \u0010$\u001a\u00020#8\u0006X\u0087\u0004\u00a2\u0006\u0012\n\u0004\b$\u0010%\u0012\u0004\b(\u0010\u0003\u001a\u0004\b&\u0010'\u00a8\u0006)"}, d2={"Lgg/essential/api/utils/Multithreading;", "", "<init>", "()V", "Ljava/lang/Runnable;", "runnable", "", "runAsync", "(Ljava/lang/Runnable;)V", "r", "", "delay", "Ljava/util/concurrent/TimeUnit;", "unit", "Ljava/util/concurrent/ScheduledFuture;", "schedule", "(Ljava/lang/Runnable;JLjava/util/concurrent/TimeUnit;)Ljava/util/concurrent/ScheduledFuture;", "initialDelay", "(Ljava/lang/Runnable;JJLjava/util/concurrent/TimeUnit;)Ljava/util/concurrent/ScheduledFuture;", "Ljava/util/concurrent/Future;", "submit", "(Ljava/lang/Runnable;)Ljava/util/concurrent/Future;", "Ljava/util/concurrent/ThreadPoolExecutor;", "POOL", "Ljava/util/concurrent/ThreadPoolExecutor;", "getPOOL", "()Ljava/util/concurrent/ThreadPoolExecutor;", "setPOOL", "(Ljava/util/concurrent/ThreadPoolExecutor;)V", "Ljava/util/concurrent/atomic/AtomicInteger;", "counter", "Ljava/util/concurrent/atomic/AtomicInteger;", "getPool", "getPool$annotations", "pool", "Ljava/util/concurrent/ScheduledExecutorService;", "scheduledPool", "Ljava/util/concurrent/ScheduledExecutorService;", "getScheduledPool", "()Ljava/util/concurrent/ScheduledExecutorService;", "getScheduledPool$annotations", "essential-api"})
public final class Multithreading {
    @NotNull
    public static final Multithreading INSTANCE = new Multithreading();
    @NotNull
    private static final AtomicInteger counter = new AtomicInteger(0);
    @NotNull
    private static final ScheduledExecutorService scheduledPool;
    @NotNull
    private static ThreadPoolExecutor POOL;

    private Multithreading() {
    }

    @NotNull
    public static final ScheduledExecutorService getScheduledPool() {
        return scheduledPool;
    }

    @JvmStatic
    public static /* synthetic */ void getScheduledPool$annotations() {
    }

    @NotNull
    public static final ThreadPoolExecutor getPool() {
        return POOL;
    }

    @JvmStatic
    public static /* synthetic */ void getPool$annotations() {
    }

    @NotNull
    public final ThreadPoolExecutor getPOOL() {
        return POOL;
    }

    public final void setPOOL(@NotNull ThreadPoolExecutor threadPoolExecutor) {
        Intrinsics.checkNotNullParameter((Object)threadPoolExecutor, (String)"<set-?>");
        POOL = threadPoolExecutor;
    }

    @NotNull
    public final ScheduledFuture<?> schedule(@NotNull Runnable r, long initialDelay, long delay2, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        ScheduledFuture<?> scheduledFuture = scheduledPool.scheduleAtFixedRate(r, initialDelay, delay2, unit);
        Intrinsics.checkNotNullExpressionValue(scheduledFuture, (String)"scheduleAtFixedRate(...)");
        return scheduledFuture;
    }

    @JvmStatic
    @NotNull
    public static final ScheduledFuture<?> schedule(@NotNull Runnable r, long delay2, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        ScheduledFuture<?> scheduledFuture = scheduledPool.schedule(r, delay2, unit);
        Intrinsics.checkNotNullExpressionValue(scheduledFuture, (String)"schedule(...)");
        return scheduledFuture;
    }

    @JvmStatic
    public static final void runAsync(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        POOL.execute(runnable);
    }

    @NotNull
    public final Future<?> submit(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        Future<?> future2 = POOL.submit(runnable);
        Intrinsics.checkNotNullExpressionValue(future2, (String)"submit(...)");
        return future2;
    }

    private static final Thread scheduledPool$lambda$0(Runnable target2) {
        return new Thread(target2, "Thread " + counter.incrementAndGet());
    }

    private static final Thread POOL$lambda$1(Runnable target2) {
        return new Thread(target2, "Thread " + counter.incrementAndGet());
    }

    static {
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(10, Multithreading::scheduledPool$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"newScheduledThreadPool(...)");
        scheduledPool = scheduledExecutorService;
        POOL = new ThreadPoolExecutor(10, 30, 0L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)new LinkedBlockingQueue(), Multithreading::POOL$lambda$1);
    }
}

