/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.cosmetics;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import gg.essential.api.cosmetics.RenderCosmetic;
import gg.essential.cosmetics.ArmorSlots;
import gg.essential.cosmetics.CosmeticsState;
import gg.essential.cosmetics.EquippedCosmetic;
import gg.essential.cosmetics.WearablesManager;
import gg.essential.event.entity.PlayerTickEvent;
import gg.essential.gui.common.EmulatedUI3DPlayer;
import gg.essential.gui.elementa.state.v2.State;
import gg.essential.lib.kbrewster.eventbus.Subscribe;
import gg.essential.mixins.impl.client.entity.AbstractClientPlayerExt;
import gg.essential.mixins.impl.client.renderer.entity.ArmorRenderingUtil;
import gg.essential.mod.Model;
import gg.essential.mod.cosmetics.CosmeticSlot;
import gg.essential.mod.cosmetics.CosmeticType;
import gg.essential.model.BedrockModel;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.cosmetics.AssetLoader;
import gg.essential.network.connectionmanager.cosmetics.CosmeticsManager;
import gg.essential.network.connectionmanager.cosmetics.ModelLoader;
import gg.essential.network.connectionmanager.telemetry.ImpressionTelemetryManager;
import gg.essential.network.cosmetics.Cosmetic;
import gg.essential.util.UIdentifier;
import gg.essential.util.UIdentifierKt;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Pair;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class PlayerWearableManager {
    private final ConnectionManager connectionManager;
    private final CosmeticsManager cosmeticsManager;
    private final ModelLoader modelLoader;

    public PlayerWearableManager(ConnectionManager connectionManager, CosmeticsManager cosmeticsManager) {
        this.connectionManager = connectionManager;
        this.cosmeticsManager = cosmeticsManager;
        this.modelLoader = cosmeticsManager.getModelLoader();
    }

    @Subscribe
    public void tick(PlayerTickEvent tickEvent) {
        if (!tickEvent.isPre()) {
            return;
        }
        Player playerEntity = tickEvent.getPlayer();
        if (!(playerEntity instanceof AbstractClientPlayer)) {
            return;
        }
        AbstractClientPlayer player2 = (AbstractClientPlayer)playerEntity;
        this.updateCosmetics(player2);
    }

    private void updateCosmetics(AbstractClientPlayer player2) {
        AbstractClientPlayerExt playerExt = (AbstractClientPlayerExt)player2;
        State<Map<CosmeticSlot, EquippedCosmetic>> cosmeticsSource = playerExt.getCosmeticsSource();
        CosmeticsState oldState = playerExt.getCosmeticsState();
        Model newSkinType = Model.byTypeOrDefault(player2.m_108564_());
        Model oldSkinType = oldState.getSkinType();
        Map<CosmeticSlot, EquippedCosmetic> newCosmetics = cosmeticsSource.getUntracked();
        Map<CosmeticSlot, EquippedCosmetic> oldCosmetics = oldState.getCosmetics();
        ArmorSlots newArmour = this.getArmourFromPlayer(player2);
        ArmorSlots oldArmour = oldState.getArmor();
        if (Objects.equals(newCosmetics, oldCosmetics) && Objects.equals((Object)newSkinType, (Object)oldSkinType) && Objects.equals(oldArmour, newArmour)) {
            return;
        }
        AssetLoader.Priority priority = player2 instanceof EmulatedUI3DPlayer.EmulatedPlayer ? AssetLoader.Priority.High : AssetLoader.Priority.Low;
        HashMap<Cosmetic, BedrockModel> models = new HashMap<Cosmetic, BedrockModel>();
        String cape = null;
        Pair<List<UIdentifier>, List<UIdentifier>> capeTextures = null;
        boolean allUpdated = true;
        for (EquippedCosmetic equippedCosmetic : newCosmetics.values()) {
            CompletableFuture<BedrockModel> modelFuture2;
            Cosmetic cosmetic2 = equippedCosmetic.getCosmetic();
            String variant = equippedCosmetic.getVariant();
            CosmeticType cosmeticType = cosmetic2.getType();
            if (cosmeticType.getSlot() == CosmeticSlot.CAPE) {
                CompletionStage<Object> capeFuture;
                cape = cosmetic2.getId();
                if ("CAPE_DISABLED".equals(cape)) continue;
                if (cape.length() == 64) {
                    MinecraftProfileTexture texture = new MinecraftProfileTexture(String.format(Locale.ROOT, "http://textures.minecraft.net/texture/%s", cape), Collections.emptyMap());
                    SkinManager skinProvider = Minecraft.m_91087_().m_91109_();
                    capeFuture = CompletableFuture.completedFuture(skinProvider.m_118825_(texture, MinecraftProfileTexture.Type.CAPE)).thenApply(it -> new Pair(Collections.singletonList(UIdentifierKt.toU(it)), null));
                } else {
                    capeFuture = this.modelLoader.getCape(cosmetic2, variant, priority);
                }
                if (!capeFuture.isDone()) {
                    allUpdated = false;
                    continue;
                }
                if (capeFuture.isCompletedExceptionally()) continue;
                capeTextures = capeFuture.join();
            }
            if (!(modelFuture2 = this.modelLoader.getModel(cosmetic2, variant, newSkinType, priority)).isDone()) {
                allUpdated = false;
                continue;
            }
            if (modelFuture2.isCompletedExceptionally()) continue;
            models.put(cosmetic2, modelFuture2.join());
        }
        if (!allUpdated) {
            return;
        }
        WearablesManager wearablesManager2 = playerExt.getWearablesManager();
        CosmeticsState newState = new CosmeticsState(newSkinType, newCosmetics, models, newArmour);
        wearablesManager2.updateState(newState);
        playerExt.setEssentialCosmeticsCape(cape, capeTextures);
        if (!(player2 instanceof EmulatedUI3DPlayer.EmulatedPlayer)) {
            for (EquippedCosmetic cosmetic3 : newCosmetics.values()) {
                ImpressionTelemetryManager.INSTANCE.addImpression(cosmetic3.getId(), player2.m_20148_());
            }
        }
    }

    private ArmorSlots getArmourFromPlayer(AbstractClientPlayer player2) {
        int armorSetting = ArmorRenderingUtil.getCosmeticArmorSetting((Entity)player2);
        if (armorSetting > 0) {
            return new ArmorSlots(0);
        }
        return new ArmorSlots(!this.canRenderCosmetic(player2, 0), !this.canRenderCosmetic(player2, 1), !this.canRenderCosmetic(player2, 2), !this.canRenderCosmetic(player2, 3));
    }

    private boolean canRenderCosmetic(AbstractClientPlayer player2, int slot) {
        Inventory inventory = player2.m_150109_();
        ItemStack stack = inventory.m_36052_(slot);
        if (this.isEmpty(stack)) {
            return true;
        }
        if (stack.m_41720_() instanceof RenderCosmetic) {
            return true;
        }
        boolean[] armorRenderingSuppressed = ((AbstractClientPlayerExt)player2).wasArmorRenderingSuppressed();
        return armorRenderingSuppressed[slot];
    }

    private boolean isEmpty(ItemStack stack) {
        return stack.m_41619_();
    }
}

