/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.data;

import gg.essential.Essential;
import gg.essential.data.SPSData;
import gg.essential.network.connectionmanager.sps.SPSManager;
import gg.essential.util.ExtensionsKt;
import gg.essential.util.USession;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraft.world.level.storage.ServerLevelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001d\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lgg/essential/data/SPSData;", "", "<init>", "()V", "Ljava/nio/file/Path;", "worldFile", "Lnet/minecraft/world/level/storage/LevelSummary;", "worldSummary", "Lnet/minecraft/world/level/storage/ServerLevelData;", "worldInfo", "Lgg/essential/data/SPSData$SPSSettings;", "getSPSSettings", "(Ljava/nio/file/Path;Lnet/minecraft/world/level/storage/LevelSummary;Lnet/minecraft/world/level/storage/ServerLevelData;)Lgg/essential/data/SPSData$SPSSettings;", "settings", "", "saveSPSSettings", "(Lgg/essential/data/SPSData$SPSSettings;Ljava/nio/file/Path;)V", "SPSSettings", "Essential 1.20.1-forge"})
@SourceDebugExtension(value={"SMAP\nSPSData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SPSData.kt\ngg/essential/data/SPSData\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,103:1\n766#2:104\n857#2,2:105\n*S KotlinDebug\n*F\n+ 1 SPSData.kt\ngg/essential/data/SPSData\n*L\n62#1:104\n62#1:105,2\n*E\n"})
public final class SPSData {
    @NotNull
    public static final SPSData INSTANCE = new SPSData();

    private SPSData() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SPSSettings getSPSSettings(@NotNull Path worldFile, @Nullable LevelSummary worldSummary, @Nullable ServerLevelData worldInfo) {
        boolean bl;
        ServerLevelData serverLevelData;
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)worldFile, (String)"worldFile");
        LevelSummary levelSummary = worldSummary;
        if (levelSummary == null && (levelSummary = worldInfo) == null) {
            throw new IllegalArgumentException("getSPSSettings must be called with either worldSummary or worldInfo; they cannot both be null.");
        }
        Object object = worldSummary;
        if (object != null && (object = (Boolean)ExtensionsKt.getLevelNbtValue((LevelSummary)object, getSPSSettings.difficultyLocked.1.INSTANCE)) != null) {
            bl2 = (Boolean)object;
        } else {
            ServerLevelData serverLevelData2 = worldInfo;
            bl2 = serverLevelData2 != null ? serverLevelData2.m_5474_() : false;
        }
        boolean difficultyLocked2 = bl2;
        Path path = worldFile.resolve("spsSettings.json");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path file = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            try {
                void $this$filterTo$iv$iv;
                SPSSettings deserialized = Essential.GSON.fromJson(PathsKt.readText$default((Path)file, null, (int)1, null), SPSSettings.class);
                UUID localUuid = USession.Companion.activeNow().getUuid();
                Iterable $this$filter$iv = deserialized.getInvited();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    UUID it = (UUID)element$iv$iv;
                    boolean bl3 = false;
                    if (!(!Intrinsics.areEqual((Object)it, (Object)localUuid))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Set set2 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                Intrinsics.checkNotNull((Object)deserialized);
                return SPSSettings.copy$default(deserialized, null, null, difficultyLocked2, false, set2, false, null, 107, null);
            }
            catch (Exception exception) {
                Essential.logger.error("Failed to read SPS settings file.", (Throwable)exception);
            }
        }
        SPSManager sPSManager = Essential.getInstance().getConnectionManager().getSpsManager();
        Intrinsics.checkNotNullExpressionValue((Object)sPSManager, (String)"getSpsManager(...)");
        SPSManager spsManager = sPSManager;
        LevelSummary levelSummary2 = worldSummary;
        if (levelSummary2 == null || (levelSummary2 = levelSummary2.m_78367_()) == null) {
            ServerLevelData serverLevelData3 = worldInfo;
            Intrinsics.checkNotNull((Object)serverLevelData3);
            levelSummary2 = serverLevelData3.m_5464_();
        }
        LevelSummary levelSummary3 = levelSummary2;
        Intrinsics.checkNotNull((Object)levelSummary3);
        Object object2 = worldSummary;
        Difficulty difficulty2 = Difficulty.m_19029_((int)(object2 != null && (object2 = (Integer)ExtensionsKt.getLevelNbtValue((LevelSummary)object2, getSPSSettings.2.INSTANCE)) != null ? (Integer)object2 : ((serverLevelData = worldInfo) != null && (serverLevelData = serverLevelData.m_5472_()) != null ? serverLevelData.m_19028_() : Difficulty.NORMAL.m_19028_())));
        Intrinsics.checkNotNullExpressionValue((Object)difficulty2, (String)"byId(...)");
        LevelSummary levelSummary4 = worldSummary;
        if (levelSummary4 != null) {
            bl = levelSummary4.m_78369_();
        } else {
            ServerLevelData serverLevelData4 = worldInfo;
            Intrinsics.checkNotNull((Object)serverLevelData4);
            bl = serverLevelData4.m_5468_();
        }
        Set<UUID> set3 = spsManager.getInvitedUsers();
        Intrinsics.checkNotNullExpressionValue(set3, (String)"getInvitedUsers(...)");
        boolean bl4 = spsManager.isShareResourcePack();
        Set<UUID> set4 = spsManager.getOppedPlayers();
        Intrinsics.checkNotNullExpressionValue(set4, (String)"getOppedPlayers(...)");
        return new SPSSettings((GameType)levelSummary3, difficulty2, difficultyLocked2, bl, set3, bl4, set4);
    }

    public static /* synthetic */ SPSSettings getSPSSettings$default(SPSData sPSData, Path path, LevelSummary levelSummary, ServerLevelData serverLevelData, int n, Object object) {
        if ((n & 2) != 0) {
            levelSummary = null;
        }
        if ((n & 4) != 0) {
            serverLevelData = null;
        }
        return sPSData.getSPSSettings(path, levelSummary, serverLevelData);
    }

    public final void saveSPSSettings(@NotNull SPSSettings settings2, @NotNull Path worldFile) {
        Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)worldFile, (String)"worldFile");
        Path path = worldFile.resolve("spsSettings.json");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path file = path;
        String string = Essential.GSON.toJson(settings2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        PathsKt.writeText$default((Path)file, (CharSequence)string, null, (OpenOption[])new OpenOption[0], (int)2, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\b\u0086\b\u0018\u00002\u00020\u0001BY\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\b\b\u0002\u0010\f\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0016\u0010\u0015J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0019\u0010\u0015J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003\u00a2\u0006\u0004\b\u001a\u0010\u0018Jb\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00062\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\b\u0002\u0010\f\u001a\u00020\u00062\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0001\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001a\u0010\u001e\u001a\u00020\u00062\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0010\u0010!\u001a\u00020 H\u00d6\u0001\u00a2\u0006\u0004\b!\u0010\"J\u0010\u0010$\u001a\u00020#H\u00d6\u0001\u00a2\u0006\u0004\b$\u0010%R\u0017\u0010\b\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\b\u0010&\u001a\u0004\b'\u0010\u0015R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010(\u001a\u0004\b)\u0010\u0013R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010&\u001a\u0004\b*\u0010\u0015R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010+\u001a\u0004\b,\u0010\u0011R\u001d\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t8\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010-\u001a\u0004\b.\u0010\u0018R\u001d\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\t8\u0006\u00a2\u0006\f\n\u0004\b\r\u0010-\u001a\u0004\b/\u0010\u0018R\u0017\u0010\f\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\f\u0010&\u001a\u0004\b0\u0010\u0015\u00a8\u00061"}, d2={"Lgg/essential/data/SPSData$SPSSettings;", "", "Lnet/minecraft/world/level/GameType;", "gameType", "Lnet/minecraft/world/Difficulty;", "difficulty", "", "difficultyLocked", "cheats", "", "Ljava/util/UUID;", "invited", "shareResourcePack", "oppedPlayers", "<init>", "(Lnet/minecraft/world/level/GameType;Lnet/minecraft/world/Difficulty;ZZLjava/util/Set;ZLjava/util/Set;)V", "component1", "()Lnet/minecraft/world/level/GameType;", "component2", "()Lnet/minecraft/world/Difficulty;", "component3", "()Z", "component4", "component5", "()Ljava/util/Set;", "component6", "component7", "copy", "(Lnet/minecraft/world/level/GameType;Lnet/minecraft/world/Difficulty;ZZLjava/util/Set;ZLjava/util/Set;)Lgg/essential/data/SPSData$SPSSettings;", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Z", "getCheats", "Lnet/minecraft/world/Difficulty;", "getDifficulty", "getDifficultyLocked", "Lnet/minecraft/world/level/GameType;", "getGameType", "Ljava/util/Set;", "getInvited", "getOppedPlayers", "getShareResourcePack", "Essential 1.20.1-forge"})
    public static final class SPSSettings {
        @NotNull
        private final GameType gameType;
        @NotNull
        private final Difficulty difficulty;
        private final boolean difficultyLocked;
        private final boolean cheats;
        @NotNull
        private final Set<UUID> invited;
        private final boolean shareResourcePack;
        @NotNull
        private final Set<UUID> oppedPlayers;

        public SPSSettings(@NotNull GameType gameType, @NotNull Difficulty difficulty2, boolean difficultyLocked2, boolean cheats, @NotNull Set<UUID> invited, boolean shareResourcePack2, @NotNull Set<UUID> oppedPlayers) {
            Intrinsics.checkNotNullParameter((Object)gameType, (String)"gameType");
            Intrinsics.checkNotNullParameter((Object)difficulty2, (String)"difficulty");
            Intrinsics.checkNotNullParameter(invited, (String)"invited");
            Intrinsics.checkNotNullParameter(oppedPlayers, (String)"oppedPlayers");
            this.gameType = gameType;
            this.difficulty = difficulty2;
            this.difficultyLocked = difficultyLocked2;
            this.cheats = cheats;
            this.invited = invited;
            this.shareResourcePack = shareResourcePack2;
            this.oppedPlayers = oppedPlayers;
        }

        public /* synthetic */ SPSSettings(GameType gameType, Difficulty difficulty2, boolean bl, boolean bl2, Set set2, boolean bl3, Set set3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                gameType = GameType.ADVENTURE;
            }
            if ((n & 2) != 0) {
                difficulty2 = Difficulty.NORMAL;
            }
            if ((n & 4) != 0) {
                bl = false;
            }
            if ((n & 8) != 0) {
                bl2 = false;
            }
            if ((n & 0x10) != 0) {
                set2 = SetsKt.emptySet();
            }
            if ((n & 0x20) != 0) {
                bl3 = false;
            }
            if ((n & 0x40) != 0) {
                set3 = new LinkedHashSet();
            }
            this(gameType, difficulty2, bl, bl2, set2, bl3, set3);
        }

        @NotNull
        public final GameType getGameType() {
            return this.gameType;
        }

        @NotNull
        public final Difficulty getDifficulty() {
            return this.difficulty;
        }

        public final boolean getDifficultyLocked() {
            return this.difficultyLocked;
        }

        public final boolean getCheats() {
            return this.cheats;
        }

        @NotNull
        public final Set<UUID> getInvited() {
            return this.invited;
        }

        public final boolean getShareResourcePack() {
            return this.shareResourcePack;
        }

        @NotNull
        public final Set<UUID> getOppedPlayers() {
            return this.oppedPlayers;
        }

        @NotNull
        public final GameType component1() {
            return this.gameType;
        }

        @NotNull
        public final Difficulty component2() {
            return this.difficulty;
        }

        public final boolean component3() {
            return this.difficultyLocked;
        }

        public final boolean component4() {
            return this.cheats;
        }

        @NotNull
        public final Set<UUID> component5() {
            return this.invited;
        }

        public final boolean component6() {
            return this.shareResourcePack;
        }

        @NotNull
        public final Set<UUID> component7() {
            return this.oppedPlayers;
        }

        @NotNull
        public final SPSSettings copy(@NotNull GameType gameType, @NotNull Difficulty difficulty2, boolean difficultyLocked2, boolean cheats, @NotNull Set<UUID> invited, boolean shareResourcePack2, @NotNull Set<UUID> oppedPlayers) {
            Intrinsics.checkNotNullParameter((Object)gameType, (String)"gameType");
            Intrinsics.checkNotNullParameter((Object)difficulty2, (String)"difficulty");
            Intrinsics.checkNotNullParameter(invited, (String)"invited");
            Intrinsics.checkNotNullParameter(oppedPlayers, (String)"oppedPlayers");
            return new SPSSettings(gameType, difficulty2, difficultyLocked2, cheats, invited, shareResourcePack2, oppedPlayers);
        }

        public static /* synthetic */ SPSSettings copy$default(SPSSettings sPSSettings, GameType gameType, Difficulty difficulty2, boolean bl, boolean bl2, Set set2, boolean bl3, Set set3, int n, Object object) {
            if ((n & 1) != 0) {
                gameType = sPSSettings.gameType;
            }
            if ((n & 2) != 0) {
                difficulty2 = sPSSettings.difficulty;
            }
            if ((n & 4) != 0) {
                bl = sPSSettings.difficultyLocked;
            }
            if ((n & 8) != 0) {
                bl2 = sPSSettings.cheats;
            }
            if ((n & 0x10) != 0) {
                set2 = sPSSettings.invited;
            }
            if ((n & 0x20) != 0) {
                bl3 = sPSSettings.shareResourcePack;
            }
            if ((n & 0x40) != 0) {
                set3 = sPSSettings.oppedPlayers;
            }
            return sPSSettings.copy(gameType, difficulty2, bl, bl2, set2, bl3, set3);
        }

        @NotNull
        public String toString() {
            return "SPSSettings(gameType=" + this.gameType + ", difficulty=" + this.difficulty + ", difficultyLocked=" + this.difficultyLocked + ", cheats=" + this.cheats + ", invited=" + this.invited + ", shareResourcePack=" + this.shareResourcePack + ", oppedPlayers=" + this.oppedPlayers + ")";
        }

        public int hashCode() {
            int result = this.gameType.hashCode();
            result = result * 31 + this.difficulty.hashCode();
            result = result * 31 + Boolean.hashCode(this.difficultyLocked);
            result = result * 31 + Boolean.hashCode(this.cheats);
            result = result * 31 + ((Object)this.invited).hashCode();
            result = result * 31 + Boolean.hashCode(this.shareResourcePack);
            result = result * 31 + ((Object)this.oppedPlayers).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SPSSettings)) {
                return false;
            }
            SPSSettings sPSSettings = (SPSSettings)other;
            if (this.gameType != sPSSettings.gameType) {
                return false;
            }
            if (this.difficulty != sPSSettings.difficulty) {
                return false;
            }
            if (this.difficultyLocked != sPSSettings.difficultyLocked) {
                return false;
            }
            if (this.cheats != sPSSettings.cheats) {
                return false;
            }
            if (!Intrinsics.areEqual(this.invited, sPSSettings.invited)) {
                return false;
            }
            if (this.shareResourcePack != sPSSettings.shareResourcePack) {
                return false;
            }
            return Intrinsics.areEqual(this.oppedPlayers, sPSSettings.oppedPlayers);
        }

        public SPSSettings() {
            this(null, null, false, false, null, false, null, 127, null);
        }
    }
}

