/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.impl.commonmark.internal;

import gg.essential.elementa.impl.commonmark.internal.util.Parsing;
import gg.essential.elementa.impl.commonmark.node.Block;
import gg.essential.elementa.impl.commonmark.node.BlockQuote;
import gg.essential.elementa.impl.commonmark.parser.block.AbstractBlockParser;
import gg.essential.elementa.impl.commonmark.parser.block.AbstractBlockParserFactory;
import gg.essential.elementa.impl.commonmark.parser.block.BlockContinue;
import gg.essential.elementa.impl.commonmark.parser.block.BlockStart;
import gg.essential.elementa.impl.commonmark.parser.block.MatchedBlockParser;
import gg.essential.elementa.impl.commonmark.parser.block.ParserState;

public class BlockQuoteParser
extends AbstractBlockParser {
    private final BlockQuote block = new BlockQuote();

    @Override
    public boolean isContainer() {
        return true;
    }

    @Override
    public boolean canContain(Block block) {
        return true;
    }

    @Override
    public BlockQuote getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState state2) {
        int nextNonSpace = state2.getNextNonSpaceIndex();
        if (BlockQuoteParser.isMarker(state2, nextNonSpace)) {
            int newColumn = state2.getColumn() + state2.getIndent() + 1;
            if (Parsing.isSpaceOrTab(state2.getLine().getContent(), nextNonSpace + 1)) {
                ++newColumn;
            }
            return BlockContinue.atColumn(newColumn);
        }
        return BlockContinue.none();
    }

    private static boolean isMarker(ParserState state2, int index2) {
        CharSequence line = state2.getLine().getContent();
        return state2.getIndent() < Parsing.CODE_BLOCK_INDENT && index2 < line.length() && line.charAt(index2) == '>';
    }

    public static class Factory
    extends AbstractBlockParserFactory {
        @Override
        public BlockStart tryStart(ParserState state2, MatchedBlockParser matchedBlockParser) {
            int nextNonSpace = state2.getNextNonSpaceIndex();
            if (BlockQuoteParser.isMarker(state2, nextNonSpace)) {
                int newColumn = state2.getColumn() + state2.getIndent() + 1;
                if (Parsing.isSpaceOrTab(state2.getLine().getContent(), nextNonSpace + 1)) {
                    ++newColumn;
                }
                return BlockStart.of(new BlockQuoteParser()).atColumn(newColumn);
            }
            return BlockStart.none();
        }
    }
}

