/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.impl.dom4j.datatype;

import com.sun.msv.datatype.DatabindableDatatype;
import com.sun.msv.datatype.SerializationContext;
import com.sun.msv.datatype.xsd.XSDatatype;
import gg.essential.elementa.impl.dom4j.Element;
import gg.essential.elementa.impl.dom4j.Namespace;
import gg.essential.elementa.impl.dom4j.Node;
import gg.essential.elementa.impl.dom4j.QName;
import gg.essential.elementa.impl.dom4j.tree.DefaultElement;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

public class DatatypeElement
extends DefaultElement
implements SerializationContext,
ValidationContext {
    private XSDatatype datatype;
    private Object data;

    public DatatypeElement(QName qname, XSDatatype datatype) {
        super(qname);
        this.datatype = datatype;
    }

    public DatatypeElement(QName qname, int attributeCount, XSDatatype type) {
        super(qname, attributeCount);
        this.datatype = type;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + this.hashCode() + " [Element: <" + this.getQualifiedName() + " attributes: " + this.attributeList() + " data: " + this.getData() + " />]";
    }

    public XSDatatype getXSDatatype() {
        return this.datatype;
    }

    public String getNamespacePrefix(String uri) {
        Namespace namespace = this.getNamespaceForURI(uri);
        return namespace != null ? namespace.getPrefix() : null;
    }

    public String getBaseUri() {
        return null;
    }

    public boolean isNotation(String notationName) {
        return false;
    }

    public boolean isUnparsedEntity(String entityName) {
        return true;
    }

    public String resolveNamespacePrefix(String prefix) {
        Namespace namespace = this.getNamespaceForPrefix(prefix);
        if (namespace != null) {
            return namespace.getURI();
        }
        return null;
    }

    @Override
    public Object getData() {
        String text2;
        if (this.data == null && (text2 = this.getTextTrim()) != null && text2.length() > 0) {
            if (this.datatype instanceof DatabindableDatatype) {
                XSDatatype bind2 = this.datatype;
                this.data = bind2.createJavaObject(text2, (ValidationContext)this);
            } else {
                this.data = this.datatype.createValue(text2, (ValidationContext)this);
            }
        }
        return this.data;
    }

    @Override
    public void setData(Object data) {
        String s = this.datatype.convertToLexicalValue(data, (SerializationContext)this);
        this.validate(s);
        this.data = data;
        this.setText(s);
    }

    @Override
    public Element addText(String text2) {
        this.validate(text2);
        return super.addText(text2);
    }

    @Override
    public void setText(String text2) {
        this.validate(text2);
        super.setText(text2);
    }

    @Override
    protected void childAdded(Node node2) {
        this.data = null;
        super.childAdded(node2);
    }

    @Override
    protected void childRemoved(Node node2) {
        this.data = null;
        super.childRemoved(node2);
    }

    protected void validate(String text2) throws IllegalArgumentException {
        try {
            this.datatype.checkValid(text2, (ValidationContext)this);
        }
        catch (DatatypeException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }
}

