/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.common.modal;

import gg.essential.elementa.UIComponent;
import gg.essential.elementa.state.State;
import gg.essential.gui.common.EssentialTooltip;
import gg.essential.gui.common.ExtensionsKt;
import gg.essential.gui.common.LoadingIcon;
import gg.essential.gui.common.StateExtensionsKt;
import gg.essential.gui.common.modal.CancelableInputModal;
import gg.essential.gui.common.modal.UsernameInputModal;
import gg.essential.gui.elementa.state.v2.CompatibilityKt;
import gg.essential.gui.elementa.state.v2.MutableState;
import gg.essential.gui.elementa.state.v2.StateByKt;
import gg.essential.gui.elementa.state.v2.StateByScope;
import gg.essential.gui.elementa.state.v2.combinators.BooleansKt;
import gg.essential.gui.elementa.state.v2.combinators.StateKt;
import gg.essential.gui.overlay.ModalManager;
import gg.essential.gui.util.ElementaExtensionsKt;
import gg.essential.util.DispatchersKt;
import gg.essential.util.EssentialGuiExtensionsKt;
import gg.essential.util.PlayerNotFoundException;
import gg.essential.util.RateLimitException;
import gg.essential.util.UuidNameLookup;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.CharRange;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.ExecutorsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\u001e\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0002\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lgg/essential/gui/common/modal/UsernameInputModal;", "Lgg/essential/gui/common/modal/CancelableInputModal;", "modalManager", "Lgg/essential/gui/overlay/ModalManager;", "placeholderText", "", "initialText", "whenValidated", "Lkotlin/Function3;", "Ljava/util/UUID;", "", "(Lgg/essential/gui/overlay/ModalManager;Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function3;)V", "defaultErrors", "Lgg/essential/gui/elementa/state/v2/State;", "disabledAddButton", "", "errorOverride", "Lgg/essential/gui/elementa/state/v2/MutableState;", "getErrorOverride", "()Lgg/essential/gui/elementa/state/v2/MutableState;", "rateLimited", "tooltipText", "unknownUser", "essential-gui-essential"})
public class UsernameInputModal
extends CancelableInputModal {
    @NotNull
    private final MutableState<String> errorOverride;
    @NotNull
    private final MutableState<Boolean> rateLimited;
    @NotNull
    private final MutableState<Boolean> unknownUser;
    @NotNull
    private final gg.essential.gui.elementa.state.v2.State<Boolean> disabledAddButton;
    @NotNull
    private final gg.essential.gui.elementa.state.v2.State<String> defaultErrors;
    @NotNull
    private final gg.essential.gui.elementa.state.v2.State<String> tooltipText;

    public UsernameInputModal(@NotNull ModalManager modalManager, @NotNull String placeholderText, @NotNull String initialText, final @NotNull Function3<? super UUID, ? super String, ? super UsernameInputModal, Unit> whenValidated) {
        Intrinsics.checkNotNullParameter((Object)modalManager, (String)"modalManager");
        Intrinsics.checkNotNullParameter((Object)placeholderText, (String)"placeholderText");
        Intrinsics.checkNotNullParameter((Object)initialText, (String)"initialText");
        Intrinsics.checkNotNullParameter(whenValidated, (String)"whenValidated");
        super(modalManager, placeholderText, initialText, 16, false, 16, null);
        this.errorOverride = gg.essential.gui.elementa.state.v2.StateKt.mutableStateOf(null);
        this.rateLimited = gg.essential.gui.elementa.state.v2.StateKt.mutableStateOf(false);
        this.unknownUser = gg.essential.gui.elementa.state.v2.StateKt.mutableStateOf(false);
        this.disabledAddButton = BooleansKt.or(BooleansKt.or((gg.essential.gui.elementa.state.v2.State<Boolean>)this.rateLimited, (gg.essential.gui.elementa.state.v2.State<Boolean>)this.unknownUser), StateKt.map((gg.essential.gui.elementa.state.v2.State)this.errorOverride, disabledAddButton.1.INSTANCE));
        this.defaultErrors = StateByKt.stateBy((Function1)new Function1<StateByScope, String>(this){
            final /* synthetic */ UsernameInputModal this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull StateByScope $this$stateBy) {
                Intrinsics.checkNotNullParameter((Object)$this$stateBy, (String)"$this$stateBy");
                return (Boolean)$this$stateBy.invoke(UsernameInputModal.access$getRateLimited$p(this.this$0)) != false ? "Too many requests,\nplease wait" : ((Boolean)$this$stateBy.invoke(UsernameInputModal.access$getUnknownUser$p(this.this$0)) != false ? "Username doesn't exist" : "");
            }
        });
        this.tooltipText = StateKt.zip((gg.essential.gui.elementa.state.v2.State)this.errorOverride, this.defaultErrors, tooltipText.1.INSTANCE);
        this.addAllowedCharacters((Iterable)new CharRange('A', 'Z'));
        this.addAllowedCharacters((Iterable)new CharRange('a', 'z'));
        this.addAllowedCharacters((Iterable)new CharRange('0', '9'));
        char[] cArray = new char[]{'_'};
        this.addAllowedCharacters(cArray);
        this.getInputTextState().onSetValue(this, (Function1<String, Unit>)((Function1)new Function1<String, Unit>(){

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                unknownUser.set(false);
                this.getErrorOverride().set((String)null);
            }
        }));
        this.bindConfirmAvailable((State<Boolean>)StateExtensionsKt.not(CompatibilityKt.toV1(this.disabledAddButton, this)));
        this.bindPrimaryButtonText(CompatibilityKt.toV1(StateKt.map((gg.essential.gui.elementa.state.v2.State)this.rateLimited, 2.INSTANCE), this));
        ExtensionsKt.bindParent$default(EssentialGuiExtensionsKt.centered((UIComponent)new LoadingIcon(1.0)), this.getPrimaryActionButton(), this.rateLimited, false, null, 12, null);
        EssentialGuiExtensionsKt.bindEssentialTooltip$default(this.getPrimaryActionButton(), ExtensionsKt.and(ElementaExtensionsKt.hoveredState(this.getPrimaryActionButton()), CompatibilityKt.toV1(this.disabledAddButton, this)), CompatibilityKt.toV1(this.tooltipText, this), EssentialTooltip.Position.ABOVE.INSTANCE, 0.0f, null, null, null, 120, null);
        this.tooltipText.onSetValue(this, (Function1<String, Unit>)((Function1)new Function1<String, Unit>(){

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (!StringsKt.isBlank((CharSequence)it)) {
                    this.setError(it);
                } else {
                    this.clearError();
                }
            }
        }));
        this.setPrimaryButtonAction((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                final String inputText = (String)this.getInputTextState().get();
                this.getPrimaryButtonEnableStateOverride().set(false);
                UuidNameLookup.getUUID(inputText).whenCompleteAsync((arg_0, arg_1) -> 4.invoke$lambda$0((Function2)new Function2<UUID, Throwable, Unit>(){

                    public final void invoke(UUID uuid, Throwable exception) {
                        this.getPrimaryButtonEnableStateOverride().set(true);
                        if (exception == null) {
                            Intrinsics.checkNotNull((Object)uuid);
                            whenValidated.invoke((Object)uuid, (Object)inputText, (Object)this);
                        } else {
                            Throwable throwable = exception.getCause();
                            if (throwable instanceof PlayerNotFoundException) {
                                unknownUser.set(true);
                            } else if (throwable instanceof RateLimitException) {
                                this.delay(31000L, (Function0<Unit>)((Function0)new Function0<Unit>(){

                                    public final void invoke() {
                                        rateLimited.set(false);
                                    }
                                }));
                                rateLimited.set(true);
                            } else {
                                exception.printStackTrace();
                                this.setError("Unknown error occurred");
                            }
                        }
                    }
                }, arg_0, arg_1), ExecutorsKt.asExecutor((CoroutineDispatcher)DispatchersKt.getClient(Dispatchers.INSTANCE)));
            }

            private static final void invoke$lambda$0(Function2 $tmp0, Object p0, Object p1) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0, p1);
            }
        }));
    }

    public /* synthetic */ UsernameInputModal(ModalManager modalManager, String string, String string2, Function3 function3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = "";
        }
        this(modalManager, string, string2, (Function3<? super UUID, ? super String, ? super UsernameInputModal, Unit>)function3);
    }

    @NotNull
    public final MutableState<String> getErrorOverride() {
        return this.errorOverride;
    }
}

