/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.elementa.state.v2;

import gg.essential.elementa.UIComponent;
import gg.essential.elementa.components.Window;
import gg.essential.elementa.constraints.animation.AnimationStrategy;
import gg.essential.elementa.effects.Effect;
import gg.essential.elementa.state.v2.ReferenceHolder;
import gg.essential.gui.elementa.state.v2.MutableState;
import gg.essential.gui.elementa.state.v2.Observer;
import gg.essential.gui.elementa.state.v2.State;
import gg.essential.gui.elementa.state.v2.StateKt;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u000126\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0004\u0012\b\b\u0005\u0012\u0004\b\b(\u0006\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0004\u0012\b\b\u0005\u0012\u0004\b\b(\b\u0012\u0004\u0012\u00020\t0\u0002j\u0002`\n:\u0001 BC\u0012\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\f0\f\u0012\u0018\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\f0\u000f0\u000e\u0012\u0006\u0010\u0010\u001a\u00020\u0003\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u001c\u001a\u00020\tH\u0002J\u0019\u0010\u001d\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0007H\u0096\u0002J\f\u0010\u001e\u001a\u00020\u0003*\u00020\u001fH\u0002R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\f0\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lgg/essential/gui/elementa/state/v2/AnimationDriver;", "Lgg/essential/elementa/effects/Effect;", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "dt", "", "dtMs", "", "Lgg/essential/elementa/components/UpdateFunc;", "driver", "Lgg/essential/gui/elementa/state/v2/State;", "resultStateWeakReference", "Ljava/lang/ref/WeakReference;", "Lgg/essential/gui/elementa/state/v2/MutableState;", "duration", "animationStrategy", "Lgg/essential/elementa/constraints/animation/AnimationStrategy;", "(Lgg/essential/gui/elementa/state/v2/State;Ljava/lang/ref/WeakReference;FLgg/essential/elementa/constraints/animation/AnimationStrategy;)V", "animationEventList", "", "Lgg/essential/gui/elementa/state/v2/AnimationDriver$AnimationEvent;", "driverEffect", "Lkotlin/Function0;", "isDestroying", "", "previousDriverStateValue", "destroy", "invoke", "getAnimationValue", "Lgg/essential/gui/elementa/state/v2/Observer;", "AnimationEvent", "essential-elementa-statev2"})
@SourceDebugExtension(value={"SMAP\nanimate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 animate.kt\ngg/essential/gui/elementa/state/v2/AnimationDriver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n1855#2,2:113\n1789#2,3:115\n*S KotlinDebug\n*F\n+ 1 animate.kt\ngg/essential/gui/elementa/state/v2/AnimationDriver\n*L\n76#1:113,2\n99#1:115,3\n*E\n"})
final class AnimationDriver
extends Effect
implements Function2<Float, Integer, Unit> {
    @NotNull
    private final WeakReference<MutableState<State<Float>>> resultStateWeakReference;
    private final float duration;
    @NotNull
    private final AnimationStrategy animationStrategy;
    @NotNull
    private final List<AnimationEvent> animationEventList;
    @NotNull
    private final Function0<Unit> driverEffect;
    @NotNull
    private State<Float> previousDriverStateValue;
    private boolean isDestroying;

    public AnimationDriver(@NotNull State<? extends State<Float>> driver, @NotNull WeakReference<MutableState<State<Float>>> resultStateWeakReference, float duration, @NotNull AnimationStrategy animationStrategy) {
        Intrinsics.checkNotNullParameter(driver, (String)"driver");
        Intrinsics.checkNotNullParameter(resultStateWeakReference, (String)"resultStateWeakReference");
        Intrinsics.checkNotNullParameter((Object)animationStrategy, (String)"animationStrategy");
        this.resultStateWeakReference = resultStateWeakReference;
        this.duration = duration;
        this.animationStrategy = animationStrategy;
        this.animationEventList = new ArrayList();
        this.previousDriverStateValue = StateKt.stateOf(Float.valueOf(0.0f));
        this.previousDriverStateValue = driver.getUntracked();
        this.driverEffect = StateKt.onChange(driver, ReferenceHolder.Weak.INSTANCE, (Function2)new Function2<Observer, State<? extends Float>, Unit>(){

            public final void invoke(@NotNull Observer $this$onChange, @NotNull State<Float> input2) {
                Intrinsics.checkNotNullParameter((Object)$this$onChange, (String)"$this$onChange");
                Intrinsics.checkNotNullParameter(input2, (String)"input");
                if (animationEventList.isEmpty()) {
                    this.addUpdateFunc((Function2<? super Float, ? super Integer, Unit>)this);
                }
                animationEventList.add(new AnimationEvent(previousDriverStateValue, input2, 0.0f, 4, null));
                previousDriverStateValue = input2;
            }
        });
    }

    public void invoke(float dt, int dtMs) {
        MutableState resultState = (MutableState)this.resultStateWeakReference.get();
        if (resultState == null) {
            this.destroy();
        } else {
            Iterable $this$forEach$iv = this.animationEventList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AnimationEvent it = (AnimationEvent)element$iv;
                boolean bl = false;
                it.setAge(it.getAge() + dt);
            }
            this.animationEventList.removeIf(arg_0 -> AnimationDriver.invoke$lambda$1((Function1)new Function1<AnimationEvent, Boolean>(this){
                final /* synthetic */ AnimationDriver this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull AnimationEvent it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return it.getAge() >= AnimationDriver.access$getDuration$p(this.this$0);
                }
            }, arg_0));
            if (this.animationEventList.isEmpty()) {
                this.removeUpdateFunc((Function2<? super Float, ? super Integer, Unit>)((Function2)this));
            }
            resultState.set(arg_0 -> AnimationDriver.invoke$lambda$2(this, arg_0));
        }
    }

    private final void destroy() {
        if (this.isDestroying) {
            return;
        }
        this.isDestroying = true;
        this.driverEffect.invoke();
        Window.Companion.enqueueRenderOperation((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ AnimationDriver this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                AnimationDriver.access$getBoundComponent(this.this$0).removeEffect(this.this$0);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final float getAnimationValue(Observer $this$getAnimationValue) {
        void $this$fold$iv;
        if (this.animationEventList.isEmpty()) {
            return ((Number)$this$getAnimationValue.invoke(this.previousDriverStateValue)).floatValue();
        }
        Iterable iterable = this.animationEventList;
        Float initial$iv = $this$getAnimationValue.invoke(((AnimationEvent)CollectionsKt.first(this.animationEventList)).getStartValue());
        boolean $i$f$fold = false;
        Float accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void event;
            AnimationEvent animationEvent = (AnimationEvent)element$iv;
            float acc = ((Number)accumulator$iv).floatValue();
            boolean bl = false;
            float linearProgress = event.getAge() / this.duration;
            float animatedProgress = this.animationStrategy.getValue(linearProgress);
            accumulator$iv = Float.valueOf(acc + (((Number)$this$getAnimationValue.invoke(event.getEndValue())).floatValue() - acc) * animatedProgress);
        }
        return ((Number)accumulator$iv).floatValue();
    }

    private static final boolean invoke$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final float invoke$lambda$2(AnimationDriver this$0, Observer $this$State) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this$State, (String)"$this$State");
        return this$0.getAnimationValue($this$State);
    }

    public static final /* synthetic */ float access$getDuration$p(AnimationDriver $this) {
        return $this.duration;
    }

    public static final /* synthetic */ UIComponent access$getBoundComponent(AnimationDriver $this) {
        return $this.getBoundComponent();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0004H\u00c6\u0003J3\u0010\u0012\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u001a\u0010\u0006\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u001a"}, d2={"Lgg/essential/gui/elementa/state/v2/AnimationDriver$AnimationEvent;", "", "startValue", "Lgg/essential/gui/elementa/state/v2/State;", "", "endValue", "age", "(Lgg/essential/gui/elementa/state/v2/State;Lgg/essential/gui/elementa/state/v2/State;F)V", "getAge", "()F", "setAge", "(F)V", "getEndValue", "()Lgg/essential/gui/elementa/state/v2/State;", "getStartValue", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "essential-elementa-statev2"})
    private static final class AnimationEvent {
        @NotNull
        private final State<Float> startValue;
        @NotNull
        private final State<Float> endValue;
        private float age;

        public AnimationEvent(@NotNull State<Float> startValue, @NotNull State<Float> endValue, float age) {
            Intrinsics.checkNotNullParameter(startValue, (String)"startValue");
            Intrinsics.checkNotNullParameter(endValue, (String)"endValue");
            this.startValue = startValue;
            this.endValue = endValue;
            this.age = age;
        }

        public /* synthetic */ AnimationEvent(State state2, State state3, float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                f = 0.0f;
            }
            this(state2, state3, f);
        }

        @NotNull
        public final State<Float> getStartValue() {
            return this.startValue;
        }

        @NotNull
        public final State<Float> getEndValue() {
            return this.endValue;
        }

        public final float getAge() {
            return this.age;
        }

        public final void setAge(float f) {
            this.age = f;
        }

        @NotNull
        public final State<Float> component1() {
            return this.startValue;
        }

        @NotNull
        public final State<Float> component2() {
            return this.endValue;
        }

        public final float component3() {
            return this.age;
        }

        @NotNull
        public final AnimationEvent copy(@NotNull State<Float> startValue, @NotNull State<Float> endValue, float age) {
            Intrinsics.checkNotNullParameter(startValue, (String)"startValue");
            Intrinsics.checkNotNullParameter(endValue, (String)"endValue");
            return new AnimationEvent(startValue, endValue, age);
        }

        public static /* synthetic */ AnimationEvent copy$default(AnimationEvent animationEvent, State state2, State state3, float f, int n, Object object) {
            if ((n & 1) != 0) {
                state2 = animationEvent.startValue;
            }
            if ((n & 2) != 0) {
                state3 = animationEvent.endValue;
            }
            if ((n & 4) != 0) {
                f = animationEvent.age;
            }
            return animationEvent.copy(state2, state3, f);
        }

        @NotNull
        public String toString() {
            return "AnimationEvent(startValue=" + this.startValue + ", endValue=" + this.endValue + ", age=" + this.age + ')';
        }

        public int hashCode() {
            int result = this.startValue.hashCode();
            result = result * 31 + this.endValue.hashCode();
            result = result * 31 + Float.hashCode(this.age);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AnimationEvent)) {
                return false;
            }
            AnimationEvent animationEvent = (AnimationEvent)other;
            if (!Intrinsics.areEqual(this.startValue, animationEvent.startValue)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.endValue, animationEvent.endValue)) {
                return false;
            }
            return Float.compare(this.age, animationEvent.age) == 0;
        }
    }
}

