/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.elementa.state.v2;

import gg.essential.gui.elementa.state.v2.ObservedDuration;
import gg.essential.gui.elementa.state.v2.ObservedLong;
import gg.essential.gui.elementa.state.v2.ObservedValue;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u00020\u0002H\u0016J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002J\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002J\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u000e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0002R \u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lgg/essential/gui/elementa/state/v2/ObservedInstant;", "Lgg/essential/gui/elementa/state/v2/ObservedValue;", "Ljava/time/Instant;", "untracked", "changesAt", "Lkotlin/Function1;", "", "(Ljava/time/Instant;Lkotlin/jvm/functions/Function1;)V", "getChangesAt", "()Lkotlin/jvm/functions/Function1;", "getUntracked", "()Ljava/time/Instant;", "getValue", "isAfter", "", "other", "isBefore", "since", "Lgg/essential/gui/elementa/state/v2/ObservedDuration;", "startInclusive", "toEpochMillis", "Lgg/essential/gui/elementa/state/v2/ObservedLong;", "toString", "", "until", "endExclusive", "essential-elementa-statev2"})
public final class ObservedInstant
implements ObservedValue<Instant> {
    @NotNull
    private final Instant untracked;
    @NotNull
    private final Function1<Instant, Unit> changesAt;

    public ObservedInstant(@NotNull Instant untracked, @NotNull Function1<? super Instant, Unit> changesAt) {
        Intrinsics.checkNotNullParameter((Object)untracked, (String)"untracked");
        Intrinsics.checkNotNullParameter(changesAt, (String)"changesAt");
        this.untracked = untracked;
        this.changesAt = changesAt;
    }

    @Override
    @NotNull
    public Instant getUntracked() {
        return this.untracked;
    }

    @Override
    @NotNull
    public Function1<Instant, Unit> getChangesAt() {
        return this.changesAt;
    }

    @Override
    @NotNull
    public Instant getValue() {
        if (!Intrinsics.areEqual((Object)this.getUntracked(), (Object)Instant.MIN)) {
            Function1<Instant, Unit> function1 = this.getChangesAt();
            Instant instant = this.getUntracked().minusNanos(1L);
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"minusNanos(...)");
            function1.invoke((Object)instant);
        }
        if (!Intrinsics.areEqual((Object)this.getUntracked(), (Object)Instant.MAX)) {
            Function1<Instant, Unit> function1 = this.getChangesAt();
            Instant instant = this.getUntracked().plusNanos(1L);
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"plusNanos(...)");
            function1.invoke((Object)instant);
        }
        return this.getUntracked();
    }

    @NotNull
    public String toString() {
        String string = this.getValue().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final ObservedLong toEpochMillis() {
        return new ObservedLong(this.getUntracked().toEpochMilli(), (Function1<? super Long, Unit>)((Function1)new Function1<Long, Unit>(this){
            final /* synthetic */ ObservedInstant this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(long it) {
                Function1<Instant, Unit> function1 = this.this$0.getChangesAt();
                Instant instant = Instant.ofEpochMilli(it);
                Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochMilli(...)");
                function1.invoke((Object)instant);
            }
        }));
    }

    public final boolean isBefore(@NotNull Instant other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return ObservedDuration.Companion.between(this, other).isPositive();
    }

    public final boolean isAfter(@NotNull Instant other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return ObservedDuration.Companion.between(other, this).isPositive();
    }

    @NotNull
    public final ObservedDuration since(@NotNull Instant startInclusive) {
        Intrinsics.checkNotNullParameter((Object)startInclusive, (String)"startInclusive");
        return ObservedDuration.Companion.between(startInclusive, this);
    }

    @NotNull
    public final ObservedDuration until(@NotNull Instant endExclusive) {
        Intrinsics.checkNotNullParameter((Object)endExclusive, (String)"endExclusive");
        return ObservedDuration.Companion.between(this, endExclusive);
    }
}

