/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.elementa.state.v2;

import gg.essential.gui.elementa.state.v2.MutableState;
import gg.essential.gui.elementa.state.v2.Observer;
import gg.essential.gui.elementa.state.v2.State;
import gg.essential.gui.elementa.state.v2.StateKt;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\r\u001a\u00020\u000b*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004J\u0014\u0010\u0010\u001a\u00020\u000b*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R*\u0010\b\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u0003\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u0012"}, d2={"Lgg/essential/gui/elementa/state/v2/StateScheduler;", "", "time", "Lgg/essential/gui/elementa/state/v2/State;", "Ljava/time/Instant;", "(Lgg/essential/gui/elementa/state/v2/State;)V", "getTime", "()Lgg/essential/gui/elementa/state/v2/State;", "triggerCache", "", "Lkotlin/Pair;", "", "[Lkotlin/Pair;", "observe", "Lgg/essential/gui/elementa/state/v2/Observer;", "targetTime", "observeRoughly", "Companion", "essential-elementa-statev2"})
public final class StateScheduler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final State<Instant> time;
    @NotNull
    private final Pair<Instant, State<Boolean>>[] triggerCache;
    @NotNull
    private static final MutableState<Instant> systemTime = StateKt.mutableStateOf(Instant.EPOCH);
    @NotNull
    private static final StateScheduler forSystemTime = new StateScheduler((State<Instant>)systemTime);

    public StateScheduler(@NotNull State<Instant> time2) {
        Intrinsics.checkNotNullParameter(time2, (String)"time");
        this.time = time2;
        this.triggerCache = new Pair[64];
    }

    @NotNull
    public final State<Instant> getTime() {
        return this.time;
    }

    public final boolean observe(@NotNull Observer $this$observe, @NotNull Instant targetTime) {
        Intrinsics.checkNotNullParameter((Object)$this$observe, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)targetTime, (String)"targetTime");
        if (!targetTime.isAfter(this.time.getUntracked())) {
            return true;
        }
        return (Boolean)$this$observe.invoke(StateKt.memo((Function1)new Function1<Observer, Boolean>(this, targetTime){
            final /* synthetic */ StateScheduler this$0;
            final /* synthetic */ Instant $targetTime;
            {
                this.this$0 = $receiver;
                this.$targetTime = $targetTime;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Observer $this$memo) {
                Intrinsics.checkNotNullParameter((Object)$this$memo, (String)"$this$memo");
                return StateScheduler.access$observeRoughly(this.this$0, $this$memo, this.$targetTime);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final boolean observeRoughly(Observer $this$observeRoughly, Instant targetTime) {
        Instant now2 = this.time.getUntracked();
        Duration delay2 = Duration.between(now2, targetTime);
        if (delay2.isNegative() || delay2.isZero()) {
            return true;
        }
        if (delay2.compareTo(Duration.ofMillis(8L)) <= 0) {
            $this$observeRoughly.invoke(this.time);
            return false;
        }
        long nowMs = now2.toEpochMilli();
        long targetMs = targetTime.toEpochMilli();
        int bitsMatching = Long.numberOfLeadingZeros(nowMs ^ targetMs);
        Instant nextWakeupTime = Instant.ofEpochMilli(targetMs & (-1L >>> bitsMatching + 1 ^ 0xFFFFFFFFFFFFFFFFL));
        Pair trigger = this.triggerCache[bitsMatching];
        if (trigger == null || !Intrinsics.areEqual((Object)trigger.getFirst(), (Object)nextWakeupTime)) {
            void it;
            State state2 = StateKt.memo((Function1)new Function1<Observer, Boolean>(this, nextWakeupTime){
                final /* synthetic */ StateScheduler this$0;
                final /* synthetic */ Instant $nextWakeupTime;
                {
                    this.this$0 = $receiver;
                    this.$nextWakeupTime = $nextWakeupTime;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Observer $this$memo) {
                    boolean bl;
                    Intrinsics.checkNotNullParameter((Object)$this$memo, (String)"$this$memo");
                    if (this.this$0.getTime().getUntracked().compareTo(this.$nextWakeupTime) >= 0) {
                        bl = true;
                    } else {
                        $this$memo.invoke(this.this$0.getTime());
                        bl = false;
                    }
                    return bl;
                }
            });
            Instant instant = nextWakeupTime;
            boolean bl = false;
            State state3 = StateKt.memo((Function1)new Function1<Observer, Boolean>((State<Boolean>)it){
                final /* synthetic */ State<Boolean> $it;
                {
                    this.$it = $it;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Observer $this$memo) {
                    Intrinsics.checkNotNullParameter((Object)$this$memo, (String)"$this$memo");
                    return $this$memo.invoke(this.$it);
                }
            });
            Instant instant2 = instant;
            this.triggerCache[bitsMatching] = trigger = new Pair((Object)instant2, state3);
        }
        $this$observeRoughly.invoke((State)trigger.getSecond());
        return false;
    }

    @NotNull
    public static final StateScheduler getForSystemTime() {
        return Companion.getForSystemTime();
    }

    @JvmStatic
    public static final void updateSystemTime(@NotNull Instant now2) {
        Companion.updateSystemTime(now2);
    }

    public static final /* synthetic */ boolean access$observeRoughly(StateScheduler $this, Observer $receiver, Instant targetTime) {
        return $this.observeRoughly($receiver, targetTime);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\nH\u0007R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lgg/essential/gui/elementa/state/v2/StateScheduler$Companion;", "", "()V", "forSystemTime", "Lgg/essential/gui/elementa/state/v2/StateScheduler;", "getForSystemTime$annotations", "getForSystemTime", "()Lgg/essential/gui/elementa/state/v2/StateScheduler;", "systemTime", "Lgg/essential/gui/elementa/state/v2/MutableState;", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "updateSystemTime", "", "now", "essential-elementa-statev2"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final StateScheduler getForSystemTime() {
            return forSystemTime;
        }

        @JvmStatic
        public static /* synthetic */ void getForSystemTime$annotations() {
        }

        @JvmStatic
        public final void updateSystemTime(@NotNull Instant now2) {
            Intrinsics.checkNotNullParameter((Object)now2, (String)"now");
            systemTime.set(now2);
        }

        public static /* synthetic */ void updateSystemTime$default(Companion companion, Instant instant, int n, Object object) {
            if ((n & 1) != 0) {
                Instant instant2 = Instant.now();
                Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now(...)");
                instant = instant2;
            }
            companion.updateSystemTime(instant);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

