/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.screenshot.editor;

import gg.essential.elementa.UIComponent;
import gg.essential.elementa.UIConstraints;
import gg.essential.elementa.components.UIBlock;
import gg.essential.elementa.components.UIContainer;
import gg.essential.elementa.components.Window;
import gg.essential.elementa.constraints.CenterConstraint;
import gg.essential.elementa.constraints.HeightConstraint;
import gg.essential.elementa.constraints.PositionConstraint;
import gg.essential.elementa.constraints.SuperConstraint;
import gg.essential.elementa.constraints.WidthConstraint;
import gg.essential.elementa.constraints.XConstraint;
import gg.essential.elementa.constraints.YConstraint;
import gg.essential.elementa.dsl.BasicConstraintsKt;
import gg.essential.elementa.dsl.ComponentsKt;
import gg.essential.elementa.dsl.ConstraintsKt;
import gg.essential.elementa.dsl.UtilitiesKt;
import gg.essential.elementa.effects.ScissorEffect;
import gg.essential.elementa.events.UIClickEvent;
import gg.essential.gui.EssentialPalette;
import gg.essential.gui.common.UINanoVG;
import gg.essential.gui.elementa.state.v2.MutableState;
import gg.essential.gui.elementa.state.v2.Observer;
import gg.essential.gui.elementa.state.v2.State;
import gg.essential.gui.elementa.state.v2.StateKt;
import gg.essential.gui.elementa.state.v2.collections.MutableTrackedList;
import gg.essential.gui.screenshot.LocalScreenshot;
import gg.essential.gui.screenshot.RemoteScreenshot;
import gg.essential.gui.screenshot.ScreenshotId;
import gg.essential.gui.screenshot.editor.ScreenshotCanvas;
import gg.essential.gui.screenshot.editor.change.Change;
import gg.essential.gui.screenshot.editor.change.CropChange;
import gg.essential.gui.screenshot.editor.change.EditHistory;
import gg.essential.gui.screenshot.editor.change.VectorStroke;
import gg.essential.gui.screenshot.image.ScreenshotImage;
import gg.essential.handlers.screenshot.ClientScreenshotMetadata;
import gg.essential.network.connectionmanager.media.IScreenshotManager;
import gg.essential.universal.UMatrixStack;
import gg.essential.universal.UResolution;
import gg.essential.util.UIdentifier;
import gg.essential.util.lwjgl3.api.nanovg.NanoVG;
import gg.essential.vigilance.gui.VigilancePalette;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadWriteProperty;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0004BCDEB\u001d\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J.\u00104\u001a\b\u0012\u0004\u0012\u000206052\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\b\b\u0002\u0010=\u001a\u00020<J\"\u0010>\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e0?2\u0006\u0010@\u001a\u00020\u001e2\u0006\u0010A\u001a\u00020\u001eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0019\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR=\u0010\u001c\u001a%\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u001f0\u001d\u00a2\u0006\u0002\b X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020\u0017X\u0082D\u00a2\u0006\u0002\n\u0000R\u001b\u0010&\u001a\u00020\u00018FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b'\u0010(R\u0019\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u000fR\u0011\u0010,\u001a\u00020-\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0015\u00100\u001a\u000601R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103\u00a8\u0006F"}, d2={"Lgg/essential/gui/screenshot/editor/ScreenshotCanvas;", "Lgg/essential/elementa/components/UIContainer;", "screenshot", "Lgg/essential/gui/elementa/state/v2/State;", "Lgg/essential/util/UIdentifier;", "editHistory", "Lgg/essential/gui/screenshot/editor/change/EditHistory;", "(Lgg/essential/gui/elementa/state/v2/State;Lgg/essential/gui/screenshot/editor/change/EditHistory;)V", "background", "Lgg/essential/elementa/components/UIBlock;", "getBackground", "()Lgg/essential/elementa/components/UIBlock;", "cropSettings", "Lgg/essential/gui/screenshot/editor/ScreenshotCanvas$Crop;", "getCropSettings", "()Lgg/essential/gui/elementa/state/v2/State;", "draggingCrop", "Lgg/essential/gui/elementa/state/v2/MutableState;", "getDraggingCrop", "()Lgg/essential/gui/elementa/state/v2/MutableState;", "getEditHistory", "()Lgg/essential/gui/screenshot/editor/change/EditHistory;", "mouseButton", "", "getMouseButton", "()I", "setMouseButton", "(I)V", "onDraw", "Lkotlin/Function4;", "", "", "Lkotlin/ExtensionFunctionType;", "getOnDraw", "()Lkotlin/jvm/functions/Function4;", "setOnDraw", "(Lkotlin/jvm/functions/Function4;)V", "padding", "retainedImage", "getRetainedImage", "()Lgg/essential/elementa/components/UIContainer;", "retainedImage$delegate", "Lkotlin/properties/ReadWriteProperty;", "getScreenshot", "screenshotDisplay", "Lgg/essential/elementa/UIComponent;", "getScreenshotDisplay", "()Lgg/essential/elementa/UIComponent;", "vectorEditingOverlay", "Lgg/essential/gui/screenshot/editor/ScreenshotCanvas$VectorEditingOverlay;", "getVectorEditingOverlay", "()Lgg/essential/gui/screenshot/editor/ScreenshotCanvas$VectorEditingOverlay;", "exportImage", "Ljava/util/concurrent/CompletableFuture;", "Ljava/io/File;", "source", "Lgg/essential/gui/screenshot/ScreenshotId;", "screenshotManager", "Lgg/essential/network/connectionmanager/media/IScreenshotManager;", "temp", "", "favorite", "getRelativeMousePosition", "Lkotlin/Pair;", "mouseX", "mouseY", "Crop", "CropAlignment", "ImageCropItem", "VectorEditingOverlay", "essential-gui-essential"})
@SourceDebugExtension(value={"SMAP\nScreenshotCanvas.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScreenshotCanvas.kt\ngg/essential/gui/screenshot/editor/ScreenshotCanvas\n+ 2 components.kt\ngg/essential/elementa/dsl/ComponentsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,414:1\n9#2,3:415\n9#2,3:418\n9#2,3:421\n9#2,3:424\n13309#3,2:427\n1549#4:429\n1620#4,3:430\n*S KotlinDebug\n*F\n+ 1 ScreenshotCanvas.kt\ngg/essential/gui/screenshot/editor/ScreenshotCanvas\n*L\n88#1:415,3\n96#1:418,3\n110#1:421,3\n120#1:424,3\n129#1:427,2\n217#1:429\n217#1:430,3\n*E\n"})
public final class ScreenshotCanvas
extends UIContainer {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final State<UIdentifier> screenshot;
    @NotNull
    private final EditHistory editHistory;
    @NotNull
    private Function4<? super UIContainer, ? super Float, ? super Float, ? super Integer, Unit> onDraw;
    private int mouseButton;
    private final int padding;
    @NotNull
    private final UIComponent screenshotDisplay;
    @NotNull
    private final UIBlock background;
    @NotNull
    private final MutableState<Crop> draggingCrop;
    @NotNull
    private final State<Crop> cropSettings;
    @NotNull
    private final ReadWriteProperty retainedImage$delegate;
    @NotNull
    private final VectorEditingOverlay vectorEditingOverlay;

    /*
     * WARNING - void declaration
     */
    public ScreenshotCanvas(@NotNull State<UIdentifier> screenshot, @NotNull EditHistory editHistory) {
        void $this$vectorEditingOverlay_u24lambda_u243;
        UIConstraints $this$retainedImage_delegate_u24lambda_u242;
        UIConstraints $this$background_u24lambda_u241;
        UIConstraints $this$screenshotDisplay_u24lambda_u240;
        UIComponent uIComponent;
        Intrinsics.checkNotNullParameter(screenshot, (String)"screenshot");
        Intrinsics.checkNotNullParameter((Object)editHistory, (String)"editHistory");
        this.screenshot = screenshot;
        this.editHistory = editHistory;
        this.onDraw = onDraw.1.INSTANCE;
        this.mouseButton = -1;
        this.padding = 2;
        UIComponent $this$constrain$iv = new UIContainer(this){
            final /* synthetic */ ScreenshotCanvas this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseMove(@NotNull Window window) {
                Intrinsics.checkNotNullParameter((Object)window, (String)"window");
                if (this.this$0.getMouseButton() != -1) {
                    Pair<Float, Float> pair = this.getMousePosition();
                    float x = ((Number)pair.component1()).floatValue();
                    float y = ((Number)pair.component2()).floatValue();
                    this.this$0.getOnDraw().invoke((Object)this, (Object)Float.valueOf(x), (Object)Float.valueOf(y), (Object)this.this$0.getMouseButton());
                }
                super.mouseMove(window);
            }

            public void draw(@NotNull UMatrixStack matrixStack) {
                Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
                this.this$0.getVectorEditingOverlay().draw(matrixStack);
                super.draw(matrixStack);
            }
        }.onMouseClick((Function2<? super UIComponent, ? super UIClickEvent, Unit>)((Function2)new Function2<UIComponent, UIClickEvent, Unit>(this){
            final /* synthetic */ ScreenshotCanvas this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull UIComponent $this$onMouseClick, @NotNull UIClickEvent event) {
                Intrinsics.checkNotNullParameter((Object)$this$onMouseClick, (String)"$this$onMouseClick");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.this$0.setMouseButton(event.getMouseButton());
                event.stopPropagation();
            }
        })).onMouseRelease((Function1<? super UIComponent, Unit>)((Function1)new Function1<UIComponent, Unit>(this){
            final /* synthetic */ ScreenshotCanvas this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull UIComponent $this$onMouseRelease) {
                Intrinsics.checkNotNullParameter((Object)$this$onMouseRelease, (String)"$this$onMouseRelease");
                this.this$0.setMouseButton(-1);
            }
        }));
        boolean $i$f$constrain = false;
        UIComponent $this$constrain_u24lambda_u240$iv = uIComponent = $this$constrain$iv;
        boolean bl = false;
        UIConstraints uIConstraints = $this$constrain_u24lambda_u240$iv.getConstraints();
        ScreenshotCanvas screenshotCanvas = this;
        boolean bl2 = false;
        $this$screenshotDisplay_u24lambda_u240.setHeight(ConstraintsKt.minus(UtilitiesKt.percent(100), UtilitiesKt.pixels$default(this.padding * 2, false, false, 3, null)));
        $this$screenshotDisplay_u24lambda_u240.setWidth(ConstraintsKt.minus(UtilitiesKt.percent(100), UtilitiesKt.pixels$default(this.padding * 2, false, false, 3, null)));
        $this$screenshotDisplay_u24lambda_u240.setX(UtilitiesKt.pixels$default(this.padding, false, false, 3, null));
        $this$screenshotDisplay_u24lambda_u240.setY(UtilitiesKt.pixels$default(this.padding, false, false, 3, null));
        screenshotCanvas.screenshotDisplay = ComponentsKt.childOf(uIComponent, this);
        $this$constrain$iv = new UIBlock(VigilancePalette.INSTANCE.getModalBackground());
        $i$f$constrain = false;
        $this$constrain_u24lambda_u240$iv = uIComponent = $this$constrain$iv;
        bl = false;
        $this$screenshotDisplay_u24lambda_u240 = $this$constrain_u24lambda_u240$iv.getConstraints();
        screenshotCanvas = this;
        boolean bl3 = false;
        $this$background_u24lambda_u241.setHeight(UtilitiesKt.percent(100));
        $this$background_u24lambda_u241.setWidth(UtilitiesKt.percent(100));
        screenshotCanvas.background = (UIBlock)ComponentsKt.childOf(uIComponent, this.screenshotDisplay);
        this.draggingCrop = StateKt.mutableStateOf(null);
        this.cropSettings = StateKt.memo((Function1)new Function1<Observer, Crop>(this){
            final /* synthetic */ ScreenshotCanvas this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Crop invoke(@NotNull Observer $this$memo) {
                Crop crop;
                Crop crop2;
                block3: {
                    Intrinsics.checkNotNullParameter((Object)$this$memo, (String)"$this$memo");
                    Crop crop3 = (Crop)$this$memo.invoke((State)this.this$0.getDraggingCrop());
                    if (crop3 != null) {
                        Crop it = crop3;
                        boolean bl = false;
                        return it;
                    }
                    for (Change it : (Iterable)CollectionsKt.asReversed((List)((List)$this$memo.invoke((State)this.this$0.getEditHistory().getHistory())))) {
                        boolean bl = false;
                        CropChange cropChange = it instanceof CropChange ? (CropChange)it : null;
                        Crop crop4 = cropChange != null ? cropChange.getNew() : null;
                        if (crop4 == null) continue;
                        crop2 = crop4;
                        break block3;
                    }
                    crop2 = crop = null;
                }
                if (crop2 == null) {
                    crop = Crop.Companion.getDEFAULT();
                }
                return crop;
            }
        });
        $this$constrain$iv = new UIContainer();
        $i$f$constrain = false;
        $this$constrain_u24lambda_u240$iv = uIComponent = $this$constrain$iv;
        bl = false;
        $this$background_u24lambda_u241 = $this$constrain_u24lambda_u240$iv.getConstraints();
        screenshotCanvas = this;
        boolean bl4 = false;
        $this$retainedImage_delegate_u24lambda_u242.setX(BasicConstraintsKt.basicXConstraint((Function1<? super UIComponent, Float>)((Function1)new Function1<UIComponent, Float>(this){
            final /* synthetic */ ScreenshotCanvas this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Float invoke(@NotNull UIComponent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Float.valueOf(it.getParent().getLeft() + it.getParent().getWidth() * this.this$0.getCropSettings().getUntracked().getLeft());
            }
        })));
        $this$retainedImage_delegate_u24lambda_u242.setY(BasicConstraintsKt.basicYConstraint((Function1<? super UIComponent, Float>)((Function1)new Function1<UIComponent, Float>(this){
            final /* synthetic */ ScreenshotCanvas this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Float invoke(@NotNull UIComponent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Float.valueOf(it.getParent().getTop() + it.getParent().getHeight() * this.this$0.getCropSettings().getUntracked().getTop());
            }
        })));
        $this$retainedImage_delegate_u24lambda_u242.setWidth(BasicConstraintsKt.basicWidthConstraint((Function1<? super UIComponent, Float>)((Function1)new Function1<UIComponent, Float>(this){
            final /* synthetic */ ScreenshotCanvas this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Float invoke(@NotNull UIComponent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Float.valueOf(it.getParent().getWidth() * this.this$0.getCropSettings().getUntracked().getWidth());
            }
        })));
        $this$retainedImage_delegate_u24lambda_u242.setHeight(BasicConstraintsKt.basicHeightConstraint((Function1<? super UIComponent, Float>)((Function1)new Function1<UIComponent, Float>(this){
            final /* synthetic */ ScreenshotCanvas this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Float invoke(@NotNull UIComponent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Float.valueOf(it.getParent().getHeight() * this.this$0.getCropSettings().getUntracked().getHeight());
            }
        })));
        screenshotCanvas.retainedImage$delegate = ComponentsKt.provideDelegate(ComponentsKt.effect(ComponentsKt.childOf(uIComponent, this.screenshotDisplay), new ScissorEffect(null, false, 3, null)), this, $$delegatedProperties[0]);
        $this$constrain$iv = new VectorEditingOverlay(this, this.screenshot);
        $i$f$constrain = false;
        $this$constrain_u24lambda_u240$iv = uIComponent = $this$constrain$iv;
        bl = false;
        $this$retainedImage_delegate_u24lambda_u242 = $this$constrain_u24lambda_u240$iv.getConstraints();
        screenshotCanvas = this;
        boolean bl5 = false;
        $this$vectorEditingOverlay_u24lambda_u243.setX((XConstraint)ConstraintsKt.boundTo((SuperConstraint)UtilitiesKt.getPixels(0), this.screenshotDisplay));
        $this$vectorEditingOverlay_u24lambda_u243.setY((YConstraint)ConstraintsKt.boundTo((SuperConstraint)UtilitiesKt.getPixels(0), this.screenshotDisplay));
        $this$vectorEditingOverlay_u24lambda_u243.setHeight((HeightConstraint)ConstraintsKt.boundTo((SuperConstraint)UtilitiesKt.percent(100), this.screenshotDisplay));
        $this$vectorEditingOverlay_u24lambda_u243.setWidth((WidthConstraint)ConstraintsKt.boundTo((SuperConstraint)UtilitiesKt.percent(100), this.screenshotDisplay));
        screenshotCanvas.vectorEditingOverlay = (VectorEditingOverlay)ComponentsKt.childOf(uIComponent, this.getRetainedImage());
        CropAlignment[] $this$forEach$iv = CropAlignment.values();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            CropAlignment element$iv;
            CropAlignment alignment = element$iv = $this$forEach$iv[j];
            boolean bl6 = false;
            ComponentsKt.childOf((UIComponent)new ImageCropItem(alignment), this);
        }
    }

    @NotNull
    public final State<UIdentifier> getScreenshot() {
        return this.screenshot;
    }

    @NotNull
    public final EditHistory getEditHistory() {
        return this.editHistory;
    }

    @NotNull
    public final Function4<UIContainer, Float, Float, Integer, Unit> getOnDraw() {
        return this.onDraw;
    }

    public final void setOnDraw(@NotNull Function4<? super UIContainer, ? super Float, ? super Float, ? super Integer, Unit> function4) {
        Intrinsics.checkNotNullParameter(function4, (String)"<set-?>");
        this.onDraw = function4;
    }

    public final int getMouseButton() {
        return this.mouseButton;
    }

    public final void setMouseButton(int n) {
        this.mouseButton = n;
    }

    @NotNull
    public final UIComponent getScreenshotDisplay() {
        return this.screenshotDisplay;
    }

    @NotNull
    public final UIBlock getBackground() {
        return this.background;
    }

    @NotNull
    public final MutableState<Crop> getDraggingCrop() {
        return this.draggingCrop;
    }

    @NotNull
    public final State<Crop> getCropSettings() {
        return this.cropSettings;
    }

    @NotNull
    public final UIContainer getRetainedImage() {
        return (UIContainer)this.retainedImage$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @NotNull
    public final VectorEditingOverlay getVectorEditingOverlay() {
        return this.vectorEditingOverlay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final CompletableFuture<File> exportImage(@NotNull ScreenshotId source, @NotNull IScreenshotManager screenshotManager, boolean temp, boolean favorite) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)screenshotManager, (String)"screenshotManager");
        Crop cropSettings2 = this.cropSettings.getUntracked();
        CompletableFuture<File> completableFuture = new CompletableFuture<File>();
        Closeable closeable = source.open();
        Throwable throwable = null;
        try {
            BufferedImage bufferedImage;
            Object it = (InputStream)closeable;
            boolean bl = false;
            try {
                BufferedImage bufferedImage2 = bufferedImage = ImageIO.read((InputStream)it);
                if (bufferedImage2 == null) {
                    throw new IOException("Failed to load original image from " + source);
                }
                Intrinsics.checkNotNull((Object)bufferedImage2);
            }
            catch (Exception e) {
                completableFuture.completeExceptionally(e);
                CompletableFuture<File> completableFuture2 = completableFuture;
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                return completableFuture2;
            }
            it = bufferedImage;
        }
        catch (Throwable it) {
            throwable = it;
            throw it;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Object screenshot = it;
        int fullWidth = ((BufferedImage)screenshot).getWidth();
        int fullHeight = ((BufferedImage)screenshot).getHeight();
        int drawableWidth = (int)this.screenshotDisplay.getWidth() * (int)UResolution.getScaleFactor();
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)(fullWidth * fullHeight * 4));
        VectorEditingOverlay vectorEditingOverlay = this.vectorEditingOverlay;
        VectorEditingOverlay veoCopy2 = new VectorEditingOverlay(this, buffer, vectorEditingOverlay){
            final /* synthetic */ FloatBuffer $buffer;
            {
                this.$buffer = $buffer;
                super($receiver, $super_call_param$1);
            }

            protected void render(@NotNull UMatrixStack matrixStack, float width2, float height2) {
                Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
                super.render(matrixStack, width2, height2);
                GL11.glReadPixels((int)0, (int)0, (int)((int)width2), (int)((int)height2), (int)6408, (int)5126, (FloatBuffer)this.$buffer);
            }
        };
        veoCopy2.setScale((float)fullWidth / (float)drawableWidth);
        veoCopy2.drawFrameBuffer((double)fullWidth / UResolution.getScaleFactor(), (double)fullHeight / UResolution.getScaleFactor());
        veoCopy2.delete();
        Dispatchers.getIO().dispatch((CoroutineContext)EmptyCoroutineContext.INSTANCE, () -> ScreenshotCanvas.exportImage$lambda$7(buffer, fullWidth, fullHeight, (BufferedImage)screenshot, cropSettings2, temp, completableFuture, screenshotManager, source, favorite));
        return completableFuture;
    }

    public static /* synthetic */ CompletableFuture exportImage$default(ScreenshotCanvas screenshotCanvas, ScreenshotId screenshotId, IScreenshotManager iScreenshotManager, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 8) != 0) {
            bl2 = false;
        }
        return screenshotCanvas.exportImage(screenshotId, iScreenshotManager, bl, bl2);
    }

    @NotNull
    public final Pair<Float, Float> getRelativeMousePosition(float mouseX, float mouseY) {
        float width2 = this.screenshotDisplay.getWidth();
        float height2 = this.screenshotDisplay.getHeight();
        return TuplesKt.to((Object)RangesKt.coerceIn((Comparable)Float.valueOf(mouseX / width2), (ClosedFloatingPointRange)RangesKt.rangeTo((float)0.0f, (float)1.0f)), (Object)RangesKt.coerceIn((Comparable)Float.valueOf(mouseY / height2), (ClosedFloatingPointRange)RangesKt.rangeTo((float)0.0f, (float)1.0f)));
    }

    /*
     * WARNING - void declaration
     */
    private static final void exportImage$lambda$7(FloatBuffer $buffer, int $fullWidth, int $fullHeight, BufferedImage $screenshot, Crop $cropSettings, boolean $temp, CompletableFuture $completableFuture, IScreenshotManager $screenshotManager, ScreenshotId $source, boolean $favorite) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$screenshot, (String)"$screenshot");
        Intrinsics.checkNotNullParameter((Object)$cropSettings, (String)"$cropSettings");
        Intrinsics.checkNotNullParameter((Object)$completableFuture, (String)"$completableFuture");
        Intrinsics.checkNotNullParameter((Object)$screenshotManager, (String)"$screenshotManager");
        Intrinsics.checkNotNullParameter((Object)$source, (String)"$source");
        $buffer.rewind();
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)$buffer.limit());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void i2;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((int)($buffer.get((int)i2) * 255.0f));
        }
        int[] imgData2 = CollectionsKt.toIntArray((Collection)CollectionsKt.flatten((Iterable)CollectionsKt.reversed((Iterable)CollectionsKt.chunked((Iterable)((List)destination$iv$iv), (int)($fullWidth * 4), (Function1)exportImage.1.imgData.2.INSTANCE))));
        BufferedImage image2 = new BufferedImage($fullWidth, $fullHeight, 2);
        image2.setRGB(0, 0, $fullWidth, $fullHeight, imgData2, 0, $fullWidth);
        $screenshot.getGraphics().drawImage(image2, 0, 0, null);
        int left2 = (int)((float)$fullWidth * $cropSettings.getLeft());
        int right = (int)((float)$fullWidth * $cropSettings.getRight());
        int top = (int)((float)$fullHeight * $cropSettings.getTop());
        int bottom = (int)((float)$fullHeight * $cropSettings.getBottom());
        BufferedImage croppedImage = $screenshot.getSubimage(left2, top, right - left2, bottom - top);
        if ($temp) {
            File tempFile = File.createTempFile("screenshot", null);
            ImageIO.write((RenderedImage)croppedImage, "png", tempFile);
            $completableFuture.complete(tempFile);
        } else {
            ClientScreenshotMetadata clientScreenshotMetadata;
            ScreenshotId screenshotId = $source;
            if (screenshotId instanceof LocalScreenshot) {
                clientScreenshotMetadata = $screenshotManager.getScreenshotMetadataManager().getOrCreateMetadata(((LocalScreenshot)$source).getPath());
            } else if (screenshotId instanceof RemoteScreenshot) {
                clientScreenshotMetadata = new ClientScreenshotMetadata(((RemoteScreenshot)$source).getMedia());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Intrinsics.checkNotNull((Object)croppedImage);
            $completableFuture.complete($screenshotManager.handleScreenshotEdited($source, clientScreenshotMetadata, croppedImage, $favorite));
        }
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ScreenshotCanvas.class, "retainedImage", "getRetainedImage()Lgg/essential/elementa/components/UIContainer;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\tR\u0011\u0010\u000f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\t\u00a8\u0006\u001e"}, d2={"Lgg/essential/gui/screenshot/editor/ScreenshotCanvas$Crop;", "", "left", "", "right", "top", "bottom", "(FFFF)V", "getBottom", "()F", "height", "getHeight", "getLeft", "getRight", "getTop", "width", "getWidth", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "essential-gui-essential"})
    public static final class Crop {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final float left;
        private final float right;
        private final float top;
        private final float bottom;
        private final float width;
        private final float height;
        @NotNull
        private static final Crop DEFAULT = new Crop(0.0f, 1.0f, 0.0f, 1.0f);

        public Crop(float left2, float right, float top, float bottom) {
            this.left = left2;
            this.right = right;
            this.top = top;
            this.bottom = bottom;
            this.width = this.right - this.left;
            this.height = this.bottom - this.top;
        }

        public final float getLeft() {
            return this.left;
        }

        public final float getRight() {
            return this.right;
        }

        public final float getTop() {
            return this.top;
        }

        public final float getBottom() {
            return this.bottom;
        }

        public final float getWidth() {
            return this.width;
        }

        public final float getHeight() {
            return this.height;
        }

        public final float component1() {
            return this.left;
        }

        public final float component2() {
            return this.right;
        }

        public final float component3() {
            return this.top;
        }

        public final float component4() {
            return this.bottom;
        }

        @NotNull
        public final Crop copy(float left2, float right, float top, float bottom) {
            return new Crop(left2, right, top, bottom);
        }

        public static /* synthetic */ Crop copy$default(Crop crop, float f, float f2, float f3, float f4, int n, Object object) {
            if ((n & 1) != 0) {
                f = crop.left;
            }
            if ((n & 2) != 0) {
                f2 = crop.right;
            }
            if ((n & 4) != 0) {
                f3 = crop.top;
            }
            if ((n & 8) != 0) {
                f4 = crop.bottom;
            }
            return crop.copy(f, f2, f3, f4);
        }

        @NotNull
        public String toString() {
            return "Crop(left=" + this.left + ", right=" + this.right + ", top=" + this.top + ", bottom=" + this.bottom + ')';
        }

        public int hashCode() {
            int result = Float.hashCode(this.left);
            result = result * 31 + Float.hashCode(this.right);
            result = result * 31 + Float.hashCode(this.top);
            result = result * 31 + Float.hashCode(this.bottom);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Crop)) {
                return false;
            }
            Crop crop = (Crop)other;
            if (Float.compare(this.left, crop.left) != 0) {
                return false;
            }
            if (Float.compare(this.right, crop.right) != 0) {
                return false;
            }
            if (Float.compare(this.top, crop.top) != 0) {
                return false;
            }
            return Float.compare(this.bottom, crop.bottom) == 0;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lgg/essential/gui/screenshot/editor/ScreenshotCanvas$Crop$Companion;", "", "()V", "DEFAULT", "Lgg/essential/gui/screenshot/editor/ScreenshotCanvas$Crop;", "getDEFAULT", "()Lgg/essential/gui/screenshot/editor/ScreenshotCanvas$Crop;", "essential-gui-essential"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Crop getDEFAULT() {
                return DEFAULT;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010 \n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B3\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00000\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001a\u00a8\u0006\u001b"}, d2={"Lgg/essential/gui/screenshot/editor/ScreenshotCanvas$CropAlignment;", "", "alignOpX", "", "alignOpY", "centerX", "centerY", "corner", "(Ljava/lang/String;IZZZZZ)V", "getAlignOpX", "()Z", "getAlignOpY", "getCenterX", "getCenterY", "getCorner", "sides", "", "getSides", "()Ljava/util/List;", "TOP_LEFT", "TOP_CENTER", "TOP_RIGHT", "RIGHT_CENTER", "BOTTOM_RIGHT", "BOTTOM_CENTER", "BOTTOM_LEFT", "LEFT_CENTER", "essential-gui-essential"})
    public static final class CropAlignment
    extends Enum<CropAlignment> {
        private final boolean alignOpX;
        private final boolean alignOpY;
        private final boolean centerX;
        private final boolean centerY;
        private final boolean corner;
        public static final /* enum */ CropAlignment TOP_LEFT = new CropAlignment("TOP_LEFT", 0, false, false, false, false, true, 12, null);
        public static final /* enum */ CropAlignment TOP_CENTER = new CropAlignment("TOP_CENTER", 1, false, false, true, false, false, 8, null);
        public static final /* enum */ CropAlignment TOP_RIGHT = new CropAlignment("TOP_RIGHT", 2, true, false, false, false, true, 12, null);
        public static final /* enum */ CropAlignment RIGHT_CENTER = new CropAlignment("RIGHT_CENTER", 3, true, false, false, true, false, 4, null);
        public static final /* enum */ CropAlignment BOTTOM_RIGHT = new CropAlignment("BOTTOM_RIGHT", 4, true, true, false, false, true, 12, null);
        public static final /* enum */ CropAlignment BOTTOM_CENTER = new CropAlignment("BOTTOM_CENTER", 5, false, true, true, false, false, 8, null);
        public static final /* enum */ CropAlignment BOTTOM_LEFT = new CropAlignment("BOTTOM_LEFT", 6, false, true, false, false, true, 12, null);
        public static final /* enum */ CropAlignment LEFT_CENTER = new CropAlignment("LEFT_CENTER", 7, false, false, false, true, false, 4, null);
        private static final /* synthetic */ CropAlignment[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private CropAlignment(boolean alignOpX, boolean alignOpY, boolean centerX, boolean centerY, boolean corner) {
            this.alignOpX = alignOpX;
            this.alignOpY = alignOpY;
            this.centerX = centerX;
            this.centerY = centerY;
            this.corner = corner;
        }

        /* synthetic */ CropAlignment(String string, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                bl3 = false;
            }
            if ((n2 & 8) != 0) {
                bl4 = false;
            }
            this(bl, bl2, bl3, bl4, bl5);
        }

        public final boolean getAlignOpX() {
            return this.alignOpX;
        }

        public final boolean getAlignOpY() {
            return this.alignOpY;
        }

        public final boolean getCenterX() {
            return this.centerX;
        }

        public final boolean getCenterY() {
            return this.centerY;
        }

        public final boolean getCorner() {
            return this.corner;
        }

        @NotNull
        public final List<CropAlignment> getSides() {
            List list;
            switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                case 1: {
                    CropAlignment[] cropAlignmentArray = new CropAlignment[]{TOP_CENTER, LEFT_CENTER};
                    list = CollectionsKt.listOf((Object[])cropAlignmentArray);
                    break;
                }
                case 2: {
                    CropAlignment[] cropAlignmentArray = new CropAlignment[]{TOP_CENTER, RIGHT_CENTER};
                    list = CollectionsKt.listOf((Object[])cropAlignmentArray);
                    break;
                }
                case 3: {
                    CropAlignment[] cropAlignmentArray = new CropAlignment[]{BOTTOM_CENTER, LEFT_CENTER};
                    list = CollectionsKt.listOf((Object[])cropAlignmentArray);
                    break;
                }
                case 4: {
                    CropAlignment[] cropAlignmentArray = new CropAlignment[]{BOTTOM_CENTER, RIGHT_CENTER};
                    list = CollectionsKt.listOf((Object[])cropAlignmentArray);
                    break;
                }
                default: {
                    list = CollectionsKt.listOf((Object)((Object)this));
                }
            }
            return list;
        }

        public static CropAlignment[] values() {
            return (CropAlignment[])$VALUES.clone();
        }

        public static CropAlignment valueOf(String value) {
            return Enum.valueOf(CropAlignment.class, value);
        }

        @NotNull
        public static EnumEntries<CropAlignment> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = cropAlignmentArray = new CropAlignment[]{CropAlignment.TOP_LEFT, CropAlignment.TOP_CENTER, CropAlignment.TOP_RIGHT, CropAlignment.RIGHT_CENTER, CropAlignment.BOTTOM_RIGHT, CropAlignment.BOTTOM_CENTER, CropAlignment.BOTTOM_LEFT, CropAlignment.LEFT_CENTER};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[CropAlignment.values().length];
                try {
                    nArray[CropAlignment.TOP_LEFT.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CropAlignment.TOP_RIGHT.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CropAlignment.BOTTOM_LEFT.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CropAlignment.BOTTOM_RIGHT.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\b\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\f\u00a8\u0006\u0010"}, d2={"Lgg/essential/gui/screenshot/editor/ScreenshotCanvas$ImageCropItem;", "Lgg/essential/elementa/components/UIContainer;", "alignment", "Lgg/essential/gui/screenshot/editor/ScreenshotCanvas$CropAlignment;", "(Lgg/essential/gui/screenshot/editor/ScreenshotCanvas;Lgg/essential/gui/screenshot/editor/ScreenshotCanvas$CropAlignment;)V", "getAlignment", "()Lgg/essential/gui/screenshot/editor/ScreenshotCanvas$CropAlignment;", "xDragOffset", "", "getXDragOffset", "()F", "setXDragOffset", "(F)V", "yDragOffset", "getYDragOffset", "setYDragOffset", "essential-gui-essential"})
    @SourceDebugExtension(value={"SMAP\nScreenshotCanvas.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScreenshotCanvas.kt\ngg/essential/gui/screenshot/editor/ScreenshotCanvas$ImageCropItem\n+ 2 components.kt\ngg/essential/elementa/dsl/ComponentsKt\n*L\n1#1,414:1\n9#2,3:415\n13#2,2:418\n9#2,3:420\n15#2:423\n13#2,2:424\n9#2,3:426\n15#2:429\n13#2,2:430\n9#2,3:432\n15#2:435\n*S KotlinDebug\n*F\n+ 1 ScreenshotCanvas.kt\ngg/essential/gui/screenshot/editor/ScreenshotCanvas$ImageCropItem\n*L\n271#1:415,3\n287#1:418,2\n288#1:420,3\n287#1:423\n295#1:424,2\n296#1:426,3\n295#1:429\n304#1:430,2\n305#1:432,3\n304#1:435\n*E\n"})
    public final class ImageCropItem
    extends UIContainer {
        @NotNull
        private final CropAlignment alignment;
        private float xDragOffset;
        private float yDragOffset;

        /*
         * WARNING - void declaration
         */
        public ImageCropItem(CropAlignment alignment) {
            UIComponent $this$addChild_u24lambda_u241$iv;
            UIComponent $this$addChild$iv;
            void $this$constrain$iv;
            void var6_10;
            Intrinsics.checkNotNullParameter((Object)((Object)alignment), (String)"alignment");
            this.alignment = alignment;
            UIComponent uIComponent = this;
            ScreenshotCanvas screenshotCanvas = ScreenshotCanvas.this;
            boolean $i$f$constrain = false;
            void $this$constrain_u24lambda_u240$iv = var6_10 = $this$constrain$iv;
            boolean bl4 = false;
            UIConstraints $this$_init__u24lambda_u240 = $this$constrain_u24lambda_u240$iv.getConstraints();
            boolean bl2 = false;
            $this$_init__u24lambda_u240.setHeight(UtilitiesKt.pixels$default(15, false, false, 3, null));
            $this$_init__u24lambda_u240.setWidth(UtilitiesKt.pixels$default(15, false, false, 3, null));
            $this$_init__u24lambda_u240.setX((XConstraint)ConstraintsKt.boundTo((SuperConstraint)(this.alignment.getCenterX() ? (PositionConstraint)new CenterConstraint() : (PositionConstraint)UtilitiesKt.pixels$default(-screenshotCanvas.padding, this.alignment.getAlignOpX(), false, 2, null)), screenshotCanvas.getRetainedImage()));
            $this$_init__u24lambda_u240.setY((YConstraint)ConstraintsKt.boundTo((SuperConstraint)(this.alignment.getCenterY() ? (PositionConstraint)new CenterConstraint() : (PositionConstraint)UtilitiesKt.pixels$default(-screenshotCanvas.padding, this.alignment.getAlignOpY(), false, 2, null)), screenshotCanvas.getRetainedImage()));
            if (this.alignment.getCorner()) {
                void $this$_init__u24lambda_u244;
                ImageCropItem $this$_init__u24lambda_u242;
                UIComponent uIComponent2;
                UIComponent uIComponent3;
                $this$addChild$iv = this;
                boolean $i$f$addChild = false;
                $this$addChild_u24lambda_u241$iv = uIComponent3 = $this$addChild$iv;
                boolean bl3 = false;
                ImageCropItem bl4 = (ImageCropItem)$this$addChild_u24lambda_u241$iv;
                UIComponent uIComponent4 = $this$addChild_u24lambda_u241$iv;
                boolean bl5 = false;
                UIComponent $this$constrain$iv2 = new UIBlock(EssentialPalette.TEXT);
                boolean $i$f$constrain2 = false;
                UIComponent $this$constrain_u24lambda_u240$iv2 = uIComponent2 = $this$constrain$iv2;
                boolean $i$a$-apply-ComponentsKt$constrain$1$iv2 = false;
                UIConstraints $this$lambda_u242_u24lambda_u241 = $this$constrain_u24lambda_u240$iv2.getConstraints();
                boolean bl6 = false;
                $this$lambda_u242_u24lambda_u241.setX(UtilitiesKt.pixels($this$_init__u24lambda_u242.alignment.getAlignOpX() ? 0 : 0, false, false));
                $this$lambda_u242_u24lambda_u241.setY(UtilitiesKt.pixels(0, $this$_init__u24lambda_u242.alignment.getAlignOpY(), false));
                $this$lambda_u242_u24lambda_u241.setWidth(UtilitiesKt.pixels$default(15, false, false, 3, null));
                $this$lambda_u242_u24lambda_u241.setHeight(UtilitiesKt.pixels$default(2, false, false, 3, null));
                uIComponent4.addChild(uIComponent2);
                $this$addChild$iv = this;
                $i$f$addChild = false;
                $this$addChild_u24lambda_u241$iv = uIComponent3 = $this$addChild$iv;
                bl3 = false;
                $this$_init__u24lambda_u242 = (ImageCropItem)$this$addChild_u24lambda_u241$iv;
                uIComponent4 = $this$addChild_u24lambda_u241$iv;
                boolean bl7 = false;
                $this$constrain$iv2 = new UIBlock(EssentialPalette.TEXT);
                $i$f$constrain2 = false;
                $this$constrain_u24lambda_u240$iv2 = uIComponent2 = $this$constrain$iv2;
                $i$a$-apply-ComponentsKt$constrain$1$iv2 = false;
                UIConstraints $this$lambda_u244_u24lambda_u243 = $this$constrain_u24lambda_u240$iv2.getConstraints();
                boolean bl8 = false;
                $this$lambda_u244_u24lambda_u243.setX(UtilitiesKt.pixels(0, $this$_init__u24lambda_u244.alignment.getAlignOpX(), false));
                $this$lambda_u244_u24lambda_u243.setY(UtilitiesKt.pixels($this$_init__u24lambda_u244.alignment.getAlignOpY() ? 0 : 0, false, false));
                $this$lambda_u244_u24lambda_u243.setWidth(UtilitiesKt.pixels$default(2, false, false, 3, null));
                $this$lambda_u244_u24lambda_u243.setHeight(UtilitiesKt.pixels$default(15, false, false, 3, null));
                uIComponent4.addChild(uIComponent2);
            } else {
                void $this$_init__u24lambda_u246;
                UIComponent uIComponent5;
                UIComponent uIComponent6;
                $this$addChild$iv = this;
                boolean $i$f$addChild = false;
                $this$addChild_u24lambda_u241$iv = uIComponent6 = $this$addChild$iv;
                boolean bl9 = false;
                ImageCropItem $this$_init__u24lambda_u244 = (ImageCropItem)$this$addChild_u24lambda_u241$iv;
                UIComponent uIComponent7 = $this$addChild_u24lambda_u241$iv;
                boolean bl10 = false;
                UIComponent $this$constrain$iv3 = new UIBlock(EssentialPalette.TEXT);
                boolean $i$f$constrain3 = false;
                UIComponent $this$constrain_u24lambda_u240$iv3 = uIComponent5 = $this$constrain$iv3;
                boolean $i$a$-apply-ComponentsKt$constrain$1$iv3 = false;
                UIConstraints $this$lambda_u246_u24lambda_u245 = $this$constrain_u24lambda_u240$iv3.getConstraints();
                boolean bl11 = false;
                $this$lambda_u246_u24lambda_u245.setX(UtilitiesKt.pixels(0, $this$_init__u24lambda_u246.alignment.getAlignOpX(), false));
                $this$lambda_u246_u24lambda_u245.setY(UtilitiesKt.pixels(0, $this$_init__u24lambda_u246.alignment.getAlignOpY(), false));
                $this$lambda_u246_u24lambda_u245.setHeight(UtilitiesKt.pixels$default($this$_init__u24lambda_u246.alignment.getCenterY() ? 15 : 2, false, false, 3, null));
                $this$lambda_u246_u24lambda_u245.setWidth(UtilitiesKt.pixels$default($this$_init__u24lambda_u246.alignment.getCenterX() ? 15 : 2, false, false, 3, null));
                uIComponent7.addChild(uIComponent5);
            }
            this.onMouseEnter((Function1<? super UIComponent, Unit>)((Function1)5.INSTANCE));
            this.onMouseLeave((Function1<? super UIComponent, Unit>)((Function1)6.INSTANCE));
            Ref.ObjectRef currDragStart = new Ref.ObjectRef();
            this.onMouseClick((Function2<? super UIComponent, ? super UIClickEvent, Unit>)((Function2)new Function2<UIComponent, UIClickEvent, Unit>((Ref.ObjectRef<Crop>)currDragStart, ScreenshotCanvas.this, this){
                final /* synthetic */ Ref.ObjectRef<Crop> $currDragStart;
                final /* synthetic */ ScreenshotCanvas this$0;
                final /* synthetic */ ImageCropItem this$1;
                {
                    this.$currDragStart = $currDragStart;
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(2);
                }

                public final void invoke(@NotNull UIComponent $this$onMouseClick, @NotNull UIClickEvent it) {
                    Intrinsics.checkNotNullParameter((Object)$this$onMouseClick, (String)"$this$onMouseClick");
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$currDragStart.element = this.this$0.getCropSettings().getUntracked();
                    this.this$0.getDraggingCrop().set((Crop)this.$currDragStart.element);
                    this.this$1.setXDragOffset(it.getRelativeX() + (float)(this.this$1.getAlignment().getAlignOpX() ? this.this$0.padding : -this.this$0.padding));
                    this.this$1.setYDragOffset(it.getRelativeY() + (float)(this.this$1.getAlignment().getAlignOpY() ? this.this$0.padding : -this.this$0.padding));
                }
            }));
            this.onMouseRelease((Function1<? super UIComponent, Unit>)((Function1)new Function1<UIComponent, Unit>((Ref.ObjectRef<Crop>)currDragStart, ScreenshotCanvas.this){
                final /* synthetic */ Ref.ObjectRef<Crop> $currDragStart;
                final /* synthetic */ ScreenshotCanvas this$0;
                {
                    this.$currDragStart = $currDragStart;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull UIComponent $this$onMouseRelease) {
                    Intrinsics.checkNotNullParameter((Object)$this$onMouseRelease, (String)"$this$onMouseRelease");
                    Crop crop = (Crop)this.$currDragStart.element;
                    if (crop == null) {
                        return;
                    }
                    Crop oldCrop = crop;
                    Crop crop2 = (Crop)this.this$0.getDraggingCrop().getUntracked();
                    if (crop2 == null) {
                        return;
                    }
                    Crop newCrop = crop2;
                    if (!Intrinsics.areEqual((Object)oldCrop, (Object)newCrop)) {
                        this.this$0.getEditHistory().pushChange(new CropChange(oldCrop, newCrop));
                    }
                    this.this$0.getDraggingCrop().set((Crop)null);
                    this.$currDragStart.element = null;
                }
            }));
            this.onMouseDrag((Function4<? super UIComponent, ? super Float, ? super Float, ? super Integer, Unit>)((Function4)new Function4<UIComponent, Float, Float, Integer, Unit>((Ref.ObjectRef<Crop>)currDragStart, this, ScreenshotCanvas.this){
                final /* synthetic */ Ref.ObjectRef<Crop> $currDragStart;
                final /* synthetic */ ImageCropItem this$0;
                final /* synthetic */ ScreenshotCanvas this$1;
                {
                    this.$currDragStart = $currDragStart;
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(4);
                }

                public final void invoke(@NotNull UIComponent $this$onMouseDrag, float f, float f2, int n) {
                    Intrinsics.checkNotNullParameter((Object)$this$onMouseDrag, (String)"$this$onMouseDrag");
                    if (this.$currDragStart.element != null) {
                        Pair pair = this.this$0.getMousePosition();
                        float mouseX = ((Number)pair.component1()).floatValue();
                        float mouseY = ((Number)pair.component2()).floatValue();
                        float relativeX = mouseX - this.this$1.getScreenshotDisplay().getLeft();
                        float relativeY = mouseY - this.this$1.getScreenshotDisplay().getTop();
                        float adjustedMouseX = this.this$0.getAlignment().getAlignOpX() ? relativeX + ($this$onMouseDrag.getWidth() - this.this$0.getXDragOffset()) : relativeX - this.this$0.getXDragOffset();
                        float adjustedMouseY = this.this$0.getAlignment().getAlignOpY() ? relativeY + ($this$onMouseDrag.getHeight() - this.this$0.getYDragOffset()) : relativeY - this.this$0.getYDragOffset();
                        Pair<Float, Float> pair2 = this.this$1.getRelativeMousePosition(adjustedMouseX, adjustedMouseY);
                        float x = ((Number)pair2.component1()).floatValue();
                        float y = ((Number)pair2.component2()).floatValue();
                        float minSize = 0.1f;
                        Object t = this.this$1.getDraggingCrop().getUntracked();
                        Intrinsics.checkNotNull(t);
                        Crop crop = (Crop)t;
                        for (CropAlignment side : this.this$0.getAlignment().getSides()) {
                            Crop crop2;
                            switch (WhenMappings.$EnumSwitchMapping$0[side.ordinal()]) {
                                case 1: {
                                    crop2 = Crop.copy$default(crop, 0.0f, 0.0f, RangesKt.coerceAtMost((float)y, (float)(crop.getBottom() - minSize)), 0.0f, 11, null);
                                    break;
                                }
                                case 2: {
                                    crop2 = Crop.copy$default(crop, 0.0f, RangesKt.coerceAtLeast((float)x, (float)(crop.getLeft() + minSize)), 0.0f, 0.0f, 13, null);
                                    break;
                                }
                                case 3: {
                                    crop2 = Crop.copy$default(crop, 0.0f, 0.0f, 0.0f, RangesKt.coerceAtLeast((float)y, (float)(crop.getTop() + minSize)), 7, null);
                                    break;
                                }
                                case 4: {
                                    crop2 = Crop.copy$default(crop, RangesKt.coerceAtMost((float)x, (float)(crop.getRight() - minSize)), 0.0f, 0.0f, 0.0f, 14, null);
                                    break;
                                }
                                default: {
                                    throw new AssertionError((Object)"unreachable");
                                }
                            }
                            crop = crop2;
                        }
                        this.this$1.getDraggingCrop().set(crop);
                        $this$onMouseDrag.animationFrame();
                    }
                }

                @Metadata(mv={1, 9, 0}, k=3, xi=48)
                public final class WhenMappings {
                    public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                    static {
                        int[] nArray = new int[CropAlignment.values().length];
                        try {
                            nArray[CropAlignment.TOP_CENTER.ordinal()] = 1;
                        }
                        catch (NoSuchFieldError noSuchFieldError) {
                            // empty catch block
                        }
                        try {
                            nArray[CropAlignment.RIGHT_CENTER.ordinal()] = 2;
                        }
                        catch (NoSuchFieldError noSuchFieldError) {
                            // empty catch block
                        }
                        try {
                            nArray[CropAlignment.BOTTOM_CENTER.ordinal()] = 3;
                        }
                        catch (NoSuchFieldError noSuchFieldError) {
                            // empty catch block
                        }
                        try {
                            nArray[CropAlignment.LEFT_CENTER.ordinal()] = 4;
                        }
                        catch (NoSuchFieldError noSuchFieldError) {
                            // empty catch block
                        }
                        $EnumSwitchMapping$0 = nArray;
                    }
                }
            }));
        }

        @NotNull
        public final CropAlignment getAlignment() {
            return this.alignment;
        }

        public final float getXDragOffset() {
            return this.xDragOffset;
        }

        public final void setXDragOffset(float f) {
            this.xDragOffset = f;
        }

        public final float getYDragOffset() {
            return this.yDragOffset;
        }

        public final void setYDragOffset(float f) {
            this.yDragOffset = f;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0096\u0004\u0018\u00002\u00020\u0001B\u0013\b\u0016\u0012\n\u0010\u0002\u001a\u00060\u0000R\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J(\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\fH\u0014R\u0019\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lgg/essential/gui/screenshot/editor/ScreenshotCanvas$VectorEditingOverlay;", "Lgg/essential/gui/common/UINanoVG;", "veo", "Lgg/essential/gui/screenshot/editor/ScreenshotCanvas;", "(Lgg/essential/gui/screenshot/editor/ScreenshotCanvas;Lgg/essential/gui/screenshot/editor/ScreenshotCanvas$VectorEditingOverlay;)V", "image", "Lgg/essential/gui/elementa/state/v2/State;", "Lgg/essential/util/UIdentifier;", "(Lgg/essential/gui/screenshot/editor/ScreenshotCanvas;Lgg/essential/gui/elementa/state/v2/State;)V", "getImage", "()Lgg/essential/gui/elementa/state/v2/State;", "scale", "", "getScale", "()F", "setScale", "(F)V", "screenshotImage", "Lgg/essential/gui/screenshot/image/ScreenshotImage;", "draw", "", "matrixStack", "Lgg/essential/universal/UMatrixStack;", "renderVG", "vg", "Lgg/essential/util/lwjgl3/api/nanovg/NanoVG;", "width", "height", "essential-gui-essential"})
    @SourceDebugExtension(value={"SMAP\nScreenshotCanvas.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScreenshotCanvas.kt\ngg/essential/gui/screenshot/editor/ScreenshotCanvas$VectorEditingOverlay\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,414:1\n800#2,11:415\n1855#2,2:426\n*S KotlinDebug\n*F\n+ 1 ScreenshotCanvas.kt\ngg/essential/gui/screenshot/editor/ScreenshotCanvas$VectorEditingOverlay\n*L\n158#1:415,11\n158#1:426,2\n*E\n"})
    public class VectorEditingOverlay
    extends UINanoVG {
        @NotNull
        private final State<UIdentifier> image;
        @NotNull
        private final ScreenshotImage screenshotImage;
        private float scale;
        final /* synthetic */ ScreenshotCanvas this$0;

        public VectorEditingOverlay(@NotNull ScreenshotCanvas this$0, State<UIdentifier> image2) {
            Intrinsics.checkNotNullParameter(image2, (String)"image");
            this.this$0 = this$0;
            this.image = image2;
            this.screenshotImage = new ScreenshotImage(this.image);
            this.scale = 1.0f;
            StateKt.onChange(this.image, this, (Function2)new Function2<Observer, UIdentifier, Unit>(){

                public final void invoke(@NotNull Observer $this$onChange, @Nullable UIdentifier it) {
                    Intrinsics.checkNotNullParameter((Object)$this$onChange, (String)"$this$onChange");
                    this.markDirty();
                }
            });
            StateKt.onChange((State)this.this$0.getEditHistory().getHistory(), this, (Function2)new Function2<Observer, MutableTrackedList<Change>, Unit>(){

                public final void invoke(@NotNull Observer $this$onChange, @NotNull MutableTrackedList<Change> it) {
                    Intrinsics.checkNotNullParameter((Object)$this$onChange, (String)"$this$onChange");
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    this.markDirty();
                }
            });
        }

        @NotNull
        public final State<UIdentifier> getImage() {
            return this.image;
        }

        public final float getScale() {
            return this.scale;
        }

        public final void setScale(float f) {
            this.scale = f;
        }

        public VectorEditingOverlay(@NotNull ScreenshotCanvas this$0, VectorEditingOverlay veo) {
            Intrinsics.checkNotNullParameter((Object)veo, (String)"veo");
            this(this$0, veo.image);
        }

        @Override
        public void draw(@NotNull UMatrixStack matrixStack) {
            Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
            matrixStack.push();
            matrixStack.translate(this.getLeft(), this.getTop(), 0.0f);
            Color color2 = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"WHITE");
            this.screenshotImage.renderImage(matrixStack, color2, this.getWidth(), this.getHeight());
            matrixStack.pop();
            super.draw(matrixStack);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void renderVG(@NotNull UMatrixStack matrixStack, @NotNull NanoVG vg, float width2, float height2) {
            void $this$forEach$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
            Intrinsics.checkNotNullParameter((Object)vg, (String)"vg");
            Iterable $this$filterIsInstance$iv = (Iterable)this.this$0.getEditHistory().getHistory().getUntracked();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof VectorStroke)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VectorStroke vs = (VectorStroke)element$iv;
                boolean bl = false;
                vs.render(vg, width2, height2, this.scale);
            }
        }
    }
}

