/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.screenshot.providers;

import gg.essential.gui.screenshot.LocalScreenshot;
import gg.essential.gui.screenshot.RemoteScreenshot;
import gg.essential.gui.screenshot.ScreenshotId;
import gg.essential.gui.screenshot.downsampling.BufferBackedImage;
import gg.essential.gui.screenshot.downsampling.ErrorImage;
import gg.essential.gui.screenshot.downsampling.PixelBuffer;
import gg.essential.gui.screenshot.providers.WindowProviderKt;
import gg.essential.gui.screenshot.providers.WindowedProvider;
import gg.essential.util.lwjgl3.api.ImageData;
import gg.essential.util.lwjgl3.api.NativeImageReader;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J0\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\n2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0017H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lgg/essential/gui/screenshot/providers/DiskWindowedImageProvider;", "Lgg/essential/gui/screenshot/providers/WindowedProvider;", "Lgg/essential/gui/screenshot/downsampling/PixelBuffer;", "Lgg/essential/gui/screenshot/providers/WindowedImageProvider;", "nativeImageReader", "Lgg/essential/util/lwjgl3/api/NativeImageReader;", "allocator", "Lio/netty/buffer/ByteBufAllocator;", "(Lgg/essential/util/lwjgl3/api/NativeImageReader;Lio/netty/buffer/ByteBufAllocator;)V", "items", "", "Lgg/essential/gui/screenshot/ScreenshotId;", "getItems", "()Ljava/util/List;", "setItems", "(Ljava/util/List;)V", "loadImage", "id", "provide", "", "windows", "Lgg/essential/gui/screenshot/providers/WindowedProvider$Window;", "optional", "", "essential-gui-essential"})
@SourceDebugExtension(value={"SMAP\nDiskWindowedImageProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiskWindowedImageProvider.kt\ngg/essential/gui/screenshot/providers/DiskWindowedImageProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,66:1\n1#2:67\n*E\n"})
public final class DiskWindowedImageProvider
implements WindowedProvider<PixelBuffer> {
    @NotNull
    private final NativeImageReader nativeImageReader;
    @NotNull
    private final ByteBufAllocator allocator;
    @NotNull
    private List<? extends ScreenshotId> items;

    public DiskWindowedImageProvider(@NotNull NativeImageReader nativeImageReader, @NotNull ByteBufAllocator allocator2) {
        Intrinsics.checkNotNullParameter((Object)nativeImageReader, (String)"nativeImageReader");
        Intrinsics.checkNotNullParameter((Object)allocator2, (String)"allocator");
        this.nativeImageReader = nativeImageReader;
        this.allocator = allocator2;
        this.items = CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public List<ScreenshotId> getItems() {
        return this.items;
    }

    @Override
    public void setItems(@NotNull List<? extends ScreenshotId> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.items = list;
    }

    @Override
    @NotNull
    public Map<ScreenshotId, PixelBuffer> provide(@NotNull List<WindowedProvider.Window> windows, @NotNull Set<? extends ScreenshotId> optional) {
        Intrinsics.checkNotNullParameter(windows, (String)"windows");
        Intrinsics.checkNotNullParameter(optional, (String)"optional");
        Map map2 = new LinkedHashMap();
        block0: for (WindowedProvider.Window window : windows) {
            IntProgression intProgression = WindowProviderKt.reversed(window.getRange(), window.getBackwards());
            int i2 = intProgression.getFirst();
            int n = intProgression.getLast();
            int n2 = intProgression.getStep();
            if ((n2 <= 0 || i2 > n) && (n2 >= 0 || n > i2)) continue;
            while (true) {
                ScreenshotId path;
                if (!optional.contains(path = this.getItems().get(i2))) {
                    map2.put(path, this.loadImage(path));
                }
                if (i2 == n) continue block0;
                i2 += n2;
            }
        }
        return map2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final PixelBuffer loadImage(ScreenshotId id2) {
        try {
            ImageData imageData;
            ScreenshotId screenshotId = id2;
            if (screenshotId instanceof LocalScreenshot) {
                imageData = this.nativeImageReader.getImageData(((LocalScreenshot)id2).getPath(), this.allocator);
            } else if (screenshotId instanceof RemoteScreenshot) {
                byte[] byArray;
                Closeable closeable = id2.open();
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    boolean bl = false;
                    byArray = ByteStreamsKt.readBytes((InputStream)it);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                ByteBuf bytes = Unpooled.wrappedBuffer((byte[])byArray);
                Intrinsics.checkNotNull((Object)bytes);
                imageData = this.nativeImageReader.getImageData(bytes, this.allocator);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            ImageData imageData2 = imageData;
            return new BufferBackedImage(imageData2);
        }
        catch (IOException e) {
            e.printStackTrace();
            return new ErrorImage();
        }
    }
}

