/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.handlers.account;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import gg.essential.Essential;
import gg.essential.gui.account.factory.MicrosoftAccountSessionFactory;
import gg.essential.gui.account.factory.SessionFactory;
import gg.essential.gui.menu.AccountManager;
import gg.essential.gui.notification.ExtensionsKt;
import gg.essential.gui.notification.Notifications;
import gg.essential.universal.UDesktop;
import gg.essential.util.Multithreading;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\u0003J\u0017\u0010\u000b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\r\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\r\u0010\fJ\u0017\u0010\u000e\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000e\u0010\fJ5\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00112\u0014\b\u0002\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0013H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0003R4\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00182\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00188\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\u00020\u00118\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00110\u00188\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b \u0010\u001bR\u001c\u0010#\u001a\n \"*\u0004\u0018\u00010!0!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$R$\u0010%\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00118\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b%\u0010\u001f\u001a\u0004\b&\u0010'R*\u0010*\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010)0(8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b*\u0010+\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u001e\u00101\u001a\n\u0012\u0004\u0012\u000200\u0018\u00010\u00188\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b1\u0010\u001bR\u0016\u00103\u001a\u0002028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b3\u00104R\u0016\u00106\u001a\u0002058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b6\u00107\u00a8\u00068"}, d2={"Lgg/essential/handlers/account/WebAccountManager;", "", "<init>", "()V", "Lgg/essential/gui/account/factory/MicrosoftAccountSessionFactory;", "getMicrosoftSessionFactory", "()Lgg/essential/gui/account/factory/MicrosoftAccountSessionFactory;", "", "openInBrowser", "Lcom/sun/net/httpserver/HttpServer;", "server", "registerAssets", "(Lcom/sun/net/httpserver/HttpServer;)V", "registerMicrosoftAccountListener", "registerPages", "Lcom/sun/net/httpserver/HttpExchange;", "exchange", "", "path", "", "data", "send", "(Lcom/sun/net/httpserver/HttpExchange;Ljava/lang/String;Ljava/util/Map;)V", "startServer", "Ljava/util/concurrent/CompletableFuture;", "<set-?>", "authorizationCodeFuture", "Ljava/util/concurrent/CompletableFuture;", "getAuthorizationCodeFuture", "()Ljava/util/concurrent/CompletableFuture;", "domain", "Ljava/lang/String;", "loginErrorFuture", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "microsoftOauthParamPattern", "Ljava/util/regex/Pattern;", "microsoftRedirectUri", "getMicrosoftRedirectUri", "()Ljava/lang/String;", "Ljava/lang/ref/WeakReference;", "Lgg/essential/gui/menu/AccountManager;", "mostRecentAccountManager", "Ljava/lang/ref/WeakReference;", "getMostRecentAccountManager", "()Ljava/lang/ref/WeakReference;", "setMostRecentAccountManager", "(Ljava/lang/ref/WeakReference;)V", "Ljava/net/URI;", "oauthUriFuture", "", "port", "I", "", "running", "Z", "Essential 1.20.1-forge"})
@SourceDebugExtension(value={"SMAP\nWebAccountManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebAccountManager.kt\ngg/essential/handlers/account/WebAccountManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,254:1\n1#2:255\n800#3,11:256\n*S KotlinDebug\n*F\n+ 1 WebAccountManager.kt\ngg/essential/handlers/account/WebAccountManager\n*L\n219#1:256,11\n*E\n"})
public final class WebAccountManager {
    @NotNull
    public static final WebAccountManager INSTANCE = new WebAccountManager();
    private static boolean running;
    private static int port;
    @NotNull
    private static String domain;
    private static final Pattern microsoftOauthParamPattern;
    @Nullable
    private static CompletableFuture<URI> oauthUriFuture;
    @NotNull
    private static String microsoftRedirectUri;
    @Nullable
    private static CompletableFuture<String> authorizationCodeFuture;
    @NotNull
    private static WeakReference<AccountManager> mostRecentAccountManager;
    @NotNull
    private static CompletableFuture<String> loginErrorFuture;

    private WebAccountManager() {
    }

    @NotNull
    public final String getMicrosoftRedirectUri() {
        return microsoftRedirectUri;
    }

    @Nullable
    public final CompletableFuture<String> getAuthorizationCodeFuture() {
        return authorizationCodeFuture;
    }

    @NotNull
    public final WeakReference<AccountManager> getMostRecentAccountManager() {
        return mostRecentAccountManager;
    }

    public final void setMostRecentAccountManager(@NotNull WeakReference<AccountManager> weakReference2) {
        Intrinsics.checkNotNullParameter(weakReference2, (String)"<set-?>");
        mostRecentAccountManager = weakReference2;
    }

    public final void openInBrowser() {
        if (!running) {
            this.startServer();
            running = true;
        }
        authorizationCodeFuture = new CompletableFuture();
        UDesktop.browse(new URI("http://localhost:" + port));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void send(HttpExchange exchange, String path, Map<String, String> data) {
        byte[] byArray;
        InputStream resource = this.getClass().getResourceAsStream(path);
        if (resource == null) {
            exchange.sendResponseHeaders(500, 0L);
            OutputStream outputStream = exchange.getResponseBody();
            byte[] byArray2 = "Internal server error. Contact support".getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
            outputStream.write(byArray2);
            exchange.getResponseBody().close();
            return;
        }
        if (StringsKt.endsWith$default((String)path, (String)"png", (boolean)false, (int)2, null)) {
            Closeable closeable = resource;
            Throwable throwable = null;
            try {
                Object it = (InputStream)closeable;
                boolean bl = false;
                it = ByteStreamsKt.readBytes((InputStream)resource);
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Object content = it;
            exchange.getResponseHeaders().add("Content-Type", "image/png");
            exchange.sendResponseHeaders(200, ((Object)content).length);
            exchange.getResponseBody().write((byte[])content);
            exchange.getResponseBody().close();
            return;
        }
        Object object = resource;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)object;
            boolean bl = false;
            byArray = ByteStreamsKt.readBytes((InputStream)resource);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        object = byArray;
        String content = new String((byte[])object, Charsets.UTF_8);
        for (String key : data.keySet()) {
            content = StringsKt.replace$default((String)content, (String)("{" + key + "}"), (String)String.valueOf(data.get(key)), (boolean)false, (int)4, null);
        }
        object = content;
        byte[] byArray3 = ((String)object).getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"getBytes(...)");
        exchange.sendResponseHeaders(200, byArray3.length);
        OutputStream outputStream = exchange.getResponseBody();
        object = content;
        byte[] byArray4 = ((String)object).getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"getBytes(...)");
        outputStream.write(byArray4);
        exchange.getResponseBody().close();
    }

    static /* synthetic */ void send$default(WebAccountManager webAccountManager, HttpExchange httpExchange, String string, Map map2, int n, Object object) {
        if ((n & 4) != 0) {
            map2 = MapsKt.emptyMap();
        }
        webAccountManager.send(httpExchange, string, map2);
    }

    private final void startServer() {
        HttpServer server = HttpServer.create(new InetSocketAddress("localhost", 0), 0);
        authorizationCodeFuture = new CompletableFuture();
        Intrinsics.checkNotNull((Object)server);
        this.registerAssets(server);
        this.registerPages(server);
        this.registerMicrosoftAccountListener(server);
        server.setExecutor(Multithreading.pool);
        server.start();
        port = server.getAddress().getPort();
        domain = "http://localhost:" + port;
        microsoftRedirectUri = domain + "/microsoft/complete";
    }

    private final void registerMicrosoftAccountListener(HttpServer server) {
        server.createContext("/microsoft/auth", WebAccountManager::registerMicrosoftAccountListener$lambda$2);
        server.createContext("/microsoft/complete", WebAccountManager::registerMicrosoftAccountListener$lambda$5);
        server.createContext("/login/microsoft", arg_0 -> WebAccountManager.registerMicrosoftAccountListener$lambda$11(this, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final MicrosoftAccountSessionFactory getMicrosoftSessionFactory() {
        void $this$filterIsInstanceTo$iv$iv;
        List<SessionFactory> list = Essential.getInstance().getSessionFactories();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getSessionFactories(...)");
        Iterable $this$filterIsInstance$iv = list;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof MicrosoftAccountSessionFactory)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (MicrosoftAccountSessionFactory)CollectionsKt.first((List)((List)destination$iv$iv));
    }

    private final void registerPages(HttpServer server) {
        server.createContext("/login/success", WebAccountManager::registerPages$lambda$12);
        server.createContext("/", WebAccountManager::registerPages$lambda$13);
    }

    private final void registerAssets(HttpServer server) {
        String[] stringArray = new String[]{"core.c28d5d87.css", "main.c766a760.js", "main.5a1fd7db.js", "microsoft.2cc0fa02", "minecraft-computer-login.5074e926.png"};
        List assets = CollectionsKt.listOf((Object[])stringArray);
        for (String asset : assets) {
            server.createContext("/" + asset, arg_0 -> WebAccountManager.registerAssets$lambda$14(asset, arg_0));
        }
    }

    private static final void registerMicrosoftAccountListener$lambda$2(HttpExchange it) {
        CompletableFuture<URI> future2 = oauthUriFuture;
        if (future2 == null) {
            System.out.println((Object)"Future not initialized");
            Intrinsics.checkNotNull((Object)it);
            INSTANCE.send(it, "/assets/essential/account/error.html", MapsKt.mapOf((Pair)TuplesKt.to((Object)"error", (Object)"Internal error please check logs")));
            return;
        }
        it.getResponseHeaders().add("Location", future2.join().toString());
        it.sendResponseHeaders(302, 0L);
        it.getResponseBody().close();
    }

    private static final void registerMicrosoftAccountListener$lambda$5(HttpExchange exchange) {
        String error2;
        Matcher matcher;
        String query = exchange.getRequestURI().getQuery();
        if (query != null && (matcher = microsoftOauthParamPattern.matcher(query)).find()) {
            Boolean bl;
            CompletableFuture<String> completableFuture = authorizationCodeFuture;
            Boolean it = bl = completableFuture != null ? Boolean.valueOf(completableFuture.complete(matcher.group("code"))) : null;
            boolean bl2 = false;
            authorizationCodeFuture = null;
            Boolean bl3 = bl;
            if (bl3 != null) {
                bl3.booleanValue();
            } else {
                WebAccountManager $this$registerMicrosoftAccountListener_u24lambda_u245_u24lambda_u244 = INSTANCE;
                boolean bl4 = false;
                System.out.println((Object)"authorizationCodeFuture == null. Perhaps the user had an extra account frame open?");
                Intrinsics.checkNotNull((Object)exchange);
                $this$registerMicrosoftAccountListener_u24lambda_u245_u24lambda_u244.send(exchange, "/assets/essential/account/error.html", MapsKt.mapOf((Pair)TuplesKt.to((Object)"error", (Object)"Error during login. Please close browser and try again.")));
                return;
            }
        }
        if ((error2 = loginErrorFuture.join()) != null) {
            Intrinsics.checkNotNull((Object)exchange);
            INSTANCE.send(exchange, "/assets/essential/account/error.html", MapsKt.mapOf((Pair)TuplesKt.to((Object)"error", (Object)error2)));
        } else {
            exchange.getResponseHeaders().add("Location", "/login/success");
            exchange.sendResponseHeaders(302, 0L);
            exchange.getResponseBody().close();
        }
    }

    private static final void registerMicrosoftAccountListener$lambda$11$lambda$10(MicrosoftAccountSessionFactory $factory, CompletableFuture $oauthUriFuture, CompletableFuture $loginErrorFuture) {
        Intrinsics.checkNotNullParameter((Object)$factory, (String)"$factory");
        Intrinsics.checkNotNullParameter((Object)$oauthUriFuture, (String)"$oauthUriFuture");
        Intrinsics.checkNotNullParameter((Object)$loginErrorFuture, (String)"$loginErrorFuture");
        try {
            UUID it = $factory.login($oauthUriFuture).getUuid();
            boolean bl = false;
            AccountManager accountManager = (AccountManager)mostRecentAccountManager.get();
            if (accountManager != null) {
                accountManager.login(it);
            }
            $loginErrorFuture.complete(null);
        }
        catch (Exception e) {
            $loginErrorFuture.complete(e.getMessage());
            AccountManager accountManager = (AccountManager)mostRecentAccountManager.get();
            if (accountManager != null) {
                AccountManager it = accountManager;
                boolean bl = false;
                ExtensionsKt.error$default(Notifications.INSTANCE, "Account Error", "Something went wrong\nduring login.", null, null, null, 28, null);
            }
            e.printStackTrace();
        }
    }

    private static final void registerMicrosoftAccountListener$lambda$11(WebAccountManager this$0, HttpExchange exchange) {
        CompletableFuture completableFuture;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        CompletableFuture it = completableFuture = new CompletableFuture();
        boolean bl = false;
        oauthUriFuture = it;
        CompletableFuture oauthUriFuture = completableFuture;
        CompletableFuture it2 = it = new CompletableFuture();
        boolean bl2 = false;
        loginErrorFuture = it2;
        CompletableFuture loginErrorFuture = it;
        authorizationCodeFuture = new CompletableFuture();
        MicrosoftAccountSessionFactory factory2 = INSTANCE.getMicrosoftSessionFactory();
        Multithreading.runAsync(() -> WebAccountManager.registerMicrosoftAccountListener$lambda$11$lambda$10(factory2, oauthUriFuture, loginErrorFuture));
        Intrinsics.checkNotNull((Object)exchange);
        INSTANCE.send(exchange, "/assets/essential/account/login/microsoft.html", MapsKt.mapOf((Pair)TuplesKt.to((Object)"location", (Object)(domain + "/microsoft/auth"))));
    }

    private static final void registerPages$lambda$12(HttpExchange it) {
        Intrinsics.checkNotNull((Object)it);
        WebAccountManager.send$default(INSTANCE, it, "/assets/essential/account/login/success.html", null, 4, null);
    }

    private static final void registerPages$lambda$13(HttpExchange exchange) {
        exchange.getResponseHeaders().add("Location", "/login/microsoft");
        exchange.sendResponseHeaders(302, 0L);
        exchange.getResponseBody().close();
    }

    private static final void registerAssets$lambda$14(String $asset, HttpExchange it) {
        Intrinsics.checkNotNullParameter((Object)$asset, (String)"$asset");
        Intrinsics.checkNotNull((Object)it);
        WebAccountManager.send$default(INSTANCE, it, "/assets/essential/account/" + $asset, null, 4, null);
    }

    static {
        domain = "https://essential.gg";
        microsoftOauthParamPattern = Pattern.compile("code=(?<code>.+)");
        microsoftRedirectUri = "https://essential.gg";
        mostRecentAccountManager = new WeakReference<Object>(null);
        loginErrorFuture = new CompletableFuture();
    }
}

