/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.ice;

import gg.essential.ice.CandidateType;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\bR\u0014\u0010\t\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\bR\u0014\u0010\n\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\bR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u0082\u0001\u0002\u0014\u0015\u00a8\u0006\u0016"}, d2={"Lgg/essential/ice/Candidate;", "", "address", "Ljava/net/InetSocketAddress;", "getAddress", "()Ljava/net/InetSocketAddress;", "isIPv6", "", "()Z", "isLinkLocal", "isRelay", "isSiteLocal", "priority", "", "getPriority", "()I", "type", "Lgg/essential/ice/CandidateType;", "getType", "()Lgg/essential/ice/CandidateType;", "Lgg/essential/ice/LocalCandidate;", "Lgg/essential/ice/RemoteCandidate;", "ice"})
public interface Candidate {
    @NotNull
    public CandidateType getType();

    @NotNull
    public InetSocketAddress getAddress();

    public int getPriority();

    public boolean isRelay();

    public boolean isIPv6();

    public boolean isLinkLocal();

    public boolean isSiteLocal();

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static boolean isRelay(@NotNull Candidate $this) {
            return $this.getType() == CandidateType.Relayed;
        }

        public static boolean isIPv6(@NotNull Candidate $this) {
            return $this.getAddress().getAddress() instanceof Inet6Address;
        }

        public static boolean isLinkLocal(@NotNull Candidate $this) {
            InetAddress inetAddress = $this.getAddress().getAddress();
            Inet6Address inet6Address = inetAddress instanceof Inet6Address ? (Inet6Address)inetAddress : null;
            return inet6Address != null ? inet6Address.isLinkLocalAddress() : false;
        }

        public static boolean isSiteLocal(@NotNull Candidate $this) {
            return $this.getAddress().getAddress().isSiteLocalAddress();
        }
    }
}

