/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.ice.stun;

import gg.essential.ice.UtilsKt;
import gg.essential.ice.stun.BindingPacer;
import gg.essential.ice.stun.StunAttribute;
import gg.essential.ice.stun.StunClass;
import gg.essential.ice.stun.StunMessage;
import gg.essential.ice.stun.StunRequest;
import gg.essential.ice.stun.StunSocket;
import gg.essential.ice.stun.StunType;
import gg.essential.ice.stun.TransactionId;
import gg.essential.ice.stun.UdpStunPacket;
import gg.essential.slf4j.ExtendedLoggerKt;
import java.net.InetSocketAddress;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.spi.LoggingEventBuilder;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001&B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0012\u001a\b\u0018\u00010\u000fR\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u000eJ\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\"\u0010\u001a\u001a\u00060\u000fR\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001fJ \u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u0015H\u0002J\u000e\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020\bR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\b\u0012\u00060\u000fR\u00020\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u0011\u0012\b\u0012\u00060\u000fR\u00020\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lgg/essential/ice/stun/StunManager;", "", "scope", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;)V", "activeRequests", "", "Lgg/essential/ice/stun/TransactionId;", "Lgg/essential/ice/stun/StunRequest;", "bindingPacer", "Lgg/essential/ice/stun/BindingPacer;", "getBindingPacer", "()Lgg/essential/ice/stun/BindingPacer;", "remoteToServer", "Ljava/net/InetSocketAddress;", "Lgg/essential/ice/stun/StunManager$StunServer;", "servers", "", "getServer", "remoteAddress", "messageReceived", "Lgg/essential/ice/stun/StunMessage;", "parentLogger", "Lorg/slf4j/Logger;", "packet", "Lgg/essential/ice/stun/StunSocket$ReceivedPacket;", "registerServer", "job", "Lkotlinx/coroutines/Job;", "ufrag", "password", "", "responseReceived", "", "logger", "message", "sendRequest", "request", "StunServer", "ice"})
@SourceDebugExtension(value={"SMAP\nStunManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StunManager.kt\ngg/essential/ice/stun/StunManager\n+ 2 StunMessage.kt\ngg/essential/ice/stun/StunMessage\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,168:1\n37#2:169\n1#3:170\n*S KotlinDebug\n*F\n+ 1 StunManager.kt\ngg/essential/ice/stun/StunManager\n*L\n109#1:169\n109#1:170\n*E\n"})
public final class StunManager {
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final BindingPacer bindingPacer;
    @NotNull
    private final Map<TransactionId, StunRequest> activeRequests;
    @NotNull
    private final Map<String, StunServer> servers;
    @NotNull
    private final Map<InetSocketAddress, StunServer> remoteToServer;

    public StunManager(@NotNull CoroutineScope scope2) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        this.scope = scope2;
        this.bindingPacer = new BindingPacer(this.scope, 0L, 2, null);
        this.activeRequests = new LinkedHashMap();
        this.servers = new LinkedHashMap();
        this.remoteToServer = new LinkedHashMap();
    }

    @NotNull
    public final BindingPacer getBindingPacer() {
        return this.bindingPacer;
    }

    public final void sendRequest(@NotNull StunRequest request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        BuildersKt.launch$default((CoroutineScope)this.scope, null, (CoroutineStart)CoroutineStart.UNDISPATCHED, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, request2, null){
            int label;
            final /* synthetic */ StunManager this$0;
            final /* synthetic */ StunRequest $request;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        StunManager.access$getActiveRequests$p(this.this$0).put(this.$request.getRequest().getTransactionId(), this.$request);
                        this.label = 1;
                        Object object3 = this.$request.start().join((Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        Object object3;
                        try {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            object3 = $result;
                            return Unit.INSTANCE;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            StunManager.access$getActiveRequests$p(this.this$0).remove(this.$request.getRequest().getTransactionId());
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    @NotNull
    public final StunServer registerServer(@NotNull Job job, @NotNull String ufrag, @NotNull byte[] password) {
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        Intrinsics.checkNotNullParameter((Object)ufrag, (String)"ufrag");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        if (!(!this.servers.containsKey(ufrag))) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        StunServer server = new StunServer(job, password);
        this.servers.put(ufrag, server);
        BuildersKt.launch$default((CoroutineScope)this.scope, null, (CoroutineStart)CoroutineStart.UNDISPATCHED, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(job, this, ufrag, server, null){
            int label;
            final /* synthetic */ Job $job;
            final /* synthetic */ StunManager this$0;
            final /* synthetic */ String $ufrag;
            final /* synthetic */ StunServer $server;
            {
                this.$job = $job;
                this.this$0 = $receiver;
                this.$ufrag = $ufrag;
                this.$server = $server;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var11_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = this.$job.join((Continuation)this);
                        ** if (v0 != var11_2) goto lbl11
lbl10:
                        // 1 sources

                        return var11_2;
lbl11:
                        // 1 sources

                        ** GOTO lbl18
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl18:
                        // 2 sources

                        this.label = 2;
                        v1 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)15, (DurationUnit)DurationUnit.SECONDS), (Continuation)((Continuation)this));
                        ** if (v1 != var11_2) goto lbl22
lbl21:
                        // 1 sources

                        return var11_2;
lbl22:
                        // 1 sources

                        ** GOTO lbl28
                    }
                    case 2: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl28:
                            // 2 sources

                            StunManager.access$getServers$p(this.this$0).remove(this.$ufrag);
                        }
                        catch (Throwable var2_4) {
                            StunManager.access$getServers$p(this.this$0).remove(this.$ufrag);
                            var3_6 = this.$server.getKnownRemotes();
                            var4_8 = this.this$0;
                            var5_10 = this.$server;
                            $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                it = (InetSocketAddress)element$iv;
                                $i$a$-forEach-StunManager$registerServer$1$1 = false;
                                StunManager.access$getRemoteToServer$p(var4_8).remove(it, var5_10);
                            }
                            throw var2_4;
                        }
                        var2_3 = this.$server.getKnownRemotes();
                        var3_5 = this.this$0;
                        var4_7 = this.$server;
                        $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            it = (InetSocketAddress)element$iv;
                            $i$a$-forEach-StunManager$registerServer$1$1 = false;
                            StunManager.access$getRemoteToServer$p(var3_5).remove(it, var4_7);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        return server;
    }

    @Nullable
    public final StunServer getServer(@NotNull InetSocketAddress remoteAddress) {
        Intrinsics.checkNotNullParameter((Object)remoteAddress, (String)"remoteAddress");
        return this.remoteToServer.get(remoteAddress);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final StunMessage messageReceived(@NotNull Logger parentLogger, @NotNull StunSocket.ReceivedPacket packet) {
        Intrinsics.checkNotNullParameter((Object)parentLogger, (String)"parentLogger");
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        try {
            var4_3 = StunMessage.Companion.decode(packet.getData(), (Function1<? super String, byte[]>)((Function1)new Function1<String, byte[]>(this){
                final /* synthetic */ StunManager this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @Nullable
                public final byte[] invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    StunServer stunServer = (StunServer)StunManager.access$getServers$p(this.this$0).get(StringsKt.substringBefore$default((String)it, (String)":", null, (int)2, null));
                    return (byte[])(stunServer != null ? stunServer.getPassword() : null);
                }
            }), (Function1<? super TransactionId, byte[]>)((Function1)new Function1<TransactionId, byte[]>(this){
                final /* synthetic */ StunManager this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @Nullable
                public final byte[] invoke(@NotNull TransactionId it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    Object object = (StunRequest)StunManager.access$getActiveRequests$p(this.this$0).get(it);
                    return object != null && (object = ((StunRequest)object).getRequest()) != null ? ((StunMessage)object).getIntegrityProtectionKey() : null;
                }
            }));
        }
        catch (Exception e) {
            parentLogger.atWarn().addKeyValue("remoteAddress", (Object)packet.getSource()).setCause((Throwable)e).log("Failed to decode STUN packet. Content: " + UtilsKt.toHexString(packet.getData()));
            return null;
        }
        message = var4_3;
        logger = ExtendedLoggerKt.with(parentLogger, (Function1<? super LoggingEventBuilder, Unit>)((Function1)new Function1<LoggingEventBuilder, Unit>(packet, message){
            final /* synthetic */ StunSocket.ReceivedPacket $packet;
            final /* synthetic */ StunMessage $message;
            {
                this.$packet = $packet;
                this.$message = $message;
                super(1);
            }

            public final void invoke(@NotNull LoggingEventBuilder $this$with) {
                Intrinsics.checkNotNullParameter((Object)$this$with, (String)"$this$with");
                $this$with.addKeyValue("remoteAddress", (Object)this.$packet.getSource());
                $this$with.addKeyValue("tId", (Object)this.$message.getTransactionId());
            }
        }));
        switch (WhenMappings.$EnumSwitchMapping$1[message.getCls().ordinal()]) {
            case 1: {
                if (!message.isIntegrityProtected()) {
                    logger.warn("Ignoring STUN request because it was missing HMAC.");
                    return null;
                }
                this_$iv = message;
                $i$f$attribute = false;
                for (StunAttribute it$iv : (Iterable)this_$iv.getAttributes()) {
                    $i$a$-firstNotNullOfOrNull-StunMessage$attribute$1$iv = false;
                    v0 = it$iv;
                    if (!(v0 instanceof StunAttribute.Username)) {
                        v0 = null;
                    }
                    if ((var11_9 = (StunAttribute)((StunAttribute.Username)v0)) == null) continue;
                    v1 = var11_9;
                    ** GOTO lbl29
                }
                v1 = null;
lbl29:
                // 2 sources

                if ((server = this.servers.get(ufrag = (v2 = (StunAttribute.Username)v1) != null && (v2 = v2.getUsername()) != null ? StringsKt.substringBefore$default((String)v2, (String)":", null, (int)2, null) : null)) != null) {
                    if (server.getKnownRemotes().add(packet.getSource())) {
                        this.remoteToServer.put(packet.getSource(), server);
                    }
                    server.getStunRequestReceiveChannel().trySend-JP2dKIU((Object)TuplesKt.to((Object)packet, (Object)message));
                    v3 = null;
                    break;
                }
                v3 = message;
                break;
            }
            case 2: {
                if (WhenMappings.$EnumSwitchMapping$0[message.getType().ordinal()] == 1) {
                    logger.trace("Got STUN Binding indication.");
                    v3 = null;
                    break;
                }
                v3 = message;
                break;
            }
            case 3: 
            case 4: {
                this.responseReceived(logger, packet, message);
                v3 = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return v3;
    }

    private final void responseReceived(Logger logger2, StunSocket.ReceivedPacket packet, StunMessage message2) {
        StunRequest request2 = this.activeRequests.remove(message2.getTransactionId());
        if (request2 == null) {
            logger2.atTrace().addKeyValue("remoteAddress", (Object)packet.getSource()).addKeyValue("tId", (Object)message2.getTransactionId()).log("Ignoring STUN response because we have no active request for that id.");
            return;
        }
        if (request2.getRequest().isIntegrityProtected() && !message2.isIntegrityProtected()) {
            logger2.atWarn().addKeyValue("remoteAddress", (Object)packet.getSource()).addKeyValue("tId", (Object)message2.getTransactionId()).log("Ignoring STUN response because it was missing HMAC.");
            return;
        }
        request2.onResponse(new UdpStunPacket(packet.getTimestamp(), packet.getSource(), message2));
    }

    public static final /* synthetic */ Map access$getActiveRequests$p(StunManager $this) {
        return $this.activeRequests;
    }

    public static final /* synthetic */ Map access$getServers$p(StunManager $this) {
        return $this.servers;
    }

    public static final /* synthetic */ Map access$getRemoteToServer$p(StunManager $this) {
        return $this.remoteToServer;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R#\u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00170\u00160\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lgg/essential/ice/stun/StunManager$StunServer;", "", "job", "Lkotlinx/coroutines/Job;", "password", "", "(Lgg/essential/ice/stun/StunManager;Lkotlinx/coroutines/Job;[B)V", "dataReceiveChannel", "Lkotlinx/coroutines/channels/Channel;", "Lgg/essential/ice/stun/StunSocket$ReceivedPacket;", "getDataReceiveChannel", "()Lkotlinx/coroutines/channels/Channel;", "getJob", "()Lkotlinx/coroutines/Job;", "knownRemotes", "", "Ljava/net/InetSocketAddress;", "getKnownRemotes", "()Ljava/util/Set;", "getPassword", "()[B", "stunRequestReceiveChannel", "Lkotlin/Pair;", "Lgg/essential/ice/stun/StunMessage;", "getStunRequestReceiveChannel", "ice"})
    public final class StunServer {
        @NotNull
        private final Job job;
        @NotNull
        private final byte[] password;
        @NotNull
        private final Set<InetSocketAddress> knownRemotes;
        @NotNull
        private final Channel<StunSocket.ReceivedPacket> dataReceiveChannel;
        @NotNull
        private final Channel<Pair<StunSocket.ReceivedPacket, StunMessage>> stunRequestReceiveChannel;

        public StunServer(@NotNull Job job, byte[] password) {
            Intrinsics.checkNotNullParameter((Object)job, (String)"job");
            Intrinsics.checkNotNullParameter((Object)password, (String)"password");
            this.job = job;
            this.password = password;
            this.knownRemotes = new LinkedHashSet();
            this.dataReceiveChannel = ChannelKt.Channel$default((int)100, null, null, (int)6, null);
            this.stunRequestReceiveChannel = ChannelKt.Channel$default((int)100, null, null, (int)6, null);
        }

        @NotNull
        public final Job getJob() {
            return this.job;
        }

        @NotNull
        public final byte[] getPassword() {
            return this.password;
        }

        @NotNull
        public final Set<InetSocketAddress> getKnownRemotes() {
            return this.knownRemotes;
        }

        @NotNull
        public final Channel<StunSocket.ReceivedPacket> getDataReceiveChannel() {
            return this.dataReceiveChannel;
        }

        @NotNull
        public final Channel<Pair<StunSocket.ReceivedPacket, StunMessage>> getStunRequestReceiveChannel() {
            return this.stunRequestReceiveChannel;
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[StunType.values().length];
            try {
                nArray[StunType.Binding.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[StunClass.values().length];
            try {
                nArray[StunClass.Request.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StunClass.Indication.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StunClass.ResponseSuccess.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StunClass.ResponseError.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

