/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.image.imagescaling;

import gg.essential.gui.screenshot.downsampling.PixelBuffer;
import gg.essential.image.imagescaling.DimensionConstrain;
import gg.essential.image.imagescaling.ProgressListener;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public abstract class AdvancedResizeOp {
    private final DimensionConstrain dimensionConstrain;
    private List<ProgressListener> listeners = new ArrayList<ProgressListener>();
    private UnsharpenMask unsharpenMask = UnsharpenMask.None;

    public AdvancedResizeOp(DimensionConstrain dimensionConstrain) {
        this.dimensionConstrain = dimensionConstrain;
    }

    protected void fireProgressChanged(float fraction) {
        for (ProgressListener progressListener : this.listeners) {
            progressListener.notifyProgress(fraction);
        }
    }

    public final PixelBuffer filter(PixelBuffer src) throws InterruptedException {
        Dimension dstDimension = this.dimensionConstrain.getDimension(new Dimension(src.getWidth(), src.getHeight()));
        int dstWidth = dstDimension.width;
        int dstHeight = dstDimension.height;
        return this.doFilter(src, dstWidth, dstHeight);
    }

    protected abstract PixelBuffer doFilter(PixelBuffer var1, int var2, int var3) throws InterruptedException;

    public static enum UnsharpenMask {
        None(0.0f),
        Soft(0.15f),
        Normal(0.3f),
        VerySharp(0.45f),
        Oversharpened(0.6f);

        private final float factor;

        private UnsharpenMask(float factor) {
            this.factor = factor;
        }
    }
}

