/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.gson;

import gg.essential.lib.gson.JsonElement;
import gg.essential.lib.gson.JsonIOException;
import gg.essential.lib.gson.JsonParseException;
import gg.essential.lib.gson.JsonSyntaxException;
import gg.essential.lib.gson.internal.Streams;
import gg.essential.lib.gson.stream.JsonReader;
import gg.essential.lib.gson.stream.JsonToken;
import gg.essential.lib.gson.stream.MalformedJsonException;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class JsonStreamParser
implements Iterator<JsonElement> {
    private final JsonReader parser;
    private final Object lock;

    public JsonStreamParser(String json2) {
        this(new StringReader(json2));
    }

    public JsonStreamParser(Reader reader2) {
        this.parser = new JsonReader(reader2);
        this.parser.setLenient(true);
        this.lock = new Object();
    }

    @Override
    public JsonElement next() throws JsonParseException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            return Streams.parse(this.parser);
        }
        catch (StackOverflowError e) {
            throw new JsonParseException("Failed parsing JSON source to Json", e);
        }
        catch (OutOfMemoryError e) {
            throw new JsonParseException("Failed parsing JSON source to Json", e);
        }
        catch (JsonParseException e) {
            throw e.getCause() instanceof EOFException ? new NoSuchElementException() : e;
        }
    }

    @Override
    public boolean hasNext() {
        Object object = this.lock;
        synchronized (object) {
            try {
                return this.parser.peek() != JsonToken.END_DOCUMENT;
            }
            catch (MalformedJsonException e) {
                throw new JsonSyntaxException(e);
            }
            catch (IOException e) {
                throw new JsonIOException(e);
            }
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

