/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.mixinextras.injector.wrapoperation;

import gg.essential.lib.mixinextras.injector.StackExtension;
import gg.essential.lib.mixinextras.injector.wrapoperation.Operation;
import gg.essential.lib.mixinextras.injector.wrapoperation.WrapOperation;
import gg.essential.lib.mixinextras.lib.apache.commons.ArrayUtils;
import gg.essential.lib.mixinextras.service.MixinExtrasService;
import gg.essential.lib.mixinextras.utils.ASMUtils;
import gg.essential.lib.mixinextras.utils.CompatibilityHelper;
import gg.essential.lib.mixinextras.utils.InjectorUtils;
import gg.essential.lib.mixinextras.utils.OperationUtils;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.spongepowered.asm.mixin.injection.code.Injector;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;

class WrapOperationInjector
extends Injector {
    private static final String NPE = Type.getInternalName(NullPointerException.class);
    private final Type operationType;

    public WrapOperationInjector(InjectionInfo info) {
        super(info, "@WrapOperation");
        this.operationType = MixinExtrasService.getInstance().changePackage(Operation.class, Type.getType((String)CompatibilityHelper.getAnnotation((InjectionInfo)this.info).desc), WrapOperation.class);
    }

    protected void inject(Target target2, InjectionNodes.InjectionNode node2) {
        this.checkTargetModifiers(target2, false);
        this.checkNode(target2, node2);
        this.wrapOperation(target2, node2);
    }

    private void checkNode(Target target2, InjectionNodes.InjectionNode node2) {
        AbstractInsnNode originalTarget = node2.getOriginalTarget();
        AbstractInsnNode currentTarget = node2.getCurrentTarget();
        if (currentTarget instanceof MethodInsnNode) {
            MethodInsnNode methodInsnNode = (MethodInsnNode)currentTarget;
            if (methodInsnNode.name.equals("<init>")) {
                throw CompatibilityHelper.makeInvalidInjectionException(this.info, String.format("%s annotation is trying to target an <init> call in %s in %s! If this is an instantiation, target the NEW instead.", new Object[]{this.annotationType, target2, this}));
            }
            return;
        }
        if (!(currentTarget instanceof FieldInsnNode) && originalTarget.getOpcode() != 193 && originalTarget.getOpcode() != 187) {
            throw CompatibilityHelper.makeInvalidInjectionException(this.info, String.format("%s annotation is targeting an invalid insn in %s in %s", new Object[]{this.annotationType, target2, this}));
        }
    }

    private void wrapOperation(Target target2, InjectionNodes.InjectionNode node2) {
        StackExtension stack = new StackExtension(target2);
        AbstractInsnNode initialTarget = node2.getCurrentTarget();
        InsnList insns = new InsnList();
        boolean isNew = initialTarget.getOpcode() == 187;
        boolean isDupedNew = InjectorUtils.isDupedNew(node2);
        if (isNew) {
            node2.decorate("mixinextras_wrappedOperation", (Object)true);
            node2 = target2.addInjectionNode((AbstractInsnNode)ASMUtils.findInitNodeFor(target2, (TypeInsnNode)initialTarget));
        }
        Type[] argTypes = this.getCurrentArgTypes(node2);
        Type returnType = this.getReturnType(node2);
        AbstractInsnNode champion = this.invokeHandler(target2, node2, argTypes, returnType, insns, stack);
        if (isDupedNew) {
            target2.insns.set(initialTarget, (AbstractInsnNode)new InsnNode(1));
            stack.extra(1);
            insns.add((AbstractInsnNode)new InsnNode(91));
            insns.add((AbstractInsnNode)new InsnNode(87));
            insns.add((AbstractInsnNode)new InsnNode(87));
            insns.add((AbstractInsnNode)new InsnNode(87));
        } else if (isNew) {
            target2.insns.set(initialTarget, (AbstractInsnNode)new InsnNode(0));
            insns.add((AbstractInsnNode)new InsnNode(87));
        }
        AbstractInsnNode finalTarget = node2.getCurrentTarget();
        target2.wrapNode(finalTarget, champion, insns, new InsnList());
        if (isNew) {
            target2.getInjectionNode(initialTarget).replace(champion);
        }
        node2.decorate("mixinextras_wrappedOperation", (Object)true);
        target2.insns.remove(finalTarget);
    }

    private AbstractInsnNode invokeHandler(Target target2, InjectionNodes.InjectionNode node2, Type[] argTypes, Type returnType, InsnList insns, StackExtension stack) {
        boolean hasExtraThis;
        Injector.InjectorData handler = new Injector.InjectorData(target2, "operation wrapper");
        boolean bl = hasExtraThis = node2.isReplaced() && node2.getCurrentTarget().getOpcode() != 184;
        if (hasExtraThis) {
            argTypes = ArrayUtils.remove(argTypes, 0);
        }
        Type[] originalArgs = this.getOriginalArgTypes(node2);
        this.validateParams(handler, returnType, ArrayUtils.add(originalArgs, this.operationType));
        int[] argMap = this.storeArgs(target2, argTypes, insns, 0);
        if (hasExtraThis) {
            insns.add((AbstractInsnNode)new InsnNode(87));
        }
        if (!this.isStatic) {
            insns.add((AbstractInsnNode)new VarInsnNode(25, 0));
        }
        this.pushArgs(this.methodArgs, insns, argMap, 0, originalArgs.length);
        if (hasExtraThis) {
            insns.add((AbstractInsnNode)new VarInsnNode(25, 0));
        }
        this.pushArgs(argTypes, insns, argMap, originalArgs.length, argMap.length);
        this.makeOperation(target2, originalArgs, returnType, node2, insns, hasExtraThis, ArrayUtils.subarray(argTypes, originalArgs.length, argTypes.length));
        if (handler.captureTargetArgs > 0) {
            this.pushArgs(target2.arguments, insns, target2.getArgIndices(), 0, handler.captureTargetArgs);
        }
        stack.receiver(this.isStatic);
        stack.extra(1);
        stack.capturedArgs(target2.arguments, handler.captureTargetArgs);
        AbstractInsnNode champion = super.invokeHandler(insns);
        if (InjectorUtils.isDynamicInstanceofRedirect(node2)) {
            insns.add((AbstractInsnNode)new InsnNode(95));
            insns.add((AbstractInsnNode)new InsnNode(87));
        }
        return champion;
    }

    private void makeOperation(Target target2, Type[] argTypes, Type returnType, InjectionNodes.InjectionNode node2, InsnList insns, boolean hasExtraThis, Type[] trailingParams) {
        OperationUtils.makeOperation(argTypes, returnType, insns, hasExtraThis, trailingParams, this.classNode, this.operationType, this.getName(node2.getCurrentTarget()), (paramArrayIndex, loadArgs) -> this.copyNode(node2, paramArrayIndex, target2, loadArgs));
    }

    private InsnList copyNode(InjectionNodes.InjectionNode node2, int paramArrayIndex, Target target2, Consumer<InsnList> loadArgs) {
        AbstractInsnNode ldc;
        AbstractInsnNode currentTarget = node2.getCurrentTarget();
        InsnList insns = new InsnList();
        if (currentTarget instanceof MethodInsnNode) {
            MethodInsnNode methodInsnNode = (MethodInsnNode)currentTarget;
            if (methodInsnNode.name.equals("<init>")) {
                insns.add((AbstractInsnNode)new TypeInsnNode(187, methodInsnNode.owner));
                insns.add((AbstractInsnNode)new InsnNode(89));
            }
        }
        loadArgs.accept(insns);
        insns.add(currentTarget.clone(Collections.emptyMap()));
        if (InjectorUtils.isDynamicInstanceofRedirect(node2)) {
            insns.add((AbstractInsnNode)new VarInsnNode(25, paramArrayIndex));
            insns.add((AbstractInsnNode)new InsnNode(3));
            insns.add((AbstractInsnNode)new InsnNode(50));
            insns.add((AbstractInsnNode)new InsnNode(95));
            this.checkAndMoveNodes(target2.insns, insns, currentTarget, it -> it.getOpcode() == 89, it -> it.getOpcode() == 199, it -> it.getOpcode() == 187 && ((TypeInsnNode)it).desc.equals(NPE), it -> it.getOpcode() == 89, it -> it instanceof LdcInsnNode && ((LdcInsnNode)it).cst instanceof String, it -> it.getOpcode() == 183 && ((MethodInsnNode)it).owner.equals(NPE), it -> it.getOpcode() == 191, it -> it instanceof LabelNode, it -> it.getOpcode() == 95, it -> it.getOpcode() == 89, it -> it.getOpcode() == 198, it -> it.getOpcode() == 182 && ((MethodInsnNode)it).name.equals("getClass"), it -> it.getOpcode() == 182 && ((MethodInsnNode)it).name.equals("isAssignableFrom"), it -> it.getOpcode() == 167, it -> it instanceof LabelNode, it -> it.getOpcode() == 87, it -> it.getOpcode() == 87, it -> it.getOpcode() == 3, it -> it instanceof LabelNode);
        }
        if (InjectorUtils.isDupedFactoryRedirect(node2) && (ldc = InjectorUtils.findFactoryRedirectThrowString(target2, currentTarget)) != null) {
            this.checkAndMoveNodes(target2.insns, insns, currentTarget, it -> it.getOpcode() == 89, it -> it.getOpcode() == 199, it -> it.getOpcode() == 187 && ((TypeInsnNode)it).desc.equals(NPE), it -> it.getOpcode() == 89, it -> it == ldc, it -> it.getOpcode() == 183 && ((MethodInsnNode)it).name.equals("<init>"), it -> it.getOpcode() == 191, it -> it instanceof LabelNode);
        }
        return insns;
    }

    @SafeVarargs
    private final void checkAndMoveNodes(InsnList from2, InsnList to, AbstractInsnNode node2, Predicate<AbstractInsnNode> ... predicates) {
        AbstractInsnNode current = node2.getNext();
        for (Predicate<AbstractInsnNode> predicate : predicates) {
            if (!predicate.test(current)) {
                throw new AssertionError((Object)"Failed assertion when wrapping instructions. Please inform LlamaLad7!");
            }
            AbstractInsnNode old = current;
            while ((current = current.getNext()) instanceof FrameNode) {
            }
            from2.remove(old);
            to.add(old);
        }
    }

    private Type getReturnType(InjectionNodes.InjectionNode node2) {
        AbstractInsnNode originalTarget = node2.getOriginalTarget();
        AbstractInsnNode currentTarget = node2.getCurrentTarget();
        if (originalTarget.getOpcode() == 193) {
            return Type.BOOLEAN_TYPE;
        }
        if (currentTarget instanceof MethodInsnNode) {
            MethodInsnNode methodInsnNode = (MethodInsnNode)currentTarget;
            if (methodInsnNode.name.equals("<init>")) {
                return Type.getObjectType((String)methodInsnNode.owner);
            }
            return Type.getReturnType((String)methodInsnNode.desc);
        }
        if (currentTarget instanceof FieldInsnNode) {
            FieldInsnNode fieldInsnNode = (FieldInsnNode)currentTarget;
            if (fieldInsnNode.getOpcode() == 180 || fieldInsnNode.getOpcode() == 178) {
                return Type.getType((String)fieldInsnNode.desc);
            }
            return Type.VOID_TYPE;
        }
        throw new UnsupportedOperationException();
    }

    private Type[] getOriginalArgTypes(InjectionNodes.InjectionNode node2) {
        if (node2.hasDecoration("mixinextras_newArgTypes")) {
            return (Type[])node2.getDecoration("mixinextras_newArgTypes");
        }
        return this.getEffectiveArgTypes(node2.getOriginalTarget());
    }

    private Type[] getCurrentArgTypes(InjectionNodes.InjectionNode node2) {
        return this.getEffectiveArgTypes(node2.getCurrentTarget());
    }

    private Type[] getEffectiveArgTypes(AbstractInsnNode node2) {
        if (node2 instanceof MethodInsnNode) {
            MethodInsnNode methodInsnNode = (MethodInsnNode)node2;
            Type[] args = Type.getArgumentTypes((String)methodInsnNode.desc);
            if (methodInsnNode.name.equals("<init>")) {
                return args;
            }
            switch (methodInsnNode.getOpcode()) {
                case 184: {
                    break;
                }
                case 183: {
                    args = ArrayUtils.add(args, 0, Type.getObjectType((String)this.classNode.name));
                    break;
                }
                default: {
                    args = ArrayUtils.add(args, 0, Type.getObjectType((String)methodInsnNode.owner));
                }
            }
            return args;
        }
        if (node2 instanceof FieldInsnNode) {
            FieldInsnNode fieldInsnNode = (FieldInsnNode)node2;
            switch (fieldInsnNode.getOpcode()) {
                case 180: {
                    return new Type[]{Type.getObjectType((String)fieldInsnNode.owner)};
                }
                case 181: {
                    return new Type[]{Type.getObjectType((String)fieldInsnNode.owner), Type.getType((String)fieldInsnNode.desc)};
                }
                case 178: {
                    return new Type[0];
                }
                case 179: {
                    return new Type[]{Type.getType((String)fieldInsnNode.desc)};
                }
            }
        }
        if (node2.getOpcode() == 193) {
            return new Type[]{Type.getType(Object.class)};
        }
        throw new UnsupportedOperationException();
    }

    private String getName(AbstractInsnNode node2) {
        if (node2 instanceof MethodInsnNode) {
            MethodInsnNode methodInsnNode = (MethodInsnNode)node2;
            if (methodInsnNode.name.equals("<init>")) {
                String desc = methodInsnNode.owner;
                return "new" + desc.substring(desc.lastIndexOf(47) + 1);
            }
            return ((MethodInsnNode)node2).name;
        }
        if (node2 instanceof FieldInsnNode) {
            return ((FieldInsnNode)node2).name;
        }
        if (node2.getOpcode() == 193) {
            String desc = ((TypeInsnNode)node2).desc;
            return "instanceof" + desc.substring(desc.lastIndexOf(47) + 1);
        }
        throw new UnsupportedOperationException();
    }
}

