/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.mixinextras.utils;

import gg.essential.lib.mixinextras.lib.apache.commons.ClassUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class ProxyUtils {
    public static <T> T getProxy(Object impl, Class<T> interfaceClass) {
        if (interfaceClass.isInstance(impl)) {
            return interfaceClass.cast(impl);
        }
        String simpleName = interfaceClass.getSimpleName();
        if (ClassUtils.getAllInterfaces(impl.getClass()).stream().anyMatch(it -> it.getName().endsWith('.' + simpleName))) {
            return (T)Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, (proxy, method, args) -> {
                Method original = impl.getClass().getMethod(method.getName(), method.getParameterTypes());
                original.setAccessible(true);
                return original.invoke(impl, args);
            });
        }
        throw new UnsupportedOperationException(String.format("Cannot get a %s instance from %s", simpleName, impl));
    }
}

