/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.websocket;

import gg.essential.lib.websocket.WebSocketImpl;
import gg.essential.lib.websocket.WrappedByteChannel;
import gg.essential.lib.websocket.enums.Role;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;

public class SocketChannelIOHelper {
    private SocketChannelIOHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean read(ByteBuffer buf, WebSocketImpl ws, ByteChannel channel2) throws IOException {
        buf.clear();
        int read2 = channel2.read(buf);
        buf.flip();
        if (read2 == -1) {
            ws.eot();
            return false;
        }
        return read2 != 0;
    }

    public static boolean readMore(ByteBuffer buf, WebSocketImpl ws, WrappedByteChannel channel2) throws IOException {
        buf.clear();
        int read2 = channel2.readMore(buf);
        buf.flip();
        if (read2 == -1) {
            ws.eot();
            return false;
        }
        return channel2.isNeedRead();
    }

    public static boolean batch(WebSocketImpl ws, ByteChannel sockchannel) throws IOException {
        if (ws == null) {
            return false;
        }
        ByteBuffer buffer = (ByteBuffer)ws.outQueue.peek();
        WrappedByteChannel c = null;
        if (buffer == null) {
            if (sockchannel instanceof WrappedByteChannel && (c = (WrappedByteChannel)sockchannel).isNeedWrite()) {
                c.writeMore();
            }
        } else {
            do {
                sockchannel.write(buffer);
                if (buffer.remaining() > 0) {
                    return false;
                }
                ws.outQueue.poll();
            } while ((buffer = (ByteBuffer)ws.outQueue.peek()) != null);
        }
        if (ws.outQueue.isEmpty() && ws.isFlushAndClose() && ws.getDraft() != null && ws.getDraft().getRole() != null && ws.getDraft().getRole() == Role.SERVER) {
            ws.closeConnection();
        }
        return c == null || !((WrappedByteChannel)sockchannel).isNeedWrite();
    }
}

